/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.action.DockingActionIf;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.plugin.core.navigation.NextHighlightedRangeAction;
import ghidra.app.plugin.core.navigation.PreviousHighlightedRangeAction;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Navigation", shortDescription="Navigate highlights", description="Adds actions for navigating to the next/previous highlight in the code browser or byte viewer")
public class NextPrevHighlightRangePlugin
extends Plugin {
    static final String ACTION_SUB_GROUP = "2";
    private NavigationOptions navOptions;
    private NextHighlightedRangeAction nextAction;
    private PreviousHighlightedRangeAction previousAction;

    public NextPrevHighlightRangePlugin(PluginTool tool) {
        super(tool);
        this.navOptions = new NavigationOptions(tool);
        this.createActions();
    }

    protected void dispose() {
        this.navOptions.dispose();
        super.dispose();
    }

    private void createActions() {
        this.nextAction = new NextHighlightedRangeAction(this.tool, this.getName(), this.navOptions);
        this.tool.addAction((DockingActionIf)this.nextAction);
        this.previousAction = new PreviousHighlightedRangeAction(this.tool, this.getName(), this.navOptions);
        this.tool.addAction((DockingActionIf)this.previousAction);
    }
}

