/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.ui.ControlPanelWidget;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectionScopeWidget
extends ControlPanelWidget {
    private JRadioButton searchAllRB;
    private JRadioButton searchSelectionRB;
    private List<AddressRange> searchRanges = new ArrayList<AddressRange>();
    private InstructionSearchDialog dialog;
    private InstructionSearchPlugin plugin;

    public SelectionScopeWidget(InstructionSearchPlugin plugin, String title, InstructionSearchDialog dialog) {
        super(title);
        this.plugin = plugin;
        this.dialog = dialog;
    }

    public List<AddressRange> getSearchRange() {
        if (this.searchAllRB.isSelected()) {
            this.updateSearchRangeAll();
        } else {
            this.updateSearchRangeBySelection();
        }
        return this.searchRanges;
    }

    public void updateSearchRangeAll() {
        if (this.plugin == null) {
            return;
        }
        this.searchRanges.clear();
        AddressRangeIterator iterator = this.plugin.getCurrentProgram().getMemory().getLoadedAndInitializedAddressSet().getAddressRanges();
        while (iterator.hasNext()) {
            this.searchRanges.add((AddressRange)iterator.next());
        }
    }

    public void updateSearchRangeBySelection() {
        if (!this.searchSelectionRB.isSelected()) {
            return;
        }
        this.searchRanges.clear();
        if (this.plugin.getProgramSelection() == null) {
            return;
        }
        if (this.plugin.getProgramSelection().getMinAddress() == null || this.plugin.getProgramSelection().getMaxAddress() == null) {
            return;
        }
        AddressRangeIterator iter = this.plugin.getProgramSelection().getAddressRanges();
        while (iter.hasNext()) {
            this.searchRanges.add((AddressRange)iter.next());
        }
    }

    @Override
    protected JPanel createContent() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 0));
        contentPanel.setAlignmentX(0.0f);
        this.searchAllRB = this.createSearchRB(new SearchAllAction(), "Entire Program", "When active, the entire program will be used for the search.");
        this.searchAllRB.setSelected(true);
        contentPanel.add(this.searchAllRB);
        this.searchSelectionRB = this.createSearchRB(new SearchSelectionAction(), "Search Selection", "When active, code selections on the listing will change the search range.");
        contentPanel.add(this.searchSelectionRB);
        ButtonGroup group = new ButtonGroup();
        group.add(this.searchAllRB);
        group.add(this.searchSelectionRB);
        return contentPanel;
    }

    private JRadioButton createSearchRB(AbstractAction action, String name, String tooltip) {
        JRadioButton button = new JRadioButton(action);
        button.setName(name);
        button.setText(name);
        button.setToolTipText(tooltip);
        button.setAlignmentX(0.0f);
        return button;
    }

    private class SearchAllAction
    extends AbstractAction {
        private SearchAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SelectionScopeWidget.this.updateSearchRangeAll();
            SelectionScopeWidget.this.dialog.getMessagePanel().clear();
        }
    }

    private class SearchSelectionAction
    extends AbstractAction {
        private SearchSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SelectionScopeWidget.this.updateSearchRangeBySelection();
            SelectionScopeWidget.this.dialog.getMessagePanel().clear();
        }
    }
}

