/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.data.DataAction;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

public class RecentlyUsedAction
extends DataAction {
    private static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(89, 0);
    private static final String GROUP_NAME = "Z_RECENT";

    public RecentlyUsedAction(DataPlugin plugin) {
        super("Recently Used", GROUP_NAME, (DataType)new ByteDataType(), plugin);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Recently_Used"));
    }

    @Override
    protected KeyStroke getDefaultKeyStroke() {
        return DEFAULT_KEY_STROKE;
    }

    @Override
    protected void initKeyStroke(KeyStroke keyStroke) {
        if (!DEFAULT_KEY_STROKE.equals(keyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        DataType recentDataType = this.getRecentDataType();
        this.updatePopupMenu(recentDataType);
        if (recentDataType == null) {
            return false;
        }
        this.dataType = recentDataType;
        boolean enabled = super.isEnabledForContext(context);
        return enabled;
    }

    private DataType getRecentDataType() {
        DataTypeManagerService service = (DataTypeManagerService)this.plugin.getTool().getService(DataTypeManagerService.class);
        if (service == null) {
            return null;
        }
        return service.getRecentlyUsed();
    }

    private void updatePopupMenu(DataType dt) {
        String displayName;
        MenuData popupData = this.getPopupMenuData();
        String string = displayName = dt == null ? "<empty>" : dt.getDisplayName();
        if (popupData != null) {
            popupData.setMenuPath(new String[]{"Data", "Last Used: " + displayName});
        } else {
            this.setPopupMenuData(new MenuData(new String[]{"Data", "Last Used: " + displayName}, GROUP_NAME));
        }
    }
}

