/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.util.ConflictUtility;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConflictInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String conflictType;
    private int conflictNum;
    private int totalConflicts;
    private Address minAddress;
    private Address maxAddress;
    private long addressNum;
    private long totalAddresses;
    private boolean isCodeUnit;
    private JLabel eastLabel;
    private JLabel westLabel;
    private String registerName;

    public ConflictInfoPanel() {
        this.create();
    }

    private void create() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Resolve Current Conflict"));
        this.westLabel = new JLabel("<html></html>");
        this.eastLabel = new JLabel("<html></html>");
        this.add((Component)this.westLabel, "West");
        this.add((Component)this.eastLabel, "East");
    }

    String getConflictType() {
        return this.conflictType;
    }

    Address getAddress() {
        return this.minAddress;
    }

    AddressRange getAddressRange() {
        return new AddressRangeImpl(this.minAddress, this.maxAddress);
    }

    void setConflictType(String conflictType) {
        this.conflictType = conflictType;
        TitledBorder tBorder = (TitledBorder)this.getBorder();
        tBorder.setTitle("Resolve " + conflictType + " Conflict");
    }

    void setConflictInfo(int conflictNum, int totalConflicts) {
        this.conflictNum = conflictNum;
        this.totalConflicts = totalConflicts;
        this.updateWest();
    }

    void setRegisterInfo(String registerName) {
        this.registerName = registerName;
        this.westLabel.setText(ConflictUtility.wrapAsHTML(this.getRegisterText()));
    }

    private String getRegisterText() {
        StringBuffer buf = new StringBuffer();
        buf.append("Register: ");
        buf.append(ConflictUtility.getEmphasizeString(this.registerName));
        buf.append("");
        return buf.toString();
    }

    void setAddressInfo(Address address, long addressNum, long totalAddresses) {
        this.isCodeUnit = false;
        this.minAddress = address;
        this.maxAddress = address;
        this.addressNum = addressNum;
        this.totalAddresses = totalAddresses;
        this.updateEast();
    }

    void setCodeUnitInfo(AddressRange addressRange, int addressNum, int totalAddresses) {
        this.isCodeUnit = true;
        this.minAddress = addressRange.getMinAddress();
        this.maxAddress = addressRange.getMaxAddress();
        this.addressNum = addressNum;
        this.totalAddresses = totalAddresses;
        this.updateEast();
    }

    private void addCount(StringBuffer buf, long value) {
        buf.append("<font color=\"#990000\">" + value + "</font>");
    }

    private void addAddress(StringBuffer buf, Address addr) {
        buf.append("<font color=\"#990000\">" + addr.toString() + "</font>");
    }

    private void updateWest() {
        StringBuffer buf = new StringBuffer();
        buf.append("Conflict #");
        this.addCount(buf, this.conflictNum);
        buf.append(" of ");
        this.addCount(buf, this.totalConflicts);
        if (this.isCodeUnit) {
            buf.append(" for address range: ");
            this.addAddress(buf, this.minAddress);
            buf.append("-");
            this.addAddress(buf, this.maxAddress);
        } else if (this.minAddress != null) {
            buf.append(" @ address: ");
            this.addAddress(buf, this.minAddress);
        }
        this.westLabel.setText(ConflictUtility.wrapAsHTML(buf.toString()));
    }

    private void updateEast() {
        StringBuffer buf = new StringBuffer();
        if (this.isCodeUnit) {
            buf.append("Address range #");
        } else {
            buf.append("Address #");
        }
        this.addCount(buf, this.addressNum);
        buf.append(" of ");
        this.addCount(buf, this.totalAddresses);
        buf.append(" with conflicts");
        this.eastLabel.setText(ConflictUtility.wrapAsHTML(buf.toString()));
    }
}

