/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.CompositeMember;
import ghidra.app.util.bin.format.pdb.PdbParserNEW;
import ghidra.app.util.bin.format.pdb.PdbUtil;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.SAXParseException;

public class ApplyDataTypes {
    private PdbParserNEW pdbParser;
    private boolean isClasses;
    private MessageLog log;
    private List<XmlTreeNode> todo = new ArrayList<XmlTreeNode>();

    ApplyDataTypes(PdbParserNEW pdbParser, XmlPullParser xmlParser, boolean isClasses, TaskMonitor monitor, MessageLog log) throws CancelledException, SAXParseException {
        this.pdbParser = pdbParser;
        this.isClasses = isClasses;
        this.log = log;
        this.preProcessDataTypeList(xmlParser, monitor);
    }

    void dispose() {
        this.todo.clear();
    }

    void buildDataTypes(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Building PDB datatypes... ");
        for (XmlTreeNode node : this.todo) {
            monitor.checkCanceled();
            XmlElement elem = node.getStartElement();
            String name = SymbolUtilities.replaceInvalidChars((String)elem.getAttribute("name"), (boolean)false);
            String kind = this.isClasses ? "Structure" : elem.getAttribute("kind");
            int length = XmlUtilities.parseInt((String)elem.getAttribute("length"));
            DataType cachedDataType = this.pdbParser.getCachedDataType(name);
            if (!(cachedDataType instanceof Composite && cachedDataType.getCategoryPath().equals((Object)this.pdbParser.getCategory(name, true)) && this.pdbParser.isCorrectKind(cachedDataType, kind))) {
                this.log.appendMsg("Error: Conflicting data type name: " + name);
                continue;
            }
            Composite composite = (Composite)cachedDataType;
            PdbUtil.clearComponents(composite);
            if (!CompositeMember.applyDataTypeMembers(this.pdbParser, composite, length, node, monitor)) {
                PdbUtil.clearComponents(composite);
            }
            boolean hasFlexibleArray = false;
            if (composite instanceof Structure) {
                hasFlexibleArray = ((Structure)composite).hasFlexibleArrayComponent();
            }
            if (this.isClasses || hasFlexibleArray) continue;
            PdbUtil.ensureSize(length, composite, this.log);
        }
    }

    private boolean isDataTypeClass(XmlTreeNode node, TaskMonitor monitor) throws CancelledException {
        if (!node.getStartElement().getName().equals("datatype")) {
            return false;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            XmlTreeNode childNode = node.getChildAt(i);
            XmlElement child = childNode.getStartElement();
            String datatype = child.getAttribute("datatype");
            if (!"Function".equals(datatype)) continue;
            return true;
        }
        return false;
    }

    private void preProcessDataTypeList(XmlPullParser xmlParser, TaskMonitor monitor) throws SAXParseException, CancelledException {
        monitor.setMessage("Pre-processing PDB datatypes...");
        String elementType = this.isClasses ? "classes" : "datatypes";
        HashMap<String, XmlTreeNode> todoNames = new HashMap<String, XmlTreeNode>();
        while (xmlParser.hasNext()) {
            String kind;
            monitor.checkCanceled();
            XmlElement elem = xmlParser.peek();
            if (elem.isEnd() && elem.getName().equals(elementType)) {
                xmlParser.next();
                break;
            }
            String name = SymbolUtilities.replaceInvalidChars((String)elem.getAttribute("name"), (boolean)false);
            XmlTreeNode node = new XmlTreeNode(xmlParser);
            if (todoNames.containsKey(name)) {
                XmlTreeNode todoNode = (XmlTreeNode)todoNames.get(name);
                if (!elem.toString().equals(todoNode.getStartElement().toString())) continue;
            }
            if (this.isClasses || this.isDataTypeClass(node, monitor)) {
                this.pdbParser.predefineClass(name);
            }
            todoNames.put(name, node);
            String string = kind = this.isClasses ? "Structure" : elem.getAttribute("kind");
            if (this.pdbParser.getCachedDataType(name) != null) {
                this.log.appendMsg("Error: Data type name collision - unable to define " + kind + ": " + name);
                continue;
            }
            this.todo.add(node);
            Composite composite = this.pdbParser.createComposite(kind, name);
            if (composite == null) {
                this.log.appendMsg("Unsupported datatype kind (" + kind + "): " + name);
                continue;
            }
            if (!this.isClasses) {
                int length = XmlUtilities.parseInt((String)elem.getAttribute("length"));
                PdbUtil.ensureSize(length, composite, this.log);
            }
            this.pdbParser.cacheDataType(name, (DataType)composite);
        }
        todoNames.clear();
        todoNames = null;
    }
}

