/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.gzip;

import ghidra.file.formats.gzip.GZipFileSystemFactory;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

@FileSystemInfo(type="gzip", description="GZIP", priority=-10, factory=GZipFileSystemFactory.class)
public class GZipFileSystem
implements GFileSystem {
    public static final String GZIP_PAYLOAD_FILENAME = "gzip_decompressed";
    private final FSRLRoot fsFSRL;
    private final FSRL containerFSRL;
    private final FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private final SingleFileSystemIndexHelper fsIndex;
    private final FileSystemService fsService;
    private GFile payload;
    private String origFilename;
    private String payloadKey;
    private String origComment;
    private long origDate;
    private long containerSize;

    public GZipFileSystem(FSRL containerFSRL, FSRLRoot fsFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        this.fsFSRL = fsFSRL;
        this.containerFSRL = containerFSRL;
        this.fsService = fsService;
        this.readGzipMetadata(containerFile, monitor);
        FileCacheEntry fce = this.getPayloadFileCacheEntry(monitor);
        this.fsIndex = new SingleFileSystemIndexHelper((GFileSystem)this, fsFSRL, this.origFilename, fce.file.length(), fce.md5);
        this.payload = this.fsIndex.getPayloadFile();
    }

    private void readGzipMetadata(File containerFile, TaskMonitor monitor) throws IOException {
        this.containerSize = containerFile.length();
        try (GzipCompressorInputStream gzcis = new GzipCompressorInputStream((InputStream)new FileInputStream(containerFile));){
            GzipParameters metaData = gzcis.getMetaData();
            this.origFilename = metaData.getFilename();
            this.origFilename = this.origFilename == null ? GZIP_PAYLOAD_FILENAME : FSUtilities.getSafeFilename((String)this.origFilename);
            this.origComment = metaData.getComment();
            this.origDate = metaData.getModificationTime();
            this.payloadKey = "uncompressed " + this.origFilename;
        }
    }

    private FileCacheEntry getPayloadFileCacheEntry(TaskMonitor monitor) throws CancelledException, IOException {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, this.containerSize);
        FileCacheEntry derivedFile = this.fsService.getDerivedFile(this.containerFSRL, this.payloadKey, srcFile -> new GzipCompressorInputStream((InputStream)new FileInputStream(srcFile)), (TaskMonitor)upwtm);
        return derivedFile;
    }

    public GFile getPayloadFile() {
        return this.payload;
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        this.payload = null;
    }

    public boolean isClosed() {
        return this.fsIndex.isClosed();
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndex.lookup(path);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.payload.equals(file)) {
            FileCacheEntry fce = this.getPayloadFileCacheEntry(monitor);
            return new FileInputStream(fce.file);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndex.getListing(directory);
    }

    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        if (this.payload.equals(file)) {
            return FSUtilities.infoMapToString(this.getInfoMap());
        }
        return null;
    }

    public Map<String, String> getInfoMap() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Name", this.payload.getName());
        info.put("Size", Long.toString(this.payload.getLength()));
        info.put("Compressed Size", Long.toString(this.containerSize));
        info.put("Date", this.origDate != 0L ? new Date(this.origDate).toString() : "unknown");
        info.put("Comment", this.origComment != null ? this.origComment : "unknown");
        info.put("MD5", this.payload.getFSRL().getMD5());
        return info;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

