/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4Mmp
implements StructConverter {
    private int mmp_magic;
    private int mmp_seq;
    private long mmp_time;
    private byte[] mmp_nodename;
    private byte[] mmp_bdevname;
    private short mmp_check_interval;
    private short mmp_pad1;
    private int[] mmp_pad2;
    private int mmp_checksum;

    public Ext4Mmp(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4Mmp(BinaryReader reader) throws IOException {
        this.mmp_magic = reader.readNextInt();
        this.mmp_seq = reader.readNextInt();
        this.mmp_time = reader.readNextLong();
        this.mmp_nodename = reader.readNextByteArray(64);
        this.mmp_bdevname = reader.readNextByteArray(32);
        this.mmp_check_interval = reader.readNextShort();
        this.mmp_pad1 = reader.readNextShort();
        this.mmp_pad2 = reader.readNextIntArray(226);
        this.mmp_checksum = reader.readNextInt();
    }

    public int getMmp_magic() {
        return this.mmp_magic;
    }

    public int getMmp_seq() {
        return this.mmp_seq;
    }

    public long getMmp_time() {
        return this.mmp_time;
    }

    public byte[] getMmp_nodename() {
        return this.mmp_nodename;
    }

    public byte[] getMmp_bdevname() {
        return this.mmp_bdevname;
    }

    public short getMmp_check_interval() {
        return this.mmp_check_interval;
    }

    public short getMmp_pad1() {
        return this.mmp_pad1;
    }

    public int[] getMmp_pad2() {
        return this.mmp_pad2;
    }

    public int getMmp_checksum() {
        return this.mmp_checksum;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("mmp_struct", 0);
        structure.add(DWORD, "mmp_magic", null);
        structure.add(DWORD, "mmp_seq", null);
        structure.add(QWORD, "mmp_time", null);
        structure.add((DataType)new ArrayDataType(BYTE, 64, BYTE.getLength()), "mmp_nodename", null);
        structure.add((DataType)new ArrayDataType(BYTE, 32, BYTE.getLength()), "mmp_bdevname", null);
        structure.add(WORD, "mmp_check_interval", null);
        structure.add(WORD, "mmp_pad1", null);
        structure.add((DataType)new ArrayDataType(DWORD, 226, DWORD.getLength()), "mmp_pad2", null);
        structure.add(DWORD, "mmp_checksum", null);
        return structure;
    }
}

