/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cpio;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;

@FileSystemInfo(type="cpio", description="CPIO", factory=GFileSystemBaseFactory.class)
public class CpioFileSystem
extends GFileSystemBase {
    private Map<GFile, CpioArchiveEntry> map = new HashMap<GFile, CpioArchiveEntry>();

    public CpioFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] signature = this.provider.readBytes(0L, 16L);
        return CpioArchiveInputStream.matches((byte[])signature, (int)16);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Opening CPIO...");
        byte[] bytes = this.provider.readBytes(0L, this.provider.length());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try (CpioArchiveInputStream cpioInputStream = new CpioArchiveInputStream((InputStream)inputStream);){
            while (!monitor.isCancelled()) {
                try {
                    CpioArchiveEntry entry = cpioInputStream.getNextCPIOEntry();
                    if (entry == null) {
                        break;
                    }
                    this.readEntryContents(cpioInputStream, monitor);
                    this.storeEntry(entry, monitor);
                }
                catch (EOFException e) {
                    break;
                }
                catch (Exception e) {
                    FSUtilities.displayException((Object)((Object)this), null, (String)"Error While Opening CPIO", (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void close() throws IOException {
        super.close();
        this.map.clear();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.map.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.map.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        CpioArchiveEntry entry = this.map.get(file);
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("Name: " + entry.getName() + "\n");
            buffer.append("Checksum: " + Long.toHexString(entry.getChksum()) + "\n");
            buffer.append("Format: " + Long.toHexString(entry.getFormat()) + "\n");
            buffer.append("GID: " + Long.toHexString(entry.getGID()) + "\n");
            buffer.append("Inode: " + Long.toHexString(entry.getInode()) + "\n");
            buffer.append("Last Modified: " + entry.getLastModifiedDate() + "\n");
            buffer.append("Links: " + Long.toHexString(entry.getNumberOfLinks()) + "\n");
            buffer.append("Mode: " + Long.toHexString(entry.getMode()) + "\n");
            buffer.append("Remote Device: " + Long.toHexString(entry.getRemoteDevice()) + "\n");
            buffer.append("Size: " + Long.toHexString(entry.getSize()) + "\n");
            buffer.append("Time: " + new Date(entry.getTime()) + "\n");
            buffer.append("UID: " + Long.toHexString(entry.getUID()) + "\n");
            buffer.append("Device ID: " + Long.toHexString(entry.getDevice()) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        CpioArchiveEntry fileEntry = this.map.get(file);
        if (!fileEntry.isRegularFile()) {
            throw new IOException(file.getName() + " is not a regular file.");
        }
        byte[] bytes = this.provider.readBytes(0L, this.provider.length());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try (CpioArchiveInputStream cpioInputStream = new CpioArchiveInputStream((InputStream)inputStream);){
            while (!monitor.isCancelled()) {
                CpioArchiveEntry entry = cpioInputStream.getNextCPIOEntry();
                if (entry == null) {
                    break;
                }
                byte[] entryBytes = this.readEntryContents(cpioInputStream, monitor);
                if (!entry.equals((Object)fileEntry)) continue;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(entryBytes);
                return byteArrayInputStream;
            }
        }
        return null;
    }

    private void storeEntry(CpioArchiveEntry entry, TaskMonitor monitor) {
        monitor.setMessage(entry.getName());
        GFileImpl file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)entry.getName(), null, (boolean)entry.isDirectory(), (long)entry.getSize());
        this.storeFile((GFile)file, entry, monitor);
    }

    private void storeFile(GFile file, CpioArchiveEntry entry, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        if (file == null) {
            return;
        }
        if (file.equals(this.root)) {
            return;
        }
        if (!this.map.containsKey(file) || this.map.get(file) == null) {
            this.map.put(file, entry);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null, monitor);
    }

    private byte[] readEntryContents(CpioArchiveInputStream cpioInputStream, TaskMonitor monitor) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (true) {
            if (monitor.isCancelled()) {
                return null;
            }
            int b = cpioInputStream.read();
            if (b == -1) break;
            out.write(b);
        }
        return out.toByteArray();
    }
}

