/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.graph.viewer.options.RelayoutOption;
import ghidra.graph.viewer.options.ViewRestoreOption;
import ghidra.graph.viewer.options.VisualGraphOptions;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.HelpLocation;
import java.awt.Color;

public class FunctionGraphOptions
extends VisualGraphOptions {
    private static final String EDGE_FALLTHROUGH_HIGHLIGHT_COLOR_KEY = "Edge Color - Fallthrough Highlight";
    private static final String EDGE_UNCONDITIONAL_JUMP_HIGHLIGHT_COLOR_KEY = "Edge Color - Unconditional Jump Highlight";
    private static final String EDGE_CONDITIONAL_JUMP_HIGHLIGHT_COLOR_KEY = "Edge Color - Conditional Jump Highlight";
    private static final String EDGE_FALLTHROUGH_COLOR_KEY = "Edge Color - Fallthrough ";
    private static final String EDGE_UNCONDITIONAL_JUMP_COLOR_KEY = "Edge Color - Unconditional Jump ";
    private static final String EDGE_COLOR_CONDITIONAL_JUMP_KEY = "Edge Color - Conditional Jump ";
    public static final String RELAYOUT_OPTIONS_KEY = "Automatic Graph Relayout";
    public static final String RELAYOUT_OPTIONS_DESCRIPTION = "Signals to the Function Graph when an automatic relayout of the graph should take place.  The  basic options are:<ul><li><b>Always</b> - always relayout the graph when the block model changes</li><li><b>Block Model Changes Only</b> - relayout the graph when the block model changes (like when a label has been added to the program in the currently graphed function)</li><li><b>Vertex Grouping Changes Only</b> - when vertices are grouped or ungrouped</li><li><b>Never</b> - do not automatically relayout the graph</li></ul><br><br><b><i>See help for more</i></b>";
    private static final String DEFAULT_GROUP_BACKGROUND_COLOR_KEY = "Default Group Color";
    private static final String DEFAULT_GROUP_BACKGROUND_COLOR_DESCRPTION = "The default background color applied to newly created group vertices";
    private static final String UPDATE_GROUP_AND_UNGROUP_COLORS = "Update Vertex Colors When Grouping";
    private static final String UPDATE_GROUP_AND_UNGROUP_COLORS_DESCRIPTION = "Signals that any user color changes to a group vertex will apply that same color to all grouped vertices as well.";
    public static final Color DEFAULT_GROUP_BACKGROUND_COLOR = new Color(226, 255, 155);
    private static final Color HOVER_HIGHLIGHT_FALL_THROUGH_COLOR = new Color(255, 127, 127);
    private static final Color HOVER_HIGHLIGHT_UNCONDITIONAL_COLOR = new Color(127, 127, 255);
    private static final Color HOVER_HIGHLIGHT_CONDITIONAL_COLOR = Color.GREEN;
    private boolean updateGroupColorsAutomatically = true;
    private Color defaultGroupBackgroundColor = DEFAULT_GROUP_BACKGROUND_COLOR;
    private Color fallthroughEdgeColor = Color.RED;
    private Color unconditionalJumpEdgeColor = Color.BLUE;
    private Color conditionalJumpEdgeColor = Color.GREEN.darker().darker();
    private Color fallthroughEdgeHighlightColor = HOVER_HIGHLIGHT_FALL_THROUGH_COLOR;
    private Color unconditionalJumpEdgeHighlightColor = HOVER_HIGHLIGHT_UNCONDITIONAL_COLOR;
    private Color conditionalJumpEdgeHighlightColor = HOVER_HIGHLIGHT_CONDITIONAL_COLOR;
    protected RelayoutOption relayoutOption = RelayoutOption.NEVER;

    public Color getDefaultGroupBackgroundColor() {
        return this.defaultGroupBackgroundColor;
    }

    public boolean getUpdateGroupColorsAutomatically() {
        return this.updateGroupColorsAutomatically;
    }

    public Color getFallthroughEdgeColor() {
        return this.fallthroughEdgeColor;
    }

    public Color getUnconditionalJumpEdgeColor() {
        return this.unconditionalJumpEdgeColor;
    }

    public Color getConditionalJumpEdgeColor() {
        return this.conditionalJumpEdgeColor;
    }

    public Color getUnconditionalJumpEdgeHighlightColor() {
        return this.unconditionalJumpEdgeHighlightColor;
    }

    public Color getFallthroughEdgeHighlightColor() {
        return this.fallthroughEdgeHighlightColor;
    }

    public Color getConditionalJumpEdgeHighlightColor() {
        return this.conditionalJumpEdgeHighlightColor;
    }

    public RelayoutOption getRelayoutOption() {
        return this.relayoutOption;
    }

    public void initializeOptions(Plugin plugin, ToolOptions options) {
        HelpLocation help = new HelpLocation(plugin.getName(), "Options");
        options.setOptionsHelpLocation(help);
        options.registerOption(RELAYOUT_OPTIONS_KEY, (Object)RelayoutOption.VERTEX_GROUPING_CHANGES, help, RELAYOUT_OPTIONS_DESCRIPTION);
        options.registerOption("Use Animation", (Object)this.useAnimation(), help, "Signals to the Function Graph to use animated transitions for certain operations, like navigation.");
        options.registerOption("Use Mouse-relative Zoom", (Object)this.useMouseRelativeZoom(), help, "When true the Function Graph will perform zoom operations relative to the mouse point.");
        options.registerOption("Use Condensed Layout", (Object)this.useCondensedLayout(), new HelpLocation(plugin.getName(), "Layout_Compressing"), "Place vertices as close together as possible.  For example, when true, the graph will use little spacing between vertices.  Each layout will handle this option differently.");
        options.registerOption("View Settings", (Object)ViewRestoreOption.START_FULLY_ZOOMED_OUT, help, "Dictates how the view of new graphs and already rendered graphs are zoomed and positioned.  See the help for more details.");
        options.registerOption("Scroll Wheel Pans", (Object)this.getScrollWheelPans(), help, SCROLL_WHEEL_PANS_DESCRIPTION);
        options.registerOption(DEFAULT_GROUP_BACKGROUND_COLOR_KEY, (Object)DEFAULT_GROUP_BACKGROUND_COLOR, help, DEFAULT_GROUP_BACKGROUND_COLOR_DESCRPTION);
        options.registerOption(UPDATE_GROUP_AND_UNGROUP_COLORS, (Object)this.updateGroupColorsAutomatically, help, UPDATE_GROUP_AND_UNGROUP_COLORS_DESCRIPTION);
        options.registerOption(EDGE_COLOR_CONDITIONAL_JUMP_KEY, (Object)this.conditionalJumpEdgeColor, help, "Conditional jump edge color");
        options.registerOption(EDGE_UNCONDITIONAL_JUMP_COLOR_KEY, (Object)this.unconditionalJumpEdgeColor, help, "Unconditional jump edge color");
        options.registerOption(EDGE_FALLTHROUGH_COLOR_KEY, (Object)this.fallthroughEdgeColor, help, "Fallthrough edge color");
        options.registerOption(EDGE_CONDITIONAL_JUMP_HIGHLIGHT_COLOR_KEY, (Object)this.conditionalJumpEdgeHighlightColor, help, "Conditional jump edge color when highlighting the reachablity of a vertex");
        options.registerOption(EDGE_UNCONDITIONAL_JUMP_HIGHLIGHT_COLOR_KEY, (Object)this.unconditionalJumpEdgeHighlightColor, help, "Unconditional jump edge color when highlighting the reachablity of a vertex");
        options.registerOption(EDGE_FALLTHROUGH_HIGHLIGHT_COLOR_KEY, (Object)this.fallthroughEdgeHighlightColor, help, "Fallthrough edge color when highlighting the reachablity of a vertex");
    }

    public void loadOptions(Plugin plugin, ToolOptions options) {
        this.conditionalJumpEdgeColor = options.getColor(EDGE_COLOR_CONDITIONAL_JUMP_KEY, this.conditionalJumpEdgeColor);
        this.unconditionalJumpEdgeColor = options.getColor(EDGE_UNCONDITIONAL_JUMP_COLOR_KEY, this.unconditionalJumpEdgeColor);
        this.fallthroughEdgeColor = options.getColor(EDGE_FALLTHROUGH_COLOR_KEY, this.fallthroughEdgeColor);
        this.conditionalJumpEdgeHighlightColor = options.getColor(EDGE_CONDITIONAL_JUMP_HIGHLIGHT_COLOR_KEY, this.conditionalJumpEdgeHighlightColor);
        this.unconditionalJumpEdgeHighlightColor = options.getColor(EDGE_UNCONDITIONAL_JUMP_HIGHLIGHT_COLOR_KEY, this.unconditionalJumpEdgeHighlightColor);
        this.fallthroughEdgeHighlightColor = options.getColor(EDGE_FALLTHROUGH_HIGHLIGHT_COLOR_KEY, this.fallthroughEdgeHighlightColor);
        this.relayoutOption = (RelayoutOption)options.getEnum(RELAYOUT_OPTIONS_KEY, (Enum)RelayoutOption.VERTEX_GROUPING_CHANGES);
        this.useAnimation = options.getBoolean("Use Animation", this.useAnimation);
        this.useMouseRelativeZoom = options.getBoolean("Use Mouse-relative Zoom", this.useMouseRelativeZoom);
        this.useCondensedLayout = options.getBoolean("Use Condensed Layout", this.useCondensedLayout);
        this.viewRestoreOption = (ViewRestoreOption)options.getEnum("View Settings", (Enum)ViewRestoreOption.START_FULLY_ZOOMED_OUT);
        this.scrollWheelPans = options.getBoolean("Scroll Wheel Pans", this.scrollWheelPans);
        this.defaultGroupBackgroundColor = options.getColor(DEFAULT_GROUP_BACKGROUND_COLOR_KEY, DEFAULT_GROUP_BACKGROUND_COLOR);
        this.updateGroupColorsAutomatically = options.getBoolean(UPDATE_GROUP_AND_UNGROUP_COLORS, this.updateGroupColorsAutomatically);
    }

    public Color getColor(FlowType flowType) {
        if (flowType.isFallthrough()) {
            return this.getFallthroughEdgeColor();
        }
        if (flowType.isUnConditional()) {
            return this.getUnconditionalJumpEdgeColor();
        }
        if (flowType.isJump()) {
            return this.getConditionalJumpEdgeColor();
        }
        return Color.BLACK;
    }

    public Color getHighlightColor(FlowType flowType) {
        if (flowType.isFallthrough()) {
            return this.getFallthroughEdgeHighlightColor();
        }
        if (flowType.isUnConditional()) {
            return this.getUnconditionalJumpEdgeHighlightColor();
        }
        if (flowType.isJump()) {
            return this.getConditionalJumpEdgeHighlightColor();
        }
        return Color.BLACK;
    }
}

