/***************************************************************************
                          cconfig.h  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCONFIG_H
#define CCONFIG_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>
#include <dclib/dcobject.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csingleton.h>
#include <dclib/cdownloadmanager.h>

#include <libxml/xmlversion.h>
#if LIBXML_VERSION > 20406
#include <libxml/globals.h>
#endif
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

#define DCGUI_CHATLOG_PATH	"chatlog"
#define DCGUI_PLUGINCONFIG_PATH	"plugin"
#define DCGUI_IMAGE_PATH	"image"
#define DCGUI_FILELIST_PATH	"filelist"

#define XML_NAME		"name"
#define XML_HUBNAME		"hubname"
#define XML_HUBHOST		"hubhost"
#define XML_DESCRIPTION		"description"

class DLL_EXPORT DCConfigHubProfile : public CObject {
public:
	/** */
	DCConfigHubProfile()
	{
		m_sName        = "";
		m_sNick        = "";
		m_bComment     = FALSE;
		m_sComment     = "";
		m_bEMail       = FALSE;
		m_sEMail       = "";
		m_sPassword    = "";
		m_bAutoConnect = FALSE;
		m_bSSL         = FALSE;
		m_bTag         = TRUE;
	};
	/** */
	DCConfigHubProfile( DCConfigHubProfile * p )
	{
		m_sName        = p->m_sName;
		m_sNick        = p->m_sNick;
		m_bComment     = p->m_bComment;
		m_sComment     = p->m_sComment;
		m_bEMail       = p->m_bEMail;
		m_sEMail       = p->m_sEMail;
		m_sPassword    = p->m_sPassword;
		m_bAutoConnect = p->m_bAutoConnect;
		m_bSSL         = p->m_bSSL;
		m_bTag         = p->m_bTag;
	};
	/** */
	virtual ~DCConfigHubProfile() {};

	/** profile name */
	CString m_sName;
	/** password */
	CString m_sPassword;
	/** nick */
	CString m_sNick;
	/** use comment */
	bool m_bComment;
	/** comment */
	CString m_sComment;
	/** use email */
	bool m_bEMail;
	/** email */
	CString m_sEMail;
	/** auto connect on startup */
	bool m_bAutoConnect;
	/** ssl hub */
	bool m_bSSL;
	/** tag */
	bool m_bTag;
};

class DLL_EXPORT DCConfigHubItem : public CObject {
public:
	/** */
	DCConfigHubItem()
	{
		m_nID          = 0;
		m_sProfile     = "";
		m_sName        = "";
		m_sHost        = "";
		m_nPort        = 0;
		m_sDescription = "";
		m_sUserCount   = "";
	};
	/** */
	DCConfigHubItem( DCConfigHubItem * p )
	{
		m_nID          = p->m_nID;
		m_sProfile     = p->m_sProfile;
		m_sName        = p->m_sName;
		m_sHost        = p->m_sHost;
		m_nPort        = p->m_nPort;
		m_sDescription = p->m_sDescription;
		m_sUserCount   = p->m_sUserCount;
	};
	/** */
	virtual ~DCConfigHubItem() {};

	/** the hub identify like mldonkey */
	ulonglong m_nID;
	/** hubname */
	CString m_sName;
	/** hub host */
	CString m_sHost;
	/** port */
	unsigned int m_nPort;
	/** hub description */
	CString m_sDescription;
	/** user count */
	CString m_sUserCount;
	/** profile name */
	CString m_sProfile;
};

class DLL_EXPORT DCConfigHubListUrl : public CObject {
public:
	/** */
	DCConfigHubListUrl() {};
	/** */
	virtual ~DCConfigHubListUrl() {};
	/** */
	CString sUrl;
	/** */
	bool bEnabled;
};

class DLL_EXPORT DCConfigShareFolder : public CObject {
public:
	/** */
	DCConfigShareFolder() {};
	/** */
	virtual ~DCConfigShareFolder() {};
	/** */
	CString m_sPath;
	/** */
	CString m_sAlias;
};

class CConfig;
class CStringList;
class CThreadStringList;
class CByteArray;

#ifdef WIN32
template class DLL_EXPORT CList<DCConfigHubItem>;
template class DLL_EXPORT CList<DCConfigHubListUrl>;
template class DLL_EXPORT CSingleton<CConfig>;
template class DLL_EXPORT CList<DCConfigShareFolder>;
#endif

class DLL_EXPORT CConfig : public CSingleton<CConfig>, public CObject {

public:
	/** */
	CConfig( CString configpath = "" );
	/** */
	virtual ~CConfig();

	/** */
	int LoadDCLib();
	/** */
	int SaveDCLib();
	/** */
	void ParseDCLibConfig( xmlNodePtr node );

	/** */
	int LoadDCTra( CStringList * queue, CStringList * chunks );
	/** */
	int SaveDCTra( CStringList * queue, CStringList * chunks );

	/** */
	CString GetDCLibDataPath() const;
	/** */
	void SetDCLibDataPath( CString s );

	/** */
	CString ParseVersion( CString s );
	/** */
	CString GetListenHostString();
	/** */
	CString GetTCPHostString( bool addport = TRUE );
	/** */
	CString GetUDPHostString( bool addport = TRUE );

	/** */
	bool GetAutoRecreateShareList() const;
	/** */
	void SetAutoRecreateShareList( bool b );

	/** */
	int GetDownloadQueueTime() const;
	/** */
	void SetDownloadQueueTime( int i );

	/** */
	CString GetEMail( bool raw = FALSE );
	/** */
	void SetEMail( CString email );
	/** */
	CString GetNick() const;
	/** */
	void SetNick( CString nick );
	/** */
	CString GetNick( CString hubname, CString hubhost );
	/** */
	CString GetSearchNick() const;
	/** */
	void SetSearchNick( CString searchnick );
	/** */
	CString GetAwayMessage() const;
	/** */
	void SetAwayMessage( CString s );
	/** */
	CString GetFloodOpKickMessage() const;
	/** */
	void SetFloodOpKickMessage( CString s );
	/** */
	CString GetDownloadFolder() const;
	/** */
	void SetDownloadFolder( CString downloadfolder );
	/** */
	CString GetDownloadFinishedFolder() const;
	/** */
	void SetDownloadFinishedFolder( CString s );
	/** */
	bool GetTransferAutoSearch() const;
	/** */
	void SetTransferAutoSearch( bool b );
	/** */
	bool GetCreateFile() const;
	/** */
	void SetCreateFile( bool b );

	/** */
	eClientMode GetMode( bool setting = FALSE );
	/** */
	void SetMode( eClientMode mode );
	/** */
	CString GetDescription( bool raw = FALSE, CString hubname = "", CString hubhost = "" );
	/** */
	void SetDescription( CString description );
	/** */
	bool GetDescriptionTag() const;
	/** */
	void SetDescriptionTag( bool b );
	/** */
	CString GetAwayPrefix() const;
	/** */
	void SetAwayPrefix( CString s );

	/** */
	CString GetSpeed() const;
	/** */
	void SetSpeed( CString speed );
	/** */
	int GetTCPListenPort() const;
	/** */
	void SetTCPListenPort( int port );
	/** */
	int GetUDPListenPort() const;
	/** */
	void SetUDPListenPort( int port );
	/** */
	CString GetHost() const;
	/** */
	void SetHost( CString host );
	/** */
	CString GetListenHost() const;
	/** */
	void SetListenHost( CString host );
	/** */
	bool GetAntiSpam() const;
	/** */
	void SetAntiSpam( bool antispam );
	/** */
	bool GetExternalIP() const;
	/** */
	void SetExternalIP( bool b );
	/** */
	int GetMaxUpload() const;
	/** */
	void SetMaxUpload( int maxupload );
	/** */
	int GetUserUploadSlots() const;
	/** */
	void SetUserUploadSlots( int i );
	/** */
	void SetAwayMode( eUserAwayMode mode );
	/** */
	eUserAwayMode GetAwayMode() const;
	/** */
	long GetSharedFolders( CList<DCConfigShareFolder> * list );
	/** */
	void SetSharedFolders( CList<DCConfigShareFolder> * list );
	/** */
	bool GetLogFile() const;
	/** */
	void SetLogFile( bool logfile );
	/** */
	CString GetLogFileName() const;
	/** */
	void SetLogFileName( CString logfile );
	/** */
	bool GetSendMessageOnActiveModeRequest() const;
	/** */
	void SetSendMessageOnActiveModeRequest( bool b );

	/** */
	CString GetLogPath() const { return sConfigPath; };
	/** */
	CString GetImagePath() const { return sConfigPath+DCGUI_IMAGE_PATH+DIRSEPARATOR; };
	/** */
	CString GetConfigPath() const { return sConfigPath; };
	/** */
	CString GetChatLogPath() const { return sConfigPath+DCGUI_CHATLOG_PATH+DIRSEPARATOR; };
	/** */
	CString GetPluginConfigPath() const { return sConfigPath+DCGUI_PLUGINCONFIG_PATH+DIRSEPARATOR; };
	/** */
	CString GetFileListPath() const { return sConfigPath+DCGUI_FILELIST_PATH+DIRSEPARATOR; };

	/** */
	int LoadDCHub();
	/** */
	int SaveDCHub();
	/** */
	int SaveDCPublicHub();
	/** */
	int SaveDCBookHub();
	/** */
	void ParseDCHubConfig( xmlNodePtr node );
	/** */
	void ParseDCBookHubConfig( xmlNodePtr node );
	/** */
	long GetBookmarkHubList( CList<DCConfigHubItem> * list );
	/** */
	CStringList * GetBookmarkHubServerList();
	/** */
	bool RemoveBookmarkHub( CString name, CString host, CString description );
	/** */
	bool AddBookmarkHub( CString name, CString host, CString description );
	/** */
	bool UpdateBookmarkHub( CString name, CString host, CString description );
	/** */
	bool SetBookmarkHubProfile( CString name, CString profile );
	/** */
	bool GetBookmarkHubProfile( CString name, CString host, DCConfigHubProfile * p );
	/** */
	long GetPublicHubList( CList<DCConfigHubItem> * list );
	/** */
	CStringList * GetPublicHubServerList();
	/** */
	bool GetBookmarkHub( CString name, DCConfigHubItem * hubitem );
	/** */
	bool GetBookmarkHub( ulonglong id, DCConfigHubItem * hubitem );
	/** */
	bool GetPublicHub( CString name, DCConfigHubItem * hubitem );
	/** */
	bool GetPublicHub( ulonglong id, DCConfigHubItem * hubitem );
	/** */
	bool RemovePublicHub( CString name, CString host, CString description );
	/** */
	bool AddPublicHub( const CString & name, const CString & host, const CString & description, const CString usercount );
	/** */
	void ClearPublicHubList();
	/** */
	long GetHubListUrlList( CList<DCConfigHubListUrl> * list );
	/** */
	void SetHubListUrlList( CList<DCConfigHubListUrl> * list );

	/** */
	bool AddHubProfile( DCConfigHubProfile * p );
	/** */
	bool DelHubProfile( CString name );
	/** */
	bool GetHubProfile( CString name, DCConfigHubProfile * p );
	/** */
	bool SaveHubProfile();
	/** */
	bool LoadHubProfile();
	/** */
	bool GetHubProfileList( CStringList * list );
	/** */
	int GetReloadHubListTime() const;
	/** */
	void SetReloadHubListTime( int i );
	/** */
	int GetRecreateShareListTime() const;
	/** */
	void SetRecreateShareListTime( int i );

	/** */
	void GetSearchHistory( CList<CString> * list );
	/** */
	void AddSearchHistory( CString s );

	/** */
	bool GetHubListStoreLocal() const;
	/** */
	void SetHubListStoreLocal( bool b );
	/** */
	int GetReconnectCount() const;
	/** */
	void SetReconnectCount( int reconnectcount );
	/** */
	int GetReconnectTimeout() const;
	/** */
	void SetReconnectTimeout( int reconnecttimeout );
	/** */
	bool GetCheckPrivateAddressSpace() const;
	/** */
	void SetCheckPrivateAddressSpace( bool b );

	/** */
	int GetTransferResendTimeout() const;
	/** */
	void SetTransferResendTimeout( int i );
	/** */
	int GetTransferResponseTimeout() const;
	/** */
	void SetTransferResponseTimeout( int i );

        /** */
	eCloseType GetHubOfflineTransferClose() const;
	/** set the reaction on leaving hub */
	void SetHubOfflineTransferClose( eCloseType ect );
	
	/** */
	bool GetForceMoveEnabled() const;
	/** */
	void SetForceMoveEnabled( bool forcemoveenabled );

	/** */
	ulonglong GetMaxUploadRate() const;
	/** */
	void SetMaxUploadRate( ulonglong n );
	/** */
	ulonglong GetMaxDownloadRate() const;
	/** */
	void SetMaxDownloadRate( ulonglong n );
	/** */
	bool GetDynamicUploadRate() const;
	/** */
	void SetDynamicUploadRate( bool b );

	/** */
	bool GetChatSendOfflineMessages() const;
	/** */
	void SetChatSendOfflineMessages( bool b );
	/** */
	bool GetChatRecvOfflineMessages() const;
	/** */
	void SetChatRecvOfflineMessages( bool b );

	/** */
	CString GetTransferCert() const;
	/** */
	void SetTransferCert( CString s );
	/** */
	CString GetTransferKey() const;
	/** */
	void SetTransferKey( CString s );

	/** */
	bool GetDisableHashList() const;
	/** */
	void SetDisableHashList( bool b );
	
	/** */
	CString AliasToPath( CString file );

private:
	/** */
	friend class CSingleton<CConfig>;

	/** */
	CString sEMail;
	/** */
	CString sNick;
	/** */
	CString sSearchNick;
	/** */
	CString sAwayMessage;
	/** */
	CString sFloodOpKickMessage;
	/** */
	CString sDownloadFolder;
	/** */
	CString sDownloadFinishedFolder;
	/** */
	eClientMode eMode;
	/** */
	CString sDescription;
	/** */
	CString sAwayPrefix;
	/** */
	bool bDescriptionTag;
	/** */
	CString sSpeed;
	/** */
	int iTCPListenPort;
	/** */
	int iUDPListenPort;
	/** */
	CString m_sHost;
	/** */
	CString m_sHostCache;
	/** */
	CString m_sListenHost;
	/** */
	time_t m_tHostTimeout;
	/** */
	CString m_sTransferCert;
	/** */
	CString m_sTransferKey;
	/** */
	bool bAntiSpam;
	/** */
	bool bLogFile;
	/** */
	bool bCheckPrivateAddressSpace;
	/** */
	CString sLogFile;
	/** */
	bool m_bExternalIP;
	/** */
	bool bSendMessageOnActiveModeRequest;
	/** */
	int iMaxUpload;
	/** */
	int iUserUploadSlots;
	/** */
	ulonglong lMaxDownloadRate;
	/** */
	ulonglong lMaxUploadRate;
	/** */
	int iReconnectCount;
	/** */
	int iReconnectTimeout;
	/** */
	int iTransferResendTimeout;
	/** */
	int iTransferResponseTimeout;
	/** */
	eCloseType eHubOfflineTransferClose;
	/** */
	bool bForceMoveEnabled;
	/** */
	bool bHubListStoreLocal;
	/** */
	eUserAwayMode eAwayMode;
	/** */
	CList<DCConfigShareFolder> SharedFolders;
	/** */
	bool bAutoRecreateShareList;
	/** */
	CStringList * pBookmarkHubList;
	/** */
	CStringList * pBookmarkHubList_HostIndex;
	/** */
	CStringList * pPublicHubList;
	/** */
	CStringList * pPublicHubList_HostIndex;
	/** */
	CStringList * pHubProfileList;
	/** */
	CList<CString> * pSearchHistory;
	/** */
	CList<DCConfigHubListUrl> pHubListUrlList;
	/** */
	int iDownloadQueueTime;
	/** */
	CString m_sDCLibDataPath;
	/** */
	bool bDynamicUploadRate;
	/** */
	bool bChatSendOfflineMessages;
	/** */	
	bool bChatRecvOfflineMessages;
	/** */
	bool bTransferAutoSearch;

	/** */
	ulonglong m_nPublicHubID;
	/** */
	ulonglong m_nBookHubID;
	/** */
	int m_nReloadHubListTime;
	/** */
	int m_nRecreateShareListTime;
	/** */
	bool m_bCreateFile;
	/** */
	bool m_bDisableHashList;

protected:
	/** */
	CThread Thread;
	/** */
	CString sConfigPath;
};

/** inline functions */

/** */
inline void CConfig::SetEMail( CString email )
{ Thread.Lock(); sEMail = email; Thread.UnLock(); }
/** */
inline CString CConfig::GetNick() const
{ return sNick.Replace(' ',"\xa0"); }
/** */
inline void CConfig::SetNick( CString nick )
{ Thread.Lock(); sNick = nick; Thread.UnLock(); }
/** */
inline CString CConfig::GetSearchNick() const
{ return sSearchNick.Replace(' ',"\xa0"); }
/** */
inline void CConfig::SetSearchNick( CString searchnick )
{ Thread.Lock(); sSearchNick = searchnick; Thread.UnLock(); }
/** */
inline CString CConfig::GetAwayMessage() const
{ return sAwayMessage; }
/** */
inline void CConfig::SetAwayMessage( CString s )
{ Thread.Lock(); sAwayMessage = s; Thread.UnLock(); }
/** */
inline CString CConfig::GetFloodOpKickMessage() const
{ return sFloodOpKickMessage; }
/** */
inline void CConfig::SetFloodOpKickMessage( CString s )
{ Thread.Lock(); sFloodOpKickMessage = s; Thread.UnLock(); }
/** */
inline CString CConfig::GetDownloadFolder() const
{ return sDownloadFolder; }
/** */
inline void CConfig::SetDownloadFolder( CString downloadfolder )
{ Thread.Lock(); sDownloadFolder = downloadfolder; Thread.UnLock(); }
/** */
inline CString CConfig::GetDownloadFinishedFolder() const
{ return sDownloadFinishedFolder; }
/** */
inline void CConfig::SetDownloadFinishedFolder( CString s )
{ Thread.Lock(); sDownloadFinishedFolder = s; Thread.UnLock(); }
/** */
inline void CConfig::SetMode( eClientMode mode )
{ Thread.Lock(); eMode = mode; Thread.UnLock(); }
/** */
inline void CConfig::SetDescription( CString description )
{ Thread.Lock(); sDescription = description; Thread.UnLock(); }
/** */
inline bool CConfig::GetDescriptionTag() const
{ return bDescriptionTag; }
/** */
inline void CConfig::SetDescriptionTag( bool b )
{ Thread.Lock(); bDescriptionTag = b; Thread.UnLock(); }
/** */
inline CString CConfig::GetSpeed() const
{ return sSpeed; }
/** */
inline void CConfig::SetSpeed( CString speed )
{ Thread.Lock(); sSpeed = speed; Thread.UnLock(); }
/** */
inline int CConfig::GetTCPListenPort() const
{ return iTCPListenPort; }
/** */
inline void CConfig::SetTCPListenPort( int port )
{ Thread.Lock(); iTCPListenPort = port; Thread.UnLock(); }
/** */
inline int CConfig::GetUDPListenPort() const
{ return iUDPListenPort; }
/** */
inline void CConfig::SetUDPListenPort( int port )
{ Thread.Lock(); iUDPListenPort = port; Thread.UnLock(); }
/** */
inline CString CConfig::GetHost() const
{ return m_sHost; }
/** */
inline void CConfig::SetHost( CString host )
{ Thread.Lock(); m_sHost = host; m_sHostCache = ""; Thread.UnLock(); }
/** */
inline CString CConfig::GetListenHost() const
{ return m_sListenHost; }
/** */
inline void CConfig::SetListenHost( CString host )
{ Thread.Lock(); m_sListenHost = host; m_sHostCache = ""; Thread.UnLock(); }
/** */
inline bool CConfig::GetAntiSpam() const
{ return bAntiSpam; }
/** */
inline void CConfig::SetAntiSpam( bool antispam )
{ Thread.Lock(); bAntiSpam = antispam; Thread.UnLock(); }
/** */
inline bool CConfig::GetExternalIP() const
{ return m_bExternalIP; }
/** */
inline void CConfig::SetExternalIP( bool b )
{ Thread.Lock(); m_bExternalIP = b; Thread.UnLock(); }
/** */
inline int CConfig::GetMaxUpload() const
{ return iMaxUpload; }
/** */
inline void CConfig::SetMaxUpload( int maxupload )
{ Thread.Lock(); iMaxUpload = maxupload; Thread.UnLock(); }
/** */
inline int CConfig::GetUserUploadSlots() const
{ return iUserUploadSlots; }
/** */
inline void CConfig::SetUserUploadSlots( int i )
{ Thread.Lock(); iUserUploadSlots = i; Thread.UnLock(); }
/** */
inline ulonglong CConfig::GetMaxUploadRate() const
{ if ( lMaxUploadRate < 512 ) return 0; return lMaxUploadRate; }
/** */
inline void CConfig::SetMaxUploadRate( ulonglong n )
{ Thread.Lock(); if ( n < 512 ) n = 0; lMaxUploadRate = n; Thread.UnLock(); }
/** */
inline ulonglong CConfig::GetMaxDownloadRate() const
{ return lMaxDownloadRate; }
/** */
inline void CConfig::SetMaxDownloadRate( ulonglong n )
{ Thread.Lock(); lMaxDownloadRate = n; Thread.UnLock(); }
/** */
inline bool CConfig::GetDynamicUploadRate() const
{ return bDynamicUploadRate; }
/** */
inline void CConfig::SetDynamicUploadRate( bool b )
{ Thread.Lock(); bDynamicUploadRate = b; Thread.UnLock(); }
/** */
inline bool CConfig::GetHubListStoreLocal() const
{ return bHubListStoreLocal; }
/** */
inline void CConfig::SetHubListStoreLocal( bool b )
{ Thread.Lock(); bHubListStoreLocal = b; Thread.UnLock(); }
/** */
inline int CConfig::GetReconnectCount() const
{ return iReconnectCount; }
/** */
inline void CConfig::SetReconnectCount( int reconnectcount )
{ Thread.Lock(); iReconnectCount = reconnectcount; Thread.UnLock(); }
/** */
inline int CConfig::GetReconnectTimeout() const
{ return iReconnectTimeout; }
/** */
inline void CConfig::SetReconnectTimeout( int reconnecttimeout )
{ Thread.Lock(); iReconnectTimeout = reconnecttimeout; Thread.UnLock(); }
/** */
inline int CConfig::GetTransferResendTimeout() const
{ return iTransferResendTimeout; }
/** */
inline void CConfig::SetTransferResendTimeout( int i )
{ Thread.Lock(); iTransferResendTimeout = i; Thread.UnLock(); }
/** */
inline int CConfig::GetTransferResponseTimeout() const
{ return iTransferResponseTimeout; }
/** */
inline void CConfig::SetTransferResponseTimeout( int i )
{ Thread.Lock(); iTransferResponseTimeout = i; Thread.UnLock(); }
/** */
inline bool CConfig::GetForceMoveEnabled() const
{ return bForceMoveEnabled; }
/** */
inline void CConfig::SetForceMoveEnabled( bool forcemoveenabled )
{ Thread.Lock(); bForceMoveEnabled = forcemoveenabled; Thread.UnLock(); }
/** */
inline void CConfig::SetAwayMode( eUserAwayMode mode )
{ Thread.Lock(); eAwayMode = mode; Thread.UnLock(); }
/** */
inline eUserAwayMode CConfig::GetAwayMode() const
{ return eAwayMode; }
/** */
inline int CConfig::GetDownloadQueueTime() const
{ return iDownloadQueueTime; }
/** */
inline void CConfig::SetDownloadQueueTime( int i )
{ Thread.Lock(); iDownloadQueueTime = i; Thread.UnLock(); }
/** */
inline bool CConfig::GetSendMessageOnActiveModeRequest() const
{ return bSendMessageOnActiveModeRequest; }
/** */
inline void CConfig::SetSendMessageOnActiveModeRequest( bool b )
{ Thread.Lock(); bSendMessageOnActiveModeRequest = b; Thread.UnLock(); }
/** */
inline bool CConfig::GetLogFile() const
{ return bLogFile; }
/** */
inline void CConfig::SetLogFile( bool logfile )
{ Thread.Lock(); bLogFile = logfile; Thread.UnLock(); }
/** */
inline CString CConfig::GetLogFileName() const
{ return sLogFile; }
/** */
inline void CConfig::SetLogFileName( CString logfile )
{ Thread.Lock(); sLogFile = logfile; Thread.UnLock(); }

/** */
inline bool CConfig::GetCheckPrivateAddressSpace() const
{ return bCheckPrivateAddressSpace; }
/** */
inline void CConfig::SetCheckPrivateAddressSpace( bool b )
{ Thread.Lock(); bCheckPrivateAddressSpace = b; Thread.UnLock(); }
/** */
inline CString CConfig::GetDCLibDataPath() const
{ return m_sDCLibDataPath; }
/** */
inline void CConfig::SetDCLibDataPath( CString s )
{ Thread.Lock(); m_sDCLibDataPath = s; Thread.UnLock(); }
/** */
inline bool CConfig::GetChatSendOfflineMessages() const
{ return bChatSendOfflineMessages; }
/** */
inline void CConfig::SetChatSendOfflineMessages( bool b )
{ Thread.Lock(); bChatSendOfflineMessages = b; Thread.UnLock(); }
/** */
inline bool CConfig::GetChatRecvOfflineMessages() const
{ return bChatRecvOfflineMessages; }
/** */
inline void CConfig::SetChatRecvOfflineMessages( bool b )
{ Thread.Lock(); bChatRecvOfflineMessages = b; Thread.UnLock(); }
/** */
inline bool CConfig::GetAutoRecreateShareList() const
{ return bAutoRecreateShareList; }
/** */
inline void CConfig::SetAutoRecreateShareList( bool b )
{ Thread.Lock(); bAutoRecreateShareList = b; Thread.UnLock(); }
/** */
inline CString CConfig::GetTransferCert() const
{ return m_sTransferCert; }
/** */
inline void CConfig::SetTransferCert( CString s )
{ Thread.Lock(); m_sTransferCert = s; Thread.UnLock(); }
/** */
inline CString CConfig::GetTransferKey() const
{ return m_sTransferKey; }
/** */
inline void CConfig::SetTransferKey( CString s )
{ Thread.Lock(); m_sTransferKey = s; Thread.UnLock(); }
/** */
inline eCloseType CConfig::GetHubOfflineTransferClose() const
{ return eHubOfflineTransferClose; }
/** */
inline void CConfig::SetHubOfflineTransferClose( eCloseType ect )
{ Thread.Lock(); eHubOfflineTransferClose = ect; Thread.UnLock(); }
/** */
inline bool CConfig::GetTransferAutoSearch() const
{ return bTransferAutoSearch; }
/** */
inline void CConfig::SetTransferAutoSearch( bool b )
{ Thread.Lock(); bTransferAutoSearch = b; Thread.UnLock(); }
/** */
inline int CConfig::GetReloadHubListTime() const
{ return m_nReloadHubListTime; }
/** */
inline void CConfig::SetReloadHubListTime( int i )
{ Thread.Lock(); m_nReloadHubListTime = i; Thread.UnLock(); }
/** */
inline int CConfig::GetRecreateShareListTime() const
{ return m_nRecreateShareListTime; }
/** */
inline void CConfig::SetRecreateShareListTime( int i )
{ Thread.Lock(); m_nRecreateShareListTime = i; Thread.UnLock(); }
/** */
inline CString CConfig::GetAwayPrefix() const
{ return sAwayPrefix; }
/** */
inline void CConfig::SetAwayPrefix( CString s )
{ Thread.Lock(); sAwayPrefix = s; Thread.UnLock(); }
/** */
inline bool CConfig::GetCreateFile() const
{ return m_bCreateFile; }
/** */
inline void CConfig::SetCreateFile( bool b )
{ Thread.Lock(); m_bCreateFile = b; Thread.UnLock(); }
/** */
inline bool CConfig::GetDisableHashList() const
{ return m_bDisableHashList; }
/** */
inline void CConfig::SetDisableHashList( bool b )
{ Thread.Lock(); m_bDisableHashList = b; Thread.UnLock(); }

#endif
