/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class DynamicFieldsPanel
extends JPanel {
    private static final String[] NO_FIELDS = new String[0];
    private static final long serialVersionUID = -1129326656062554952L;
    private String[] requiredFields;
    private String[] optionalFields;
    private Map<String, ZapTextField> textFields;

    public DynamicFieldsPanel() {
        this.requiredFields = NO_FIELDS;
        this.optionalFields = NO_FIELDS;
        this.textFields = Collections.emptyMap();
    }

    public DynamicFieldsPanel(String[] requiredFields) {
        this(requiredFields, NO_FIELDS);
    }

    public DynamicFieldsPanel(String[] requiredFields, String[] optionalFields) {
        super(new GridBagLayout());
        this.setFields(requiredFields, optionalFields);
    }

    public void setFields(String[] requiredFields) {
        this.setFields(requiredFields, NO_FIELDS);
    }

    public void setFields(String[] requiredFields, String[] optionalFields) {
        ZapTextField tf;
        if (requiredFields == null) {
            throw new IllegalArgumentException("Parameter requiredFields must not be null.");
        }
        if (optionalFields == null) {
            throw new IllegalArgumentException("Parameter optionalFields must not be null.");
        }
        this.requiredFields = requiredFields;
        this.optionalFields = optionalFields;
        this.textFields = new HashMap<String, ZapTextField>(requiredFields.length + optionalFields.length);
        this.removeAll();
        int fieldIndex = 0;
        for (String fieldName : requiredFields) {
            this.add((Component)new JLabel("* " + fieldName + ": "), LayoutHelper.getGBC(0, fieldIndex, 1, 0.0, 0.0));
            tf = new ZapTextField();
            this.add((Component)tf, LayoutHelper.getGBC(1, fieldIndex, 1, 1.0, 0.0));
            this.textFields.put(fieldName, tf);
            ++fieldIndex;
        }
        for (String fieldName : optionalFields) {
            this.add((Component)new JLabel(fieldName + ": "), LayoutHelper.getGBC(0, fieldIndex, 1, 0.0, 0.0));
            tf = new ZapTextField();
            this.add((Component)tf, LayoutHelper.getGBC(1, fieldIndex, 1, 1.0, 0.0));
            this.textFields.put(fieldName, tf);
            ++fieldIndex;
        }
        this.validate();
    }

    public void clearFields() {
        this.requiredFields = NO_FIELDS;
        this.optionalFields = NO_FIELDS;
        this.textFields = Collections.emptyMap();
        this.removeAll();
        this.validate();
    }

    public Map<String, String> getFieldValues() {
        HashMap<String, String> values = new HashMap<String, String>(this.requiredFields.length + this.optionalFields.length);
        for (Map.Entry<String, ZapTextField> f : this.textFields.entrySet()) {
            values.put(f.getKey(), f.getValue().getText());
        }
        return values;
    }

    public void bindFieldValues(Map<String, String> fieldValues) {
        for (Map.Entry<String, ZapTextField> f : this.textFields.entrySet()) {
            ZapTextField field = f.getValue();
            field.setText(fieldValues.get(f.getKey()));
            field.discardAllEdits();
        }
    }

    public void validateFields() throws IllegalStateException {
        for (String rf : this.requiredFields) {
            if (!this.textFields.get(rf).getText().trim().isEmpty()) continue;
            this.textFields.get(rf).requestFocusInWindow();
            throw new IllegalStateException(Constant.messages.getString("authentication.method.script.dialog.error.text.required", rf));
        }
    }
}

