/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.paros.ParosDatabase;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.xml.sax.SAXException;
import org.zaproxy.zap.control.ControlOverrides;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;

public class Model {
    private static Model model = null;
    private static final String DBNAME_TEMPLATE = Constant.DBNAME_TEMPLATE;
    private String DBNAME_UNTITLED;
    private static int DBNAME_COPY = 1;
    private Session session;
    private OptionsParam optionsParam;
    private Database db;
    private String currentDBNameUntitled;
    private Logger logger;
    private List<SessionListener> sessionListeners;
    private List<ContextDataFactory> contextDataFactories;
    private boolean postInitialisation;

    public Model() {
        this.DBNAME_UNTITLED = Constant.getInstance().DBNAME_UNTITLED;
        this.session = null;
        this.optionsParam = null;
        this.db = null;
        this.currentDBNameUntitled = "";
        this.logger = Logger.getLogger(Model.class);
        this.sessionListeners = new ArrayList<SessionListener>();
        this.contextDataFactories = new ArrayList<ContextDataFactory>();
        this.session = new Session(this);
        this.optionsParam = new OptionsParam();
    }

    public OptionsParam getOptionsParam() {
        if (this.optionsParam == null) {
            this.optionsParam = new OptionsParam();
        }
        return this.optionsParam;
    }

    public void setOptionsParam(OptionsParam param) {
        this.optionsParam = param;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = new Session(this);
        }
        return this.session;
    }

    public Session newSession() {
        this.session = new Session(this);
        this.session.saveContext(this.session.getNewContext(Constant.messages.getString("context.default.name")));
        return this.session;
    }

    public void openSession(String fileName) throws SQLException, SAXException, IOException, Exception {
        this.getSession().open(fileName);
    }

    public void openSession(String fileName, SessionListener callback) {
        this.getSession().open(fileName, callback);
    }

    public void openSession(File file, SessionListener callback) {
        this.getSession().open(file, callback);
    }

    public void saveSession(String fileName, SessionListener callback) {
        this.getSession().save(fileName, callback);
    }

    public void saveSession(String fileName) throws Exception {
        this.getSession().save(fileName);
    }

    public void persistSessionProperties() throws Exception {
        this.getSession().persistProperties();
    }

    public void snapshotSession(String fileName, SessionListener callback) {
        this.getSession().snapshot(fileName, callback);
    }

    public void discardSession() {
        this.getSession().discard();
    }

    public void closeSession() {
        this.getSession().close();
    }

    public void init(ControlOverrides overrides) throws SAXException, IOException, Exception {
        this.getOptionsParam().load(Constant.getInstance().FILE_CONFIG, overrides);
        if (overrides.isExperimentalDb()) {
            this.logger.info((Object)"Using experimental database :/");
            this.db = DbSQL.getSingleton().initDatabase();
        } else {
            ParosDatabase parosDb = new ParosDatabase();
            parosDb.setDatabaseParam(this.getOptionsParam().getDatabaseParam());
            this.db = parosDb;
        }
        this.createAndOpenUntitledDb();
        HistoryReference.setTableHistory(this.getDb().getTableHistory());
        HistoryReference.setTableTag(this.getDb().getTableTag());
        HistoryReference.setTableAlert(this.getDb().getTableAlert());
    }

    public static Model getSingleton() {
        if (model == null) {
            Model.createSingleton();
        }
        return model;
    }

    private static synchronized void createSingleton() {
        if (model == null) {
            model = new Model();
        }
    }

    public Database getDb() {
        return this.db;
    }

    public void moveSessionDb(String destFile) throws Exception {
        this.copySessionDb(this.currentDBNameUntitled, destFile);
    }

    protected void copySessionDb(String currentFile, String destFile) throws Exception {
        File lobsFile;
        File fileIn4;
        File fileIn3;
        File fileIn2;
        this.getDb().close(false, false);
        FileCopier copier = new FileCopier();
        File fileIn1 = new File(currentFile + ".data");
        if (fileIn1.exists()) {
            File fileOut1 = new File(destFile + ".data");
            copier.copy(fileIn1, fileOut1);
        }
        if ((fileIn2 = new File(currentFile + ".script")).exists()) {
            File fileOut2 = new File(destFile + ".script");
            copier.copy(fileIn2, fileOut2);
        }
        if ((fileIn3 = new File(currentFile + ".properties")).exists()) {
            File fileOut3 = new File(destFile + ".properties");
            copier.copy(fileIn3, fileOut3);
        }
        if ((fileIn4 = new File(currentFile + ".backup")).exists()) {
            File fileOut4 = new File(destFile + ".backup");
            copier.copy(fileIn4, fileOut4);
        }
        if ((lobsFile = new File(currentFile + ".lobs")).exists()) {
            File newLobsFile = new File(destFile + ".lobs");
            copier.copy(lobsFile, newLobsFile);
        }
        this.getDb().open(destFile);
    }

    protected void snapshotSessionDb(String currentFile, String destFile) throws Exception {
        File lobsFile;
        File fileIn4;
        File fileIn3;
        File fileIn2;
        this.logger.debug((Object)("snapshotSessionDb " + currentFile + " -> " + destFile));
        this.getDb().close(false, false);
        FileCopier copier = new FileCopier();
        File fileIn1 = new File(currentFile + ".data");
        if (fileIn1.exists()) {
            File fileOut1 = new File(destFile + ".data");
            copier.copy(fileIn1, fileOut1);
        }
        if ((fileIn2 = new File(currentFile + ".script")).exists()) {
            File fileOut2 = new File(destFile + ".script");
            copier.copy(fileIn2, fileOut2);
        }
        if ((fileIn3 = new File(currentFile + ".properties")).exists()) {
            File fileOut3 = new File(destFile + ".properties");
            copier.copy(fileIn3, fileOut3);
        }
        if ((fileIn4 = new File(currentFile + ".backup")).exists()) {
            File fileOut4 = new File(destFile + ".backup");
            copier.copy(fileIn4, fileOut4);
        }
        if ((lobsFile = new File(currentFile + ".lobs")).exists()) {
            File newLobsFile = new File(destFile + ".lobs");
            copier.copy(lobsFile, newLobsFile);
        }
        if (currentFile.length() == 0) {
            this.logger.debug((Object)("snapshotSessionDb using " + this.currentDBNameUntitled + " -> " + destFile));
            currentFile = this.currentDBNameUntitled;
        }
        this.getDb().open(currentFile);
    }

    public void createAndOpenUntitledDb() throws ClassNotFoundException, Exception {
        File fileOut;
        this.getDb().close(false, this.session.isCleanUpRequired());
        File dir = new File(this.getSession().getSessionFolder());
        File[] listFile = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir1, String fileName) {
                return fileName.startsWith("untitled");
            }
        });
        for (int i = 0; i < listFile.length; ++i) {
            if (listFile[i].delete()) continue;
            this.logger.error((Object)("Failed to delete file " + listFile[i].getAbsolutePath()));
        }
        this.currentDBNameUntitled = this.DBNAME_UNTITLED + DBNAME_COPY;
        FileCopier copier = new FileCopier();
        File fileIn = new File(Constant.getZapInstall(), DBNAME_TEMPLATE + ".data");
        if (fileIn.exists()) {
            fileOut = new File(this.currentDBNameUntitled + ".data");
            if (fileOut.exists() && !fileOut.delete()) {
                this.logger.error((Object)("Failed to delete file " + fileOut.getAbsolutePath()));
            }
            copier.copy(fileIn, fileOut);
        }
        if ((fileIn = new File(Constant.getZapInstall(), DBNAME_TEMPLATE + ".properties")).exists()) {
            fileOut = new File(this.currentDBNameUntitled + ".properties");
            if (fileOut.exists() && !fileOut.delete()) {
                this.logger.error((Object)("Failed to delete file " + fileOut.getAbsolutePath()));
            }
            copier.copy(fileIn, fileOut);
        }
        if ((fileIn = new File(Constant.getZapInstall(), DBNAME_TEMPLATE + ".script")).exists()) {
            fileOut = new File(this.currentDBNameUntitled + ".script");
            if (fileOut.exists() && !fileOut.delete()) {
                this.logger.error((Object)("Failed to delete file " + fileOut.getAbsolutePath()));
            }
        } else {
            throw new FileNotFoundException("Required file not found: " + fileIn.getAbsolutePath());
        }
        copier.copy(fileIn, fileOut);
        fileIn = new File(this.currentDBNameUntitled + ".backup");
        if (fileIn.exists() && !fileIn.delete()) {
            this.logger.error((Object)("Failed to delete file " + fileIn.getAbsolutePath()));
        }
        if ((fileIn = new File(this.currentDBNameUntitled + ".lobs")).exists() && !fileIn.delete()) {
            this.logger.error((Object)("Failed to delete file " + fileIn.getAbsolutePath()));
        }
        this.getDb().open(this.currentDBNameUntitled);
        ++DBNAME_COPY;
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void addContextDataFactory(ContextDataFactory contextDataFactory) {
        if (contextDataFactory == null) {
            throw new IllegalArgumentException("Parameter contextDataFactory must not be null.");
        }
        this.contextDataFactories.add(contextDataFactory);
        if (this.postInitialisation) {
            for (Context context : this.getSession().getContexts()) {
                contextDataFactory.loadContextData(this.getSession(), context);
            }
        }
    }

    public void removeContextDataFactory(ContextDataFactory contextDataFactory) {
        if (contextDataFactory == null) {
            throw new IllegalArgumentException("Parameter contextDataFactory must not be null.");
        }
        this.contextDataFactories.remove(contextDataFactory);
    }

    public void loadContext(Context ctx) {
        for (ContextDataFactory cdf : this.contextDataFactories) {
            cdf.loadContextData(this.getSession(), ctx);
        }
    }

    public void saveContext(Context ctx) {
        for (ContextDataFactory cdf : this.contextDataFactories) {
            cdf.persistContextData(this.getSession(), ctx);
        }
    }

    public void importContext(Context ctx, Configuration config) throws ConfigurationException {
        for (ContextDataFactory cdf : this.contextDataFactories) {
            cdf.importContextData(ctx, config);
        }
    }

    public void exportContext(Context ctx, Configuration config) {
        for (ContextDataFactory cdf : this.contextDataFactories) {
            cdf.exportContextData(ctx, config);
        }
    }

    public void postInit() {
        this.postInitialisation = true;
    }
}

