/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.EventQueue;
import java.awt.Frame;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.extension.history.HistoryTableModel;
import org.parosproxy.paros.extension.history.LogPanel;
import org.parosproxy.paros.extension.history.PopupMenuExportMessage;
import org.parosproxy.paros.extension.history.PopupMenuExportResponse;
import org.parosproxy.paros.extension.history.ProxyListenerLog;
import org.parosproxy.paros.extension.manualrequest.ManualRequestEditorDialog;
import org.parosproxy.paros.extension.manualrequest.http.impl.ManualHttpRequestEditorDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.HistoryReferenceEventPublisher;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.alert.AlertEventPublisher;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.history.HistoryFilterPlusDialog;
import org.zaproxy.zap.extension.history.ManageTagsDialog;
import org.zaproxy.zap.extension.history.NotesAddDialog;
import org.zaproxy.zap.extension.history.PopupMenuExportContextURLs;
import org.zaproxy.zap.extension.history.PopupMenuExportSelectedURLs;
import org.zaproxy.zap.extension.history.PopupMenuExportURLs;
import org.zaproxy.zap.extension.history.PopupMenuNote;
import org.zaproxy.zap.extension.history.PopupMenuPurgeHistory;
import org.zaproxy.zap.extension.history.PopupMenuTag;

public class ExtensionHistory
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionHistory";
    private static final HistoryTableModel EMPTY_MODEL = new HistoryTableModel();
    private LogPanel logPanel = null;
    private ProxyListenerLog proxyListener = null;
    private HistoryTableModel historyTableModel;
    private HistoryFilterPlusDialog filterPlusDialog = null;
    private PopupMenuPurgeHistory popupMenuPurgeHistory = null;
    private ManualRequestEditorDialog resendDialog = null;
    private PopupMenuExportMessage popupMenuExportMessage2 = null;
    private PopupMenuExportResponse popupMenuExportResponse2 = null;
    private PopupMenuTag popupMenuTag = null;
    private PopupMenuExportURLs popupMenuExportURLs = null;
    private PopupMenuExportSelectedURLs popupMenuExportSelectedURLs = null;
    private PopupMenuExportContextURLs popupMenuExportContextURLs = null;
    private PopupMenuNote popupMenuNote = null;
    private NotesAddDialog dialogNotesAdd = null;
    private ManageTagsDialog manageTags = null;
    private boolean showJustInScope = false;
    private boolean linkWithSitesTree;
    private String linkWithSitesTreeBaseUri;
    private Map<Integer, HistoryReference> historyIdToRef = Collections.synchronizedMap(new ReferenceMap());
    private boolean sessionChanging;
    private Logger logger = Logger.getLogger(ExtensionHistory.class);

    public ExtensionHistory() {
        super(NAME);
        this.setOrder(16);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("history.name");
    }

    private LogPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new LogPanel(this.getView());
            this.logPanel.setName(Constant.messages.getString("history.panel.title"));
            this.logPanel.setIcon(new ImageIcon(ExtensionHistory.class.getResource("/resource/icon/16/025.png")));
            this.logPanel.setHideable(false);
            this.logPanel.setExtension(this);
            this.logPanel.setModel(this.historyTableModel);
        }
        return this.logPanel;
    }

    @Deprecated
    public void clearLogPanelDisplayQueue() {
    }

    public HistoryReference getSelectedHistoryReference() {
        return this.getLogPanel().getSelectedHistoryReference();
    }

    public List<HistoryReference> getSelectedHistoryReferences() {
        return this.getLogPanel().getSelectedHistoryReferences();
    }

    @Override
    public void init() {
        super.init();
        this.historyTableModel = new HistoryTableModel();
        EventConsumerImpl eventConsumerImpl = new EventConsumerImpl();
        ZAP.getEventBus().registerConsumer(eventConsumerImpl, AlertEventPublisher.getPublisher().getPublisherName());
        ZAP.getEventBus().registerConsumer(eventConsumerImpl, HistoryReferenceEventPublisher.getPublisher().getPublisherName());
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        extensionHook.addProxyListener(this.getProxyListenerLog());
        extensionHook.addConnectionRequestProxyListener(this.getProxyListenerLog());
        if (this.getView() != null) {
            ExtensionHookView pv = extensionHook.getHookView();
            pv.addStatusPanel(this.getLogPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuTag());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuNote());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuPurgeHistory());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportMessage2());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportResponse2());
            extensionHook.getHookMenu().addReportMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportURLs());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportSelectedURLs());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportContextURLs());
            extensionHook.getHookMenu().addReportMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookMenu().addPopupMenuItem(this.createPopupMenuExportURLs());
            extensionHook.getHookMenu().addPopupMenuItem(this.createPopupMenuExportSelectedURLs());
            ExtensionHelp.enableHelpKey(this.getLogPanel(), "ui.tabs.history");
        }
    }

    @Override
    public void sessionChanged(Session session) {
        this.sessionChanging = false;
        this.sessionChanged();
    }

    private ProxyListenerLog getProxyListenerLog() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerLog(this.getModel(), this.getView(), this);
        }
        return this.proxyListener;
    }

    public void registerProxy(ProxyServer ps) {
        ps.addProxyListener(this.getProxyListenerLog());
    }

    public void unregisterProxy(ProxyServer ps) {
        ps.removeProxyListener(this.getProxyListenerLog());
    }

    public void removeFromHistoryList(final HistoryReference href) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.removeEntry(href.getHistoryId());
            this.historyIdToRef.remove(href.getHistoryId());
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionHistory.this.removeFromHistoryList(href);
                }
            });
        }
    }

    public void notifyHistoryItemChanged(HistoryReference href) {
        this.notifyHistoryItemChanged(href.getHistoryId());
    }

    private void notifyHistoryItemChanged(final int historyId) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.refreshEntryRow(historyId);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionHistory.this.notifyHistoryItemChanged(historyId);
                }
            });
        }
    }

    private void notifyHistoryItemsChanged() {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.refreshEntryRows();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionHistory.this.notifyHistoryItemsChanged();
                }
            });
        }
    }

    public void delete(HistoryReference href) {
        if (href != null) {
            this.historyIdToRef.remove(href.getHistoryId());
            href.delete();
        }
    }

    public HistoryReference getHistoryReference(int historyId) {
        HistoryReference href = this.historyTableModel.getHistoryReference(historyId);
        if (href != null) {
            return href;
        }
        href = this.historyIdToRef.get(historyId);
        if (href == null) {
            try {
                href = new HistoryReference(historyId);
                if (href.getHistoryType() != 14) {
                    this.addToMap(href);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return href;
    }

    public int getLastHistoryId() {
        return Model.getSingleton().getDb().getTableHistory().lastIndex();
    }

    public void addHistory(HttpMessage msg, int type) {
        try {
            this.addHistory(new HistoryReference(Model.getSingleton().getSession(), type, msg));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addToMap(HistoryReference historyRef) {
        this.historyIdToRef.put(historyRef.getHistoryId(), historyRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(HistoryReference historyRef) {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        try {
            HistoryTableModel historyTableModel = this.historyTableModel;
            synchronized (historyTableModel) {
                if (ExtensionHistory.isHistoryTypeToShow(historyRef.getHistoryType())) {
                    String uri = historyRef.getURI().toString();
                    if (this.showJustInScope && !this.getModel().getSession().isInScope(uri)) {
                        this.addToMap(historyRef);
                        return;
                    }
                    if (this.linkWithSitesTree && this.linkWithSitesTreeBaseUri != null && !uri.startsWith(this.linkWithSitesTreeBaseUri)) {
                        this.addToMap(historyRef);
                        return;
                    }
                    if (this.getView() != null) {
                        HistoryFilterPlusDialog dialog = this.getFilterPlusDialog();
                        HistoryFilter historyFilter = dialog.getFilter();
                        if (historyFilter != null && !historyFilter.matches(historyRef)) {
                            this.addToMap(historyRef);
                            return;
                        }
                        this.addHistoryInEventQueue(historyRef);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isHistoryTypeToShow(int historyType) {
        return historyType == 1 || historyType == 15 || historyType == 11 || historyType == 16;
    }

    private void addHistoryInEventQueue(final HistoryReference ref) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.addHistoryReference(ref);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionHistory.this.addHistoryInEventQueue(ref);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchHistory(HistoryFilter historyFilter) {
        Session session = this.getModel().getSession();
        HistoryTableModel historyTableModel = this.historyTableModel;
        synchronized (historyTableModel) {
            try {
                List<Integer> list = this.getModel().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 1, 15, 16);
                this.buildHistory(list, historyFilter);
            }
            catch (DatabaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHistory(List<Integer> dbList, HistoryFilter historyFilter) {
        HistoryReference historyRef = null;
        HistoryTableModel historyTableModel = this.historyTableModel;
        synchronized (historyTableModel) {
            if (this.getView() != null) {
                this.getLogPanel().setModel(EMPTY_MODEL);
            }
            this.historyTableModel.clear();
            for (int i = 0; i < dbList.size(); ++i) {
                int historyId = dbList.get(i);
                try {
                    SiteNode sn = this.getModel().getSession().getSiteTree().getSiteNode(historyId);
                    if (sn != null && sn.getHistoryReference() != null && sn.getHistoryReference().getHistoryId() == historyId) {
                        historyRef = sn.getHistoryReference();
                    } else {
                        historyRef = this.getHistoryReference(historyId);
                        if (sn != null) {
                            sn.setHistoryReference(historyRef);
                        }
                    }
                    String uri = historyRef.getURI().toString();
                    if (this.showJustInScope && !this.getModel().getSession().isInScope(uri) || this.linkWithSitesTree && this.linkWithSitesTreeBaseUri != null && !uri.startsWith(this.linkWithSitesTreeBaseUri) || historyFilter != null && !historyFilter.matches(historyRef)) continue;
                    historyRef.loadAlerts();
                    this.historyTableModel.addHistoryReference(historyRef);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.getView() != null) {
                this.getLogPanel().setModel(this.historyTableModel);
            }
        }
    }

    private HistoryFilterPlusDialog getFilterPlusDialog() {
        if (this.filterPlusDialog == null) {
            this.filterPlusDialog = new HistoryFilterPlusDialog((Frame)this.getView().getMainFrame(), true);
        }
        return this.filterPlusDialog;
    }

    protected int showFilterPlusDialog() {
        HistoryFilterPlusDialog dialog = this.getFilterPlusDialog();
        dialog.setModal(true);
        try {
            dialog.setAllTags(this.getModel().getDb().getTableTag().getAllTags());
        }
        catch (DatabaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int exit = dialog.showDialog();
        int result = 0;
        HistoryFilter historyFilter = dialog.getFilter();
        if (exit == 0) {
            this.searchHistory(historyFilter);
            this.logPanel.setFilterStatus(historyFilter);
            result = 1;
        } else if (exit == 1) {
            this.searchHistory(historyFilter);
            this.logPanel.setFilterStatus(historyFilter);
            result = -1;
        }
        return result;
    }

    private PopupMenuPurgeHistory getPopupMenuPurgeHistory() {
        if (this.popupMenuPurgeHistory == null) {
            this.popupMenuPurgeHistory = new PopupMenuPurgeHistory(this);
        }
        return this.popupMenuPurgeHistory;
    }

    public ManualRequestEditorDialog getResendDialog() {
        if (this.resendDialog == null) {
            this.resendDialog = new ManualHttpRequestEditorDialog(true, "resend", "ui.dialogs.resend");
            this.resendDialog.setTitle(Constant.messages.getString("manReq.dialog.title"));
        }
        return this.resendDialog;
    }

    private PopupMenuExportMessage getPopupMenuExportMessage2() {
        if (this.popupMenuExportMessage2 == null) {
            this.popupMenuExportMessage2 = new PopupMenuExportMessage();
            this.popupMenuExportMessage2.setExtension(this);
        }
        return this.popupMenuExportMessage2;
    }

    private PopupMenuExportResponse getPopupMenuExportResponse2() {
        if (this.popupMenuExportResponse2 == null) {
            this.popupMenuExportResponse2 = new PopupMenuExportResponse();
            this.popupMenuExportResponse2.setExtension(this);
        }
        return this.popupMenuExportResponse2;
    }

    private PopupMenuTag getPopupMenuTag() {
        if (this.popupMenuTag == null) {
            this.popupMenuTag = new PopupMenuTag(this);
        }
        return this.popupMenuTag;
    }

    private PopupMenuNote getPopupMenuNote() {
        if (this.popupMenuNote == null) {
            this.popupMenuNote = new PopupMenuNote(this);
        }
        return this.popupMenuNote;
    }

    private void populateNotesAddDialogAndSetVisible(HistoryReference ref, String note) {
        this.dialogNotesAdd.setNote(note);
        this.dialogNotesAdd.setHistoryRef(ref);
        this.dialogNotesAdd.setVisible(true);
    }

    public void showNotesAddDialog(HistoryReference ref, String note) {
        if (this.dialogNotesAdd == null) {
            this.dialogNotesAdd = new NotesAddDialog((Frame)this.getView().getMainFrame(), false);
            this.populateNotesAddDialogAndSetVisible(ref, note);
        } else if (!this.dialogNotesAdd.isVisible()) {
            this.populateNotesAddDialogAndSetVisible(ref, note);
        }
    }

    @Deprecated
    public void hideNotesAddDialog() {
    }

    @Deprecated
    public void showAlertAddDialog(HistoryReference ref) {
        ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
        if (extAlert == null) {
            return;
        }
        extAlert.showAlertAddDialog(ref);
    }

    @Deprecated
    public void showAlertAddDialog(HttpMessage httpMessage, int historyType) {
        ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
        if (extAlert == null) {
            return;
        }
        extAlert.showAlertAddDialog(httpMessage, historyType);
    }

    @Deprecated
    public void showAlertAddDialog(Alert alert) {
        ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
        if (extAlert == null) {
            return;
        }
        extAlert.showAlertEditDialog(alert);
    }

    private void populateManageTagsDialogAndSetVisible(HistoryReference ref, List<String> tags) {
        try {
            this.manageTags.setAllTags(this.getModel().getDb().getTableTag().getAllTags());
        }
        catch (DatabaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.manageTags.setTags(tags);
        this.manageTags.setHistoryRef(ref);
        this.manageTags.setVisible(true);
    }

    public void showManageTagsDialog(HistoryReference ref, List<String> tags) {
        if (this.manageTags == null) {
            this.manageTags = new ManageTagsDialog((Frame)this.getView().getMainFrame(), false);
            this.populateManageTagsDialogAndSetVisible(ref, tags);
        } else if (!this.manageTags.isVisible()) {
            this.populateManageTagsDialogAndSetVisible(ref, tags);
        }
    }

    private PopupMenuExportURLs getPopupMenuExportURLs() {
        if (this.popupMenuExportURLs == null) {
            this.popupMenuExportURLs = this.createPopupMenuExportURLs();
        }
        return this.popupMenuExportURLs;
    }

    private PopupMenuExportURLs createPopupMenuExportURLs() {
        return new PopupMenuExportURLs(Constant.messages.getString("exportUrls.popup"), this);
    }

    private PopupMenuExportSelectedURLs getPopupMenuExportSelectedURLs() {
        if (this.popupMenuExportSelectedURLs == null) {
            this.popupMenuExportSelectedURLs = this.createPopupMenuExportSelectedURLs();
        }
        return this.popupMenuExportSelectedURLs;
    }

    private PopupMenuExportSelectedURLs createPopupMenuExportSelectedURLs() {
        return new PopupMenuExportSelectedURLs(Constant.messages.getString("exportUrls.popup.selected"), this);
    }

    private PopupMenuExportContextURLs getPopupMenuExportContextURLs() {
        if (this.popupMenuExportContextURLs == null) {
            this.popupMenuExportContextURLs = new PopupMenuExportContextURLs(Constant.messages.getString("context.export.urls.menu"), this);
        }
        return this.popupMenuExportContextURLs;
    }

    public void showInHistory(HistoryReference href) {
        this.getLogPanel().display(href);
        this.getLogPanel().setTabFocus();
    }

    @Override
    public void sessionAboutToChange(final Session session) {
        this.sessionChanging = true;
        if (this.getView() == null || EventQueue.isDispatchThread()) {
            this.historyTableModel.clear();
            this.historyIdToRef.clear();
            if (this.getView() != null) {
                this.getView().displayMessage(null);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionHistory.this.sessionAboutToChange(session);
                    }
                });
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    public boolean isShowJustInScope() {
        return this.showJustInScope;
    }

    public void setShowJustInScope(boolean showJustInScope) {
        this.showJustInScope = showJustInScope;
        if (showJustInScope) {
            this.linkWithSitesTree = false;
        }
        this.searchHistory(this.getFilterPlusDialog().getFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(SiteMap map, SiteNode node) {
        SiteNode child = null;
        SiteMap siteMap = map;
        synchronized (siteMap) {
            while (node.getChildCount() > 0) {
                try {
                    child = (SiteNode)node.getChildAt(0);
                    this.purge(map, child);
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (node.isRoot()) {
                return;
            }
            this.removeFromHistoryList(node.getHistoryReference());
            ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
            if (node.getHistoryReference() != null) {
                ExtensionHistory.deleteAlertsFromExtensionAlert(extAlert, node.getHistoryReference());
                node.getHistoryReference().delete();
                map.removeHistoryReference(node.getHistoryReference().getHistoryId());
            }
            while (node.getPastHistoryReference().size() > 0) {
                HistoryReference ref = node.getPastHistoryReference().get(0);
                ExtensionHistory.deleteAlertsFromExtensionAlert(extAlert, ref);
                this.removeFromHistoryList(ref);
                this.delete(ref);
                node.getPastHistoryReference().remove(0);
                map.removeHistoryReference(ref.getHistoryId());
            }
            map.removeNodeFromParent(node);
        }
    }

    private static void deleteAlertsFromExtensionAlert(ExtensionAlert extAlert, HistoryReference historyReference) {
        if (extAlert == null) {
            return;
        }
        extAlert.deleteHistoryReferenceAlerts(historyReference);
    }

    void setLinkWithSitesTree(boolean linkWithSitesTree, String baseUri) {
        this.linkWithSitesTree = linkWithSitesTree;
        this.linkWithSitesTreeBaseUri = baseUri;
        if (linkWithSitesTree) {
            this.showJustInScope = false;
        }
        this.searchHistory(this.getFilterPlusDialog().getFilter());
    }

    void updateLinkWithSitesTreeBaseUri(String baseUri) {
        this.linkWithSitesTreeBaseUri = baseUri;
        this.searchHistory(this.getFilterPlusDialog().getFilter());
    }

    @Override
    public void sessionScopeChanged(Session session) {
        if (this.sessionChanging) {
            return;
        }
        this.sessionChanged();
    }

    private void sessionChanged() {
        if (this.getView() != null) {
            this.searchHistory(this.getFilterPlusDialog().getFilter());
        } else {
            this.searchHistory(null);
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeHistory(List<HistoryReference> hrefs) {
        int result;
        if (this.getView() != null && hrefs.size() > 1 && (result = this.getView().showConfirmDialog(Constant.messages.getString("history.purge.warning"))) != 0) {
            return;
        }
        ExtensionHistory extensionHistory = this;
        synchronized (extensionHistory) {
            for (HistoryReference href : hrefs) {
                this.purgeHistory(href);
            }
        }
    }

    private void purgeHistory(HistoryReference href) {
        SiteNode node;
        if (href == null) {
            return;
        }
        this.removeFromHistoryList(href);
        ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
        if (extAlert != null) {
            extAlert.deleteHistoryReferenceAlerts(href);
        }
        if ((node = href.getSiteNode()) != null) {
            SiteMap map = Model.getSingleton().getSession().getSiteTree();
            if (node.getHistoryReference() != href) {
                node.getPastHistoryReference().remove(href);
            } else if (!node.getPastHistoryReference().isEmpty()) {
                node.setHistoryReference(node.getPastHistoryReference().remove(0));
                node.getPastHistoryReference().remove(href);
            } else if (node.isLeaf()) {
                SiteNode parent = node.getParent();
                map.removeNodeFromParent(node);
                this.purgeTemporaryParents(map, parent);
            } else {
                try {
                    node.setHistoryReference(map.createReference(node, href, href.getHttpMessage()));
                }
                catch (NullPointerException | URIException | DatabaseException | HttpMalformedHeaderException e) {
                    this.logger.error((Object)"Failed to create temporary node:", e);
                }
            }
            map.removeHistoryReference(href.getHistoryId());
        }
        this.delete(href);
    }

    private void purgeTemporaryParents(SiteMap map, SiteNode node) {
        if (node == null || node.isRoot() || !node.isLeaf() || node.getHistoryReference().getHistoryType() != 0) {
            return;
        }
        SiteNode parent = node.getParent();
        this.purge(map, node);
        this.purgeTemporaryParents(map, parent);
    }

    private class EventConsumerImpl
    implements EventConsumer {
        private EventConsumerImpl() {
        }

        @Override
        public void eventReceived(Event event) {
            switch (event.getEventType()) {
                case "href.note.set": 
                case "href.tag.added": 
                case "href.tag.removed": 
                case "href.tags.set": {
                    ExtensionHistory.this.notifyHistoryItemChanged(Integer.valueOf(event.getParameters().get("historyReferenceId")));
                    break;
                }
                case "alert.added": 
                case "alert.changed": 
                case "alert.removed": {
                    ExtensionHistory.this.notifyHistoryItemChanged(Integer.valueOf(event.getParameters().get("historyId")));
                    break;
                }
                default: {
                    ExtensionHistory.this.notifyHistoryItemsChanged();
                }
            }
        }
    }
}

