/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class Prefix
extends Primitive {
    private byte prefix;

    public Prefix(String string, byte by) {
        super(string);
        this.prefix = by;
    }

    @Override
    public Object clone() {
        return new Prefix(this.getName(), this.prefix);
    }

    @Override
    public byte getPrefix() {
        return this.prefix;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popToken(TeXObjectList.POP_IGNORE_LEADING_SPACE);
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        int n = this.getPrefix();
        while (teXObject instanceof Prefix) {
            n |= ((Prefix)teXObject).getPrefix();
            teXObject = teXObjectList.popToken(TeXObjectList.POP_IGNORE_LEADING_SPACE);
            if (!(teXObject instanceof TeXCsRef)) continue;
            teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject instanceof Macro) {
            ((Macro)teXObject).setPrefix((byte)n);
            if (teXParser == teXObjectList) {
                teXObject.process(teXParser);
            } else {
                teXObject.process(teXParser, teXObjectList);
            }
            ((Macro)teXObject).clearPrefix();
        } else {
            teXObjectList.push(teXObject);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

