/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.gls2bib;

import com.dickimawbooks.gls2bib.Gls2BibException;
import com.dickimawbooks.gls2bib.Gls2BibMessages;
import com.dickimawbooks.gls2bib.GlsData;
import com.dickimawbooks.gls2bib.GlsExpandFields;
import com.dickimawbooks.gls2bib.GlsSetExpandField;
import com.dickimawbooks.gls2bib.LongNewGlossaryEntry;
import com.dickimawbooks.gls2bib.NewAbbreviation;
import com.dickimawbooks.gls2bib.NewDualEntry;
import com.dickimawbooks.gls2bib.NewGlossaryEntry;
import com.dickimawbooks.gls2bib.NewNumber;
import com.dickimawbooks.gls2bib.NewSymbol;
import com.dickimawbooks.gls2bib.NewTerm;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class Gls2Bib
extends LaTeXParserListener
implements Writeable,
TeXApp {
    public static final String VERSION = "1.4";
    public static final String DATE = "2018-04-09";
    private Vector<GlsData> data;
    private File texFile;
    private File bibFile;
    private Charset charset = null;
    private String bibCharsetName = null;
    private String spaceSub = null;
    private boolean ignoreSortField = true;
    private Gls2BibMessages messages;
    public static final int SILENT = 0;
    public static final int NORMAL = 1;
    public static final int DEBUG = 2;
    private int verboseLevel = 1;
    private boolean expandFields = false;
    private HashMap<String, Boolean> expandFieldMap;
    private HashMap<String, String> keyToFieldMap;
    private TeXParser texParser;

    public Gls2Bib(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws Gls2BibException, IOException {
        super(null);
        this.verboseLevel = n;
        this.ignoreSortField = bl;
        this.initMessages(string6);
        this.texFile = new File(string);
        this.bibFile = new File(string2);
        this.bibCharsetName = string4;
        this.spaceSub = string5;
        if (" ".equals(string5)) {
            this.spaceSub = null;
        }
        this.charset = string3 == null ? Charset.defaultCharset() : Charset.forName(string3);
        if (this.bibCharsetName == null) {
            this.bibCharsetName = this.charset.name();
        }
        this.initKeyToFieldMap();
        this.setWriteable(this);
        this.texParser = new TeXParser(this);
    }

    private void initKeyToFieldMap() {
        this.keyToFieldMap = new HashMap();
        this.keyToFieldMap.put("sortvalue", "sort");
        this.keyToFieldMap.put("firstpl", "firstplural");
        this.keyToFieldMap.put("desc", "description");
        this.keyToFieldMap.put("descplural", "descriptionplural");
        this.keyToFieldMap.put("useri", "user1");
        this.keyToFieldMap.put("userii", "user2");
        this.keyToFieldMap.put("useriii", "user3");
        this.keyToFieldMap.put("useriv", "user4");
        this.keyToFieldMap.put("userv", "user5");
        this.keyToFieldMap.put("uservi", "user6");
        this.keyToFieldMap.put("longpl", "longplural");
        this.keyToFieldMap.put("shortpl", "shortplural");
    }

    @Override
    public TeXApp getTeXApp() {
        return this;
    }

    public boolean ignoreSort() {
        return this.ignoreSortField;
    }

    public String getSpaceSub() {
        return this.spaceSub;
    }

    public void debug(String string) {
        if (this.verboseLevel >= 2) {
            System.out.println(string);
        }
    }

    public void debug(Throwable throwable) {
        if (this.verboseLevel >= 2) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.parser.putControlSequence(new NewGlossaryEntry(this));
        this.parser.putControlSequence(new NewGlossaryEntry("newentry", this));
        this.parser.putControlSequence(new NewGlossaryEntry("provideglossaryentry", this, true));
        this.parser.putControlSequence(new LongNewGlossaryEntry(this));
        this.parser.putControlSequence(new LongNewGlossaryEntry("longprovideglossaryentry", this, true));
        this.parser.putControlSequence(new NewAbbreviation(this));
        this.parser.putControlSequence(new NewAbbreviation("newacronym", "acronym", this));
        this.parser.putControlSequence(new NewTerm(this));
        this.parser.putControlSequence(new NewNumber(this));
        this.parser.putControlSequence(new NewNumber("newnum", this));
        this.parser.putControlSequence(new NewSymbol(this));
        this.parser.putControlSequence(new NewSymbol("newsym", this));
        this.parser.putControlSequence(new NewDualEntry(this));
        this.parser.putControlSequence(new GlsExpandFields(this));
        this.parser.putControlSequence(new GlsExpandFields("glsnoexpandfields", false, this));
        this.parser.putControlSequence(new GlsSetExpandField(this));
        this.parser.putControlSequence(new GlsSetExpandField("glssetnoexpandfield", false, this));
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new Undefined(string, this.verboseLevel == 0 ? (byte)3 : 1);
    }

    @Override
    public void newcommand(byte by, String string, String string2, boolean bl, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        if (string2.equals("newdualentry") && by == 0) {
            this.message(this.getMessage("gls2bib.override.newdualentry"));
            this.addLaTeXCommand(string2, bl, n, teXObject, teXObject2);
            return;
        }
        super.newcommand(by, string, string2, bl, n, teXObject, teXObject2);
    }

    @Override
    public void write(String string) throws IOException {
    }

    @Override
    public void writeln(String string) throws IOException {
    }

    @Override
    public void write(char c) throws IOException {
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        this.debug("Ignoring \\overwithdelims");
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        this.debug("Ignoring \\abovewithdelims");
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
        this.debug("Ignoring \\href");
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
        this.debug("Ignoring _");
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
        this.debug("Ignoring ^");
    }

    @Override
    public void includegraphics(KeyValList keyValList, String string) throws IOException {
        this.debug("Ignoring \\includegraphics");
    }

    @Override
    public boolean isWriteAccessAllowed(File file) {
        return file.canWrite();
    }

    @Override
    public boolean isWriteAccessAllowed(TeXPath teXPath) {
        return teXPath.getFile().canWrite();
    }

    @Override
    public boolean isReadAccessAllowed(File file) {
        return file.canRead();
    }

    @Override
    public boolean isReadAccessAllowed(TeXPath teXPath) {
        return teXPath.getFile().canRead();
    }

    @Override
    public void copyFile(File file, File file2) throws IOException, InterruptedException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request to copy files %s -> %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public String requestUserInput(String string) throws IOException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request for user input. Message: %s%n", string);
        }
        return "";
    }

    @Override
    public String kpsewhich(String string) {
        return null;
    }

    @Override
    public void epstopdf(File file, File file2) throws IOException, InterruptedException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void wmftoeps(File file, File file2) throws IOException, InterruptedException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void progress(int n) {
    }

    @Override
    public void substituting(TeXParser teXParser, String string, String string2) {
        this.debug(this.getMessage("warning.substituting", string, string2));
    }

    @Override
    public void substituting(String string, String string2) {
        this.debug(this.getMessage("warning.substituting", string, string2));
    }

    public String getMessage(String string) {
        if (this.messages == null) {
            return string;
        }
        String string2 = string;
        try {
            string2 = this.messages.getMessage(string, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning(String.format("Error fetching message for label '%s': %s", string, illegalArgumentException.getMessage()), illegalArgumentException);
        }
        return string2;
    }

    public String getMessage(String string, String string2) {
        if (this.messages == null) {
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(String string, String[] stringArray) {
        if (this.messages == null) {
            String string2 = stringArray.length == 0 ? "" : stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + "," + stringArray[0];
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    @Override
    public String getMessage(String string, Object ... objectArray) {
        if (this.messages == null) {
            String string2 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(TeXParser teXParser, String string, Object ... objectArray) {
        if (teXParser == null) {
            return this.getMessage(string, objectArray);
        }
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n == -1 || file == null) {
            return this.getMessage(string, objectArray);
        }
        return Gls2Bib.fileLineMessage(file, n, this.getMessage(string, objectArray));
    }

    public String getMessageWithFallback(String string, String string2, Object ... objectArray) {
        if (this.messages == null) {
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
        try {
            return this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
    }

    public String getChoiceMessage(String string, int n, String string2, int n2, Object ... objectArray) {
        if (this.messages == null) {
            String string3 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = string3 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string3);
        }
        String string4 = string;
        try {
            string4 = this.messages.getChoiceMessage(string, n, string2, n2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string4;
    }

    @Override
    public void message(String string) {
        if (this.verboseLevel != 0) {
            System.out.println(string);
        }
    }

    public static String fileLineMessage(File file, int n, String string) {
        return String.format("%s:%d: %s", file.toString(), n, string);
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file) throws IOException {
        this.message(this.getMessage("message.reading", file));
    }

    @Override
    public Charset getCharSet() {
        return this.charset;
    }

    @Override
    public void warning(TeXParser teXParser, String string) {
        if (this.verboseLevel != 0) {
            int n = teXParser.getLineNumber();
            File file = teXParser.getCurrentFile();
            if (n == -1 || file == null) {
                this.warning(string);
            } else {
                this.warning(file, n, string);
            }
        }
    }

    public void warning(File file, int n, String string) {
        this.warning(Gls2Bib.fileLineMessage(file, n, string));
    }

    public void warning(File file, int n, String string, Exception exception) {
        this.warning(Gls2Bib.fileLineMessage(file, n, string), exception);
    }

    public void warning(String string) {
        if (this.verboseLevel != 0) {
            string = this.getMessageWithFallback("warning.title", "Warning: {0}", string);
            System.err.println(string);
        }
    }

    public void warning() {
        if (this.verboseLevel != 0) {
            System.err.println();
        }
    }

    public void warning(String string, Exception exception) {
        if (this.verboseLevel >= 1) {
            System.err.println(string);
            if (this.verboseLevel >= 2) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void error(Exception exception) {
        if (exception instanceof TeXSyntaxException) {
            this.error(((TeXSyntaxException)exception).getMessage(this));
        } else {
            String string = exception.getMessage();
            if (string == null) {
                string = exception.getClass().getSimpleName();
            }
            this.error(string);
        }
        if (this.verboseLevel >= 2) {
            exception.printStackTrace();
        }
    }

    public void error(String string) {
        string = this.getMessageWithFallback("error.title", "Error: {0}", string);
        System.err.println(string);
    }

    @Override
    public float emToPt(float f) {
        this.warning(this.getParser(), "Can't convert from em to pt, no font information loaded");
        return 9.5f * f;
    }

    @Override
    public float exToPt(float f) {
        this.warning(this.getParser(), "Can't convert from ex to pt, no font information loaded");
        return 4.4f * f;
    }

    public void addData(GlsData glsData) {
        this.data.add(glsData);
    }

    public boolean hasEntry(String string) {
        for (GlsData glsData : this.data) {
            if (!glsData.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        this.data = new Vector();
        this.parser.parse(this.texFile);
        try (PrintWriter printWriter = null;){
            if (this.data.isEmpty()) {
                throw new IOException("No entries found");
            }
            this.message(this.getMessage("message.writing", this.bibFile));
            if (this.bibCharsetName == null) {
                printWriter = new PrintWriter(this.bibFile);
            } else {
                printWriter = new PrintWriter(this.bibFile, this.bibCharsetName);
                printWriter.println("% Encoding: " + this.bibCharsetName);
            }
            for (GlsData glsData : this.data) {
                glsData.writeBibEntry(printWriter);
            }
        }
    }

    private String getLanguageFileName(String string) {
        return String.format("/resources/bib2gls-%s.xml", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMessages(String string) throws Gls2BibException, IOException {
        Object object;
        Locale locale = string == null || "".equals(string) ? Locale.getDefault() : Locale.forLanguageTag(string);
        String string2 = locale.toLanguageTag();
        String string3 = this.getLanguageFileName(string2);
        URL uRL = this.getClass().getResource(string3);
        String string4 = "";
        if (this.verboseLevel >= 2) {
            string4 = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        if (uRL == null) {
            this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
            string2 = locale.getLanguage();
            string3 = this.getLanguageFileName(string2);
            this.debug("Trying: " + string3);
            uRL = this.getClass().getResource(string3);
            if (uRL == null) {
                this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
                object = locale.getScript();
                if (object != null && !((String)object).isEmpty()) {
                    string3 = this.getLanguageFileName(String.format("%s-%s", string2, object));
                    this.debug("Trying: " + string3);
                    uRL = this.getClass().getResource(string3);
                    if (uRL == null && !string2.equals("en")) {
                        this.debug(String.format("Can't find language resource: %s!%s%nDefaulting to 'en'", string4, string3));
                        uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                    }
                } else if (!string2.equals("en")) {
                    this.debug("Defaulting to 'en'");
                    uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                }
                if (uRL == null) {
                    throw new Gls2BibException("Can't find language resource file.");
                }
            }
        }
        object = null;
        try {
            this.debug("Reading " + uRL);
            object = uRL.openStream();
            Properties properties = new Properties();
            properties.loadFromXML((InputStream)object);
            ((InputStream)object).close();
            object = null;
            this.messages = new Gls2BibMessages(properties);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public static void version() {
        System.out.println(String.format("convertgls2bib v%s (%s)", VERSION, DATE));
        System.out.println("Copyright 2017 Nicola Talbot");
        System.out.print("License GPLv3+: GNU GPL version 3 or later");
        System.out.println(" <http://gnu.org/licenses/gpl.html>");
        System.out.print("This is free software: you are free to change");
        System.out.println(" and redistribute it.");
        System.out.println("There is NO WARRANTY, to the extent permitted by law.");
    }

    public static void help() {
        System.out.println("convertgls2bib [<options>] <tex file> <bib file>");
        System.out.println("Options:");
        System.out.println("--version (or -v)\tDisplay version information");
        System.out.println("--help (or -h)\t\tDisplay help");
        System.out.println("--texenc <encoding>\t.tex file encoding");
        System.out.println("--bibenc <encoding>\t.bib file encoding");
        System.out.println("--ignore-sort\t\tignore sort field (default)");
        System.out.println("--no-ignore-sort\tdon't ignore sort field");
        System.out.println("--space-sub <value>\tsubstitute spaces in labels with <value>");
        System.out.println("--locale <lang tag>\tuse language resource file for locale given by <lang tag>");
        System.out.println("--silent\tsuppress messages");
        System.out.println("--verbose\tnormal messages");
        System.out.println("--debug\tdebug mode");
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = true;
        int n = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--help") || stringArray[i].equals("-h")) {
                Gls2Bib.help();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("--version") || stringArray[i].equals("-v")) {
                Gls2Bib.version();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("--texenc")) {
                if (i == stringArray.length - 1) {
                    System.err.println("Missing <encoding> after " + stringArray[i]);
                    System.exit(1);
                }
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--bibenc")) {
                if (i == stringArray.length - 1) {
                    System.err.println("Missing <encoding> after " + stringArray[i]);
                    System.exit(1);
                }
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--space-sub")) {
                if (i == stringArray.length - 1) {
                    System.err.println("Missing <value> after " + stringArray[i]);
                    System.exit(1);
                }
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--locale")) {
                if (i == stringArray.length - 1) {
                    System.err.println("Missing <lang tag> after " + stringArray[i]);
                    System.exit(1);
                }
                string6 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--ignore-sort")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--no-ignore-sort")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equals("--debug")) {
                n = 2;
                continue;
            }
            if (stringArray[i].equals("--silent")) {
                n = 0;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                n = 1;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.err.println("Unknown option: " + stringArray[i]);
                System.err.println("Use --help for help.");
                System.exit(1);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            System.err.println("Too many arguments");
            System.err.println("Use --help for help.");
            System.exit(1);
        }
        if (string == null) {
            System.err.println("Missing <tex file>");
            Gls2Bib.help();
            System.exit(1);
        }
        if (string2 == null) {
            System.err.println("Missing <bib file>");
            Gls2Bib.help();
            System.exit(1);
        }
        try {
            Gls2Bib gls2Bib = new Gls2Bib(string, string2, string3, string4, string5, string6, bl, n);
            gls2Bib.process();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(3);
        }
    }

    public boolean fieldExpansionOn(String string) {
        Boolean bl;
        if (this.expandFieldMap != null && (bl = this.expandFieldMap.get(string)) != null) {
            return bl;
        }
        return this.expandFields;
    }

    public void setFieldExpansion(boolean bl) {
        this.expandFields = bl;
    }

    public void setFieldExpansion(String string, boolean bl) {
        String string2 = this.keyToFieldMap.get(string);
        if (string2 != null) {
            string = string2;
        }
        if (this.expandFieldMap == null) {
            this.expandFieldMap = new HashMap();
        }
        this.expandFieldMap.put(string, bl);
    }
}

