/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgChangesParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgHistoryUtil {
    private static final Logger LOG = Logger.getInstance(HgHistoryUtil.class);

    private HgHistoryUtil() {
    }

    @NotNull
    public static List<VcsCommitMetadata> loadMetadata(@NotNull Project project, final @NotNull VirtualFile root, int limit, @NotNull List<String> parameters) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(2);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<VcsCommitMetadata> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtilRt.toStringArray(templateList);
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, parameters, HgChangesetUtil.makeTemplate(templates));
        HgBaseLogParser<VcsCommitMetadata> baseParser = new HgBaseLogParser<VcsCommitMetadata>(){

            @Override
            protected VcsCommitMetadata convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<? extends HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changeset == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (parents == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (revisionDate == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (author == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (email == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (attributes == null) {
                    1.$$$reportNull$$$0(6);
                }
                String message = 1.parseAdditionalStringAttribute(attributes, 5);
                String subject = 1.extractSubject(message);
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                return factory.createCommitMetadata(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, message, author, email, revisionDate.getTime());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rev";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeset";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "revisionDate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "author";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "email";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$1";
                objectArray[2] = "convertDetails";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        List<VcsCommitMetadata> list = HgHistoryUtil.getCommitRecords(project, result, baseParser);
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<VcsFullCommitDetails> history(@NotNull Project project, @NotNull VirtualFile root, int limit, @NotNull List<String> hashParameters, boolean silent) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(5);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(6);
        }
        if (hashParameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(7);
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        ArrayList<VcsFullCommitDetails> result = new ArrayList<VcsFullCommitDetails>();
        VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<VcsFullCommitDetails> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        HgFileRevisionLogParser parser = new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), hgvcs.getVersion());
        try {
            HgHistoryUtil.readLog(project, root, hgvcs.getVersion(), limit, hashParameters, HgChangesetUtil.makeTemplate(templates), (Consumer<? super StringBuilder>)((Consumer)stringBuilder -> {
                HgFileRevision revision = (HgFileRevision)parser.convert(stringBuilder.toString());
                if (revision != null) {
                    result.add(HgHistoryUtil.createDetails(project, root, factory, revision));
                }
            }));
        }
        catch (VcsException e) {
            if (!silent) {
                VcsNotifier.getInstance((Project)project).notifyError(HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), e.getMessage());
            }
            throw e;
        }
        ArrayList<VcsFullCommitDetails> arrayList = result;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> createFullCommitsFromResult(@NotNull Project project, @NotNull VirtualFile root, @Nullable HgCommandResult result, @NotNull HgVersion version, boolean silent) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(10);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(11);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(12);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<HgFileRevision> hgRevisions = HgHistoryUtil.getCommitRecords(project, result, new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), version), silent);
        ArrayList<VcsFullCommitDetails> vcsFullCommitDetailsList = new ArrayList<VcsFullCommitDetails>();
        for (HgFileRevision revision : hgRevisions) {
            vcsFullCommitDetailsList.add(HgHistoryUtil.createDetails(project, root, factory, revision));
        }
        ArrayList<VcsFullCommitDetails> arrayList = vcsFullCommitDetailsList;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static VcsFullCommitDetails createDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsLogObjectsFactory factory, @NotNull HgFileRevision revision) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(15);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(16);
        }
        if (factory == null) {
            HgHistoryUtil.$$$reportNull$$$0(17);
        }
        if (revision == null) {
            HgHistoryUtil.$$$reportNull$$$0(18);
        }
        ArrayList<List<VcsFileStatusInfo>> reportedChanges = new ArrayList<List<VcsFileStatusInfo>>();
        reportedChanges.add(HgHistoryUtil.getStatusInfo(revision));
        HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
        List<? extends HgRevisionNumber> parents = vcsRevisionNumber.getParents();
        for (HgRevisionNumber parent : parents.stream().skip(1L).collect(Collectors.toList())) {
            reportedChanges.add(HgHistoryUtil.getChangesFromParent(project, root, vcsRevisionNumber, parent));
        }
        Hash hash = factory.createHash(vcsRevisionNumber.getChangeset());
        List parentsHashes = ContainerUtil.map(parents, p -> factory.createHash(p.getChangeset()));
        long time = revision.getRevisionDate().getTime();
        VcsUser author = factory.createUser(vcsRevisionNumber.getName(), vcsRevisionNumber.getEmail());
        VcsChangesLazilyParsedDetails vcsChangesLazilyParsedDetails = new VcsChangesLazilyParsedDetails(project, hash, parentsHashes, time, root, vcsRevisionNumber.getSubject(), author, vcsRevisionNumber.getCommitMessage(), author, time, reportedChanges, (VcsChangesLazilyParsedDetails.ChangesParser)new HgChangesParser(vcsRevisionNumber));
        if (vcsChangesLazilyParsedDetails == null) {
            HgHistoryUtil.$$$reportNull$$$0(19);
        }
        return vcsChangesLazilyParsedDetails;
    }

    @NotNull
    protected static List<VcsFileStatusInfo> getChangesFromParent(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgRevisionNumber commit, @NotNull HgRevisionNumber parent) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(21);
        }
        if (commit == null) {
            HgHistoryUtil.$$$reportNull$$$0(22);
        }
        if (parent == null) {
            HgHistoryUtil.$$$reportNull$$$0(23);
        }
        HgStatusCommand status = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(true).baseRevision(parent).targetRevision(commit).build(project);
        List<VcsFileStatusInfo> list = HgHistoryUtil.convertHgChanges(status.executeInCurrentThread(root));
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static List<VcsFileStatusInfo> getStatusInfo(@NotNull HgFileRevision revision) {
        if (revision == null) {
            HgHistoryUtil.$$$reportNull$$$0(25);
        }
        ArrayList<VcsFileStatusInfo> firstParentChanges = new ArrayList<VcsFileStatusInfo>();
        for (String string : revision.getModifiedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.MODIFICATION, string, null));
        }
        for (String string : revision.getAddedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.NEW, string, null));
        }
        for (String string : revision.getDeletedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.DELETED, string, null));
        }
        for (Map.Entry entry : revision.getMovedFiles().entrySet()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.MOVED, (String)entry.getKey(), (String)entry.getValue()));
        }
        ArrayList<VcsFileStatusInfo> arrayList = firstParentChanges;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static List<VcsFileStatusInfo> convertHgChanges(@NotNull Set<HgChange> changes) {
        if (changes == null) {
            HgHistoryUtil.$$$reportNull$$$0(27);
        }
        HashSet<String> deleted = new HashSet<String>();
        HashSet<String> copied = new HashSet<String>();
        for (HgChange change : changes) {
            Change.Type type = HgHistoryUtil.getType(change.getStatus());
            if (Change.Type.DELETED.equals((Object)type)) {
                deleted.add(change.beforeFile().getRelativePath());
                continue;
            }
            if (!Change.Type.MOVED.equals((Object)type)) continue;
            copied.add(change.beforeFile().getRelativePath());
        }
        ArrayList<VcsFileStatusInfo> result = new ArrayList<VcsFileStatusInfo>();
        block5: for (HgChange change : changes) {
            String secondPath;
            String firstPath;
            Change.Type type = HgHistoryUtil.getType(change.getStatus());
            LOG.assertTrue(type != null, (Object)("Unsupported status for change " + change));
            switch (type) {
                case DELETED: {
                    firstPath = change.beforeFile().getRelativePath();
                    secondPath = null;
                    if (!copied.contains(firstPath)) break;
                    continue block5;
                }
                case MOVED: {
                    firstPath = change.beforeFile().getRelativePath();
                    secondPath = change.afterFile().getRelativePath();
                    if (deleted.contains(firstPath)) break;
                    type = Change.Type.NEW;
                    firstPath = change.afterFile().getRelativePath();
                    secondPath = null;
                    break;
                }
                default: {
                    firstPath = change.afterFile().getRelativePath();
                    secondPath = null;
                }
            }
            result.add(new VcsFileStatusInfo(type, (String)ObjectUtils.notNull((Object)firstPath), secondPath));
        }
        ArrayList<VcsFileStatusInfo> arrayList = result;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @Nullable
    private static Change.Type getType(@NotNull HgFileStatusEnum status) {
        if (status == null) {
            HgHistoryUtil.$$$reportNull$$$0(29);
        }
        switch (status) {
            case ADDED: {
                return Change.Type.NEW;
            }
            case MODIFIED: {
                return Change.Type.MODIFICATION;
            }
            case DELETED: {
                return Change.Type.DELETED;
            }
            case COPY: {
                return Change.Type.MOVED;
            }
            case UNVERSIONED: 
            case MISSING: 
            case UNMODIFIED: 
            case IGNORED: {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static HgCommandResult getLogResult(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgVersion version, int limit, @NotNull List<String> parameters, @NotNull String template) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(30);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(31);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(32);
        }
        if (parameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(33);
        }
        if (template == null) {
            HgHistoryUtil.$$$reportNull$$$0(34);
        }
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        ArrayList<String> args = new ArrayList<String>(parameters);
        if (!version.isParentRevisionTemplateSupported()) {
            args.add("--debug");
        }
        return hgLogCommand.execute(root, template, limit, HgHistoryUtil.getOriginalHgFile(project, root), args);
    }

    public static void readLog(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgVersion version, int limit, @NotNull List<String> hashes, @NotNull String template, @NotNull Consumer<? super StringBuilder> consumer) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(35);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(36);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(37);
        }
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(38);
        }
        if (template == null) {
            HgHistoryUtil.$$$reportNull$$$0(39);
        }
        if (consumer == null) {
            HgHistoryUtil.$$$reportNull$$$0(40);
        }
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        ThrowableConsumer logRunner = hashesChunk -> {
            HgLogOutputSplitter splitter = new HgLogOutputSplitter(consumer);
            ArrayList<String> args = new ArrayList<String>((Collection<String>)hashesChunk);
            if (!version.isParentRevisionTemplateSupported()) {
                args.add("--debug");
            }
            hgLogCommand.execute(root, template, limit, HgHistoryUtil.getOriginalHgFile(project, root), args, splitter);
            splitter.finish();
        };
        if (hashes.isEmpty()) {
            logRunner.consume(hashes);
        } else {
            VcsFileUtil.foreachChunk(hashes, (int)2, (ThrowableConsumer)logRunner);
        }
    }

    public static HgFile getOriginalHgFile(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(41);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(42);
        }
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        if (project.isDisposed()) {
            return hgFile;
        }
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)project));
        return new HgFile(hgFile.getRepo(), originalFileName);
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecords(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<? super String, ? extends CommitInfo> converter) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(43);
        }
        if (converter == null) {
            HgHistoryUtil.$$$reportNull$$$0(44);
        }
        List<? extends CommitInfo> list = HgHistoryUtil.getCommitRecords(project, result, converter, false);
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecords(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<? super String, ? extends CommitInfo> converter, boolean silent) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(46);
        }
        if (converter == null) {
            HgHistoryUtil.$$$reportNull$$$0(47);
        }
        LinkedList revisions = new LinkedList();
        if (result == null) {
            LinkedList linkedList = revisions;
            if (linkedList == null) {
                HgHistoryUtil.$$$reportNull$$$0(48);
            }
            return linkedList;
        }
        List<String> errors = result.getErrorLines();
        if (!errors.isEmpty()) {
            if (result.getExitValue() != 0) {
                if (silent) {
                    LOG.debug(errors.toString());
                } else {
                    VcsNotifier.getInstance((Project)project).notifyError(HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), errors.toString());
                }
                List list = Collections.emptyList();
                if (list == null) {
                    HgHistoryUtil.$$$reportNull$$$0(49);
                }
                return list;
            }
            LOG.warn(errors.toString());
        }
        String output = result.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        List list = ContainerUtil.mapNotNull((Collection)changeSets, converter);
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> readCommitMetadata(@NotNull Project project, final @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(51);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(52);
        }
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(53);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(54);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtilRt.toStringArray(templateList);
        List list = VcsFileUtil.foreachChunk(HgHistoryUtil.prepareHashes(hashes), (int)2, strings -> {
            HgCommandResult logResult = HgHistoryUtil.getLogResult(project, root, version, -1, strings, HgChangesetUtil.makeTemplate(templates));
            return HgHistoryUtil.getCommitRecords(project, logResult, new HgBaseLogParser<VcsCommitMetadata>(){

                @Override
                protected VcsCommitMetadata convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<? extends HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                    if (rev == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (changeset == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (parents == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (revisionDate == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (author == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    if (email == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    if (attributes == null) {
                        2.$$$reportNull$$$0(6);
                    }
                    String message = 2.parseAdditionalStringAttribute(attributes, 5);
                    String subject = 2.extractSubject(message);
                    SmartList parentsHash = new SmartList();
                    for (HgRevisionNumber parent : parents) {
                        parentsHash.add(factory.createHash(parent.getChangeset()));
                    }
                    return factory.createCommitMetadata(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, message, author, email, revisionDate.getTime());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "rev";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "changeset";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "parents";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "revisionDate";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[0] = "author";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[0] = "email";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[0] = "attributes";
                            break;
                        }
                    }
                    objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$2";
                    objectArray[2] = "convertDetails";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(55);
        }
        return list;
    }

    @NotNull
    public static List<TimedVcsCommit> readAllHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super VcsUser> userRegistry, @NotNull List<String> params) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(56);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(57);
        }
        if (userRegistry == null) {
            HgHistoryUtil.$$$reportNull$$$0(58);
        }
        if (params == null) {
            HgHistoryUtil.$$$reportNull$$$0(59);
        }
        List<TimedVcsCommit> list = HgHistoryUtil.readHashes(project, root, userRegistry, -1, params);
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(60);
        }
        return list;
    }

    @NotNull
    public static List<TimedVcsCommit> readHashes(@NotNull Project project, @NotNull VirtualFile root, final @NotNull Consumer<? super VcsUser> userRegistry, int limit, @NotNull List<String> params) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(61);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(62);
        }
        if (userRegistry == null) {
            HgHistoryUtil.$$$reportNull$$$0(63);
        }
        if (params == null) {
            HgHistoryUtil.$$$reportNull$$$0(64);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(65);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = ArrayUtilRt.toStringArray(HgBaseLogParser.constructDefaultTemplate(version));
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, params, HgChangesetUtil.makeTemplate(templates));
        List<TimedVcsCommit> list = HgHistoryUtil.getCommitRecords(project, result, new HgBaseLogParser<TimedVcsCommit>(){

            @Override
            protected TimedVcsCommit convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<? extends HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (changeset == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (parents == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (revisionDate == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (author == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (email == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (attributes == null) {
                    3.$$$reportNull$$$0(6);
                }
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                userRegistry.consume((Object)factory.createUser(author, email));
                return factory.createTimedCommit(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rev";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeset";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "revisionDate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "author";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "email";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$3";
                objectArray[2] = "convertDetails";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(66);
        }
        return list;
    }

    @Nullable
    static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(Project project) {
        if (!project.isDisposed()) {
            return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        }
        return null;
    }

    @NotNull
    public static Change createChange(@NotNull Project project, @NotNull VirtualFile root, @Nullable String fileBefore, @Nullable HgRevisionNumber revisionBefore, @Nullable String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        ContentRevision afterRevision;
        HgContentRevision beforeRevision;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(67);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(68);
        }
        HgContentRevision hgContentRevision = beforeRevision = fileBefore == null || aStatus == FileStatus.ADDED ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        if (aStatus == FileStatus.DELETED) {
            afterRevision = null;
        } else if (revisionAfter == null && fileBefore != null) {
            afterRevision = CurrentContentRevision.create((FilePath)new HgFile(root, new File(root.getPath(), fileAfter != null ? fileAfter : fileBefore)).toFilePath());
        } else {
            assert (revisionAfter != null);
            afterRevision = fileAfter == null ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        }
        Change change = new Change(beforeRevision, afterRevision, aStatus);
        if (change == null) {
            HgHistoryUtil.$$$reportNull$$$0(69);
        }
        return change;
    }

    @NotNull
    public static List<String> prepareHashes(@NotNull List<String> hashes) {
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(70);
        }
        ArrayList<String> hashArgs = new ArrayList<String>();
        for (String hash : hashes) {
            hashArgs.add("-r");
            hashArgs.add(hash);
        }
        ArrayList<String> arrayList = hashArgs;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(71);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getDescendingHeadsOfBranches(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(72);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(73);
        }
        if (hash == null) {
            HgHistoryUtil.$$$reportNull$$$0(74);
        }
        HashSet<String> branchHeads = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-r");
        params.add("descendants(" + hash.asString() + ") and head()");
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        String template = HgChangesetUtil.makeTemplate("{branch}", "{bookmarks}");
        HgCommandResult logResult = hgLogCommand.execute(root, template, -1, null, params);
        if (logResult == null || logResult.getExitValue() != 0) {
            throw new VcsException("Couldn't get commit details: log command execution error.");
        }
        String output = logResult.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        for (String line : changeSets) {
            List attributes = StringUtil.split((String)line, (String)"\u0017");
            branchHeads.addAll(attributes);
        }
        HashSet<String> hashSet = branchHeads;
        if (hashSet == null) {
            HgHistoryUtil.$$$reportNull$$$0(75);
        }
        return hashSet;
    }

    public static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 60: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 75: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 60: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 75: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 16: 
            case 21: 
            case 31: 
            case 36: 
            case 42: 
            case 52: 
            case 57: 
            case 62: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 60: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/log/HgHistoryUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashParameters";
                break;
            }
            case 12: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 38: 
            case 53: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/log/HgHistoryUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMetadata";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "history";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFullCommitsFromResult";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetails";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesFromParent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusInfo";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "convertHgChanges";
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitRecords";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "readCommitMetadata";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "readAllHashes";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "readHashes";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHashes";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendingHeadsOfBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadMetadata";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 60: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 75: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "history";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFullCommitsFromResult";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDetails";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChangesFromParent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getStatusInfo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "convertHgChanges";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLogResult";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "readLog";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalHgFile";
                break;
            }
            case 43: 
            case 44: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCommitRecords";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "readCommitMetadata";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "readAllHashes";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "readHashes";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "prepareHashes";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getDescendingHeadsOfBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 60: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 75: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HgLogOutputSplitter
    extends HgLineProcessListener {
        @NotNull
        private final StringBuilder myOutput;
        private final Consumer<? super StringBuilder> myConsumer;

        HgLogOutputSplitter(Consumer<? super StringBuilder> consumer) {
            this.myConsumer = consumer;
            this.myOutput = new StringBuilder();
        }

        @Override
        protected void processOutputLine(@NotNull String line) {
            int separatorIndex;
            if (line == null) {
                HgLogOutputSplitter.$$$reportNull$$$0(0);
            }
            while ((separatorIndex = line.indexOf("\u0003")) >= 0) {
                this.myOutput.append(line, 0, separatorIndex);
                this.myConsumer.consume((Object)this.myOutput);
                this.myOutput.setLength(0);
                line = line.substring(separatorIndex + 1);
            }
            this.myOutput.append(line);
        }

        @Override
        public void finish() throws VcsException {
            super.finish();
            if (this.myOutput.length() != 0) {
                this.myConsumer.consume((Object)this.myOutput);
                this.myOutput.setLength(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/zmlx/hg4idea/log/HgHistoryUtil$HgLogOutputSplitter", "processOutputLine"));
        }
    }
}

