/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchDataImpl;
import com.intellij.vcs.branch.BranchStateProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/zmlx/hg4idea/branch/HgBranchStateProvider;", "Lcom/intellij/vcs/branch/BranchStateProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.hg"})
public final class HgBranchStateProvider
implements BranchStateProvider {
    @NotNull
    private final Project project;

    @Nullable
    public BranchData getCurrentBranch(@NotNull FilePath path) {
        BranchDataImpl branchDataImpl;
        HgRepository repository;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!ProjectLevelVcsManager.getInstance((Project)this.project).checkVcsIsActive("hg4idea")) {
            return null;
        }
        Repository repository2 = VcsRepositoryManager.getInstance((Project)this.project).getRepositoryForFile(path, true);
        if (!(repository2 instanceof HgRepository)) {
            repository2 = null;
        }
        HgRepository hgRepository = repository = (HgRepository)repository2;
        if (hgRepository != null) {
            HgRepository hgRepository2 = hgRepository;
            boolean bl = false;
            boolean bl2 = false;
            HgRepository it = hgRepository2;
            boolean bl3 = false;
            VirtualFile virtualFile = it.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it.root");
            String string = virtualFile.getPresentableName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.root.presentableName");
            branchDataImpl = new BranchDataImpl(string, it.getCurrentBranchName());
        } else {
            branchDataImpl = null;
        }
        return (BranchData)branchDataImpl;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public HgBranchStateProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

