/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    private static final String JEDITERM_USER_RCFILE = "JEDITERM_USER_RCFILE";
    private static final String ZDOTDIR = "ZDOTDIR";
    private static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    private static final String IJ_COMMAND_HISTORY_FILE_ENV = "__INTELLIJ_COMMAND_HISTFILE__";
    private static final String LOGIN_SHELL = "LOGIN_SHELL";
    private static final ImmutableList<String> LOGIN_CLI_OPTIONS = ImmutableList.of((Object)"--login", (Object)"-l");
    private static final String LOGIN_CLI_OPTION = (String)LOGIN_CLI_OPTIONS.get(0);
    private static final String INTERACTIVE_CLI_OPTION = "-i";
    private static final String BASH_NAME = "bash";
    private static final String SH_NAME = "sh";
    private static final String ZSH_NAME = "zsh";
    private static final String FISH_NAME = "fish";
    private final Charset myDefaultCharset = StandardCharsets.UTF_8;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    private static String getShellName(@Nullable String path) {
        if (path == null) {
            return null;
        }
        return new File(path).getName();
    }

    @Nullable
    private static String findRCFile(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        String rcfile = null;
        if (BASH_NAME.equals(shellName) || SH_NAME.equals(shellName)) {
            rcfile = "jediterm-bash.in";
        } else if (ZSH_NAME.equals(shellName)) {
            rcfile = ".zshrc";
        } else if (FISH_NAME.equals(shellName)) {
            rcfile = "fish/config.fish";
        }
        if (rcfile != null) {
            try {
                return LocalTerminalDirectRunner.findAbsolutePath(rcfile);
            }
            catch (Exception e) {
                LOG.warn("Unable to find " + rcfile + " configuration file", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static String findAbsolutePath(@NotNull String relativePath) throws IOException {
        File result;
        String jarPath;
        if (relativePath == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        if ((jarPath = PathUtil.getJarPathForClass(LocalTerminalDirectRunner.class)).endsWith(".jar")) {
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new IOException("Broken installation: " + jarPath + " is not a file");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            result = new File(pluginBaseDir, relativePath);
        } else {
            String srcDir;
            if (ApplicationManager.getApplication().isInternal() && new File(srcDir = (jarPath = StringUtil.trimEnd((String)jarPath.replace('\\', '/'), (char)'/') + '/').replace("/out/classes/production/intellij.terminal/", "/community/plugins/terminal/resources/")).isDirectory()) {
                jarPath = srcDir;
            }
            result = new File(jarPath, relativePath);
        }
        if (!result.isFile()) {
            throw new IOException("Cannot find " + relativePath + ": " + result.getAbsolutePath() + " is not a file");
        }
        String string = result.getAbsolutePath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        LocalTerminalDirectRunner localTerminalDirectRunner = new LocalTerminalDirectRunner(project);
        if (localTerminalDirectRunner == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        return localTerminalDirectRunner;
    }

    private Map<String, String> getTerminalEnvironment() {
        THashMap envs = new THashMap((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        EnvironmentVariablesData envData = TerminalProjectOptionsProvider.getInstance(this.myProject).getEnvData();
        if (envData.isPassParentEnvs()) {
            envs.putAll(System.getenv());
            LocalTerminalDirectRunner.fixPathEnvOnWindows((Map<String, String>)envs);
        }
        if (!SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        envs.put("TERMINAL_EMULATOR", "JetBrains-JediTerm");
        if (SystemInfo.isMac) {
            EnvironmentUtil.setLocaleEnv((Map)envs, (Charset)this.myDefaultCharset);
        }
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)this.myProject);
        for (Map.Entry env : envData.getEnvs().entrySet()) {
            envs.put(env.getKey(), macroManager.expandPath((String)env.getValue()));
        }
        return envs;
    }

    private static void fixPathEnvOnWindows(@NotNull Map<String, String> envs) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isWindows) {
            String[] parts;
            String PATH = "PATH";
            String path = envs.get("PATH");
            if (path != null && (parts = path.split(";", 3)).length == 3 && LocalTerminalDirectRunner.insideIdeHome(parts[0], "\\jbr\\\\bin") && LocalTerminalDirectRunner.insideIdeHome(parts[1], "\\jbr\\\\bin\\server")) {
                envs.put("PATH", parts[2]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PATH changed from " + path + " to " + parts[2]);
                }
            }
        }
    }

    private static boolean insideIdeHome(@NotNull String actualPath, @NotNull String ideHomeSubDirectory) {
        if (actualPath == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        if (ideHomeSubDirectory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(6);
        }
        String ideHome = PathManager.getHomePath();
        return actualPath.equals(ideHome + ideHomeSubDirectory);
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory) throws ExecutionException {
        return this.createProcess(directory, null);
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory, @Nullable String commandHistoryFilePath) throws ExecutionException {
        Map<String, String> envs = this.getTerminalEnvironment();
        Object[] command = this.getCommand(envs);
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                command = customizer.customizeCommandAndEnvironment(this.myProject, (String[])command, envs);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        if (commandHistoryFilePath != null) {
            envs.put(IJ_COMMAND_HISTORY_FILE_ENV, commandHistoryFilePath);
        }
        String workingDir = this.getWorkingDirectory(directory);
        TerminalUsageTriggerCollector.triggerLocalShellStarted(this.myProject, (String[])command);
        try {
            long startNano = System.nanoTime();
            PtyProcess process = PtyProcess.exec((String[])command, envs, (String)workingDir);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started " + process.getClass().getName() + " from " + Arrays.toString(command) + " in " + workingDir + " (" + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
            }
            return process;
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to start " + Arrays.toString(command) + " in " + workingDir, e);
        }
    }

    @Nullable
    private String getWorkingDirectory(@Nullable String directory) {
        if (directory != null) {
            return directory;
        }
        return TerminalProjectOptionsProvider.getInstance(this.myProject).getStartingDirectory();
    }

    @Override
    protected ProcessHandler createProcessHandler(PtyProcess process) {
        return new PtyProcessHandler(process, LocalTerminalDirectRunner.getShellPath());
    }

    @Override
    protected TtyConnector createTtyConnector(PtyProcess process) {
        return new PtyProcessTtyConnector(process, this.myDefaultCharset){

            protected void resizeImmediately() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resizeImmediately to " + this.getPendingTermSize());
                }
                super.resizeImmediately();
            }
        };
    }

    @Override
    public String runningTargetName() {
        return "Local Terminal";
    }

    @Override
    protected String getTerminalConnectionName(PtyProcess process) {
        return "Local Terminal";
    }

    public String[] getCommand(Map<String, String> envs) {
        String shellPath = LocalTerminalDirectRunner.getShellPath();
        return LocalTerminalDirectRunner.getCommand(shellPath, envs, TerminalOptionsProvider.getInstance().shellIntegration());
    }

    private static String getShellPath() {
        return TerminalOptionsProvider.getInstance().getShellPath();
    }

    @NotNull
    public static String[] getCommand(String shellPath, Map<String, String> envs, boolean shellIntegration) {
        if (SystemInfo.isUnix) {
            ArrayList command = Lists.newArrayList((Object[])shellPath.split(" "));
            String shellCommand = command.size() > 0 ? (String)command.get(0) : null;
            String shellName = LocalTerminalDirectRunner.getShellName(shellCommand);
            if (shellName != null) {
                command.remove(0);
                if (!LocalTerminalDirectRunner.containsLoginOrInteractiveOption(command)) {
                    if (LocalTerminalDirectRunner.isLoginOptionAvailable(shellName) && SystemInfo.isMac) {
                        command.add(LOGIN_CLI_OPTION);
                    }
                    if (LocalTerminalDirectRunner.isInteractiveOptionAvailable(shellName)) {
                        command.add(INTERACTIVE_CLI_OPTION);
                    }
                }
                ArrayList result = Lists.newArrayList((Object[])new String[]{shellCommand});
                String rcFilePath = LocalTerminalDirectRunner.findRCFile(shellName);
                if (rcFilePath != null && shellIntegration) {
                    if (shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME)) {
                        LocalTerminalDirectRunner.addRcFileArgument(envs, command, result, rcFilePath, "--rcfile");
                        boolean loginShell = command.removeAll((Collection<?>)LOGIN_CLI_OPTIONS);
                        LocalTerminalDirectRunner.setLoginShellEnv(envs, loginShell);
                    } else if (shellName.equals(ZSH_NAME)) {
                        String zdotdir = (String)EnvironmentUtil.getEnvironmentMap().get(ZDOTDIR);
                        if (StringUtil.isNotEmpty((String)zdotdir)) {
                            envs.put("_OLD_ZDOTDIR", zdotdir);
                            File zshRc = new File(FileUtil.expandUserHome((String)zdotdir), ".zshrc");
                            if (zshRc.exists()) {
                                envs.put(JEDITERM_USER_RCFILE, zshRc.getAbsolutePath());
                            }
                        }
                        envs.put(ZDOTDIR, new File(rcFilePath).getParent());
                    } else if (shellName.equals(FISH_NAME)) {
                        String xdgConfig = (String)EnvironmentUtil.getEnvironmentMap().get(XDG_CONFIG_HOME);
                        if (StringUtil.isNotEmpty((String)xdgConfig)) {
                            File fishConfig = new File(new File(FileUtil.expandUserHome((String)xdgConfig), FISH_NAME), "config.fish");
                            if (fishConfig.exists()) {
                                envs.put(JEDITERM_USER_RCFILE, fishConfig.getAbsolutePath());
                            }
                            envs.put("OLD_XDG_CONFIG_HOME", xdgConfig);
                        }
                        envs.put(XDG_CONFIG_HOME, new File(rcFilePath).getParentFile().getParent());
                    }
                }
                LocalTerminalDirectRunner.setLoginShellEnv(envs, LocalTerminalDirectRunner.isLogin(command));
                result.addAll(command);
                String[] stringArray = ArrayUtilRt.toStringArray((Collection)result);
                if (stringArray == null) {
                    LocalTerminalDirectRunner.$$$reportNull$$$0(7);
                }
                return stringArray;
            }
            String[] stringArray = ArrayUtilRt.toStringArray((Collection)command);
            if (stringArray == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(8);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{shellPath};
        if (stringArray == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private static boolean isLoginOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(10);
        }
        return shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME) || shellName.equals(ZSH_NAME);
    }

    private static boolean isInteractiveOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(11);
        }
        return shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME) || shellName.equals(ZSH_NAME) || shellName.equals(FISH_NAME);
    }

    private static void setLoginShellEnv(@NotNull Map<String, String> envs, boolean loginShell) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(12);
        }
        if (loginShell) {
            envs.put(LOGIN_SHELL, "1");
        }
    }

    private static void addRcFileArgument(Map<String, String> envs, List<String> command, List<String> result, String rcFilePath, String rcfileOption) {
        result.add(rcfileOption);
        result.add(rcFilePath);
        int idx = command.indexOf(rcfileOption);
        if (idx >= 0) {
            command.remove(idx);
            if (idx < command.size()) {
                envs.put(JEDITERM_USER_RCFILE, FileUtil.expandUserHome((String)command.get(idx)));
                command.remove(idx);
            }
        }
    }

    private static boolean containsLoginOrInteractiveOption(List<String> command) {
        return LocalTerminalDirectRunner.isLogin(command) || command.contains(INTERACTIVE_CLI_OPTION);
    }

    private static boolean isLogin(@NotNull List<String> command) {
        if (command == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(13);
        }
        return command.stream().anyMatch(s -> LOGIN_CLI_OPTIONS.contains(s));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideHomeSubDirectory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAbsolutePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalRunner";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRCFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findAbsolutePath";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fixPathEnvOnWindows";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insideIdeHome";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLoginOptionAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveOptionAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setLoginShellEnv";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLogin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PtyProcessHandler
    extends ProcessHandler
    implements TaskExecutor {
        private final PtyProcess myProcess;
        private final ProcessWaitFor myWaitFor;

        PtyProcessHandler(PtyProcess process, @NotNull String presentableName) {
            if (presentableName == null) {
                PtyProcessHandler.$$$reportNull$$$0(0);
            }
            this.myProcess = process;
            this.myWaitFor = new ProcessWaitFor((Process)process, (TaskExecutor)this, presentableName);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        myWaitFor.setTerminationCallback(integer -> this.notifyProcessTerminated(integer));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler$1", "startNotified"));
                }
            });
            super.startNotify();
        }

        protected void destroyProcessImpl() {
            this.myProcess.destroy();
        }

        protected void detachProcessImpl() {
            this.destroyProcessImpl();
        }

        public boolean detachIsDefault() {
            return false;
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            if (task == null) {
                PtyProcessHandler.$$$reportNull$$$0(1);
            }
            Future<?> future = AppExecutorUtil.getAppExecutorService().submit(task);
            if (future == null) {
                PtyProcessHandler.$$$reportNull$$$0(2);
            }
            return future;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "executeTask";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

