/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class PListValue {
    private final Object myValue;
    private final PlistValueType myType;

    PListValue(Object value, PlistValueType type) {
        this.myValue = value;
        this.myType = type;
    }

    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    public PlistValueType getType() {
        return this.myType;
    }

    @NotNull
    public Plist getPlist() {
        Plist plist = this.myType == PlistValueType.DICT ? (Plist)this.myValue : Plist.EMPTY_PLIST;
        if (plist == null) {
            PListValue.$$$reportNull$$$0(0);
        }
        return plist;
    }

    @NotNull
    public List<PListValue> getArray() {
        List list = this.myType == PlistValueType.ARRAY ? (List)this.myValue : Collections.emptyList();
        if (list == null) {
            PListValue.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<String> getStringArray() {
        List<PListValue> array = this.getArray();
        ArrayList<String> result = new ArrayList<String>(array.size());
        for (PListValue value : array) {
            result.add(value.getString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PListValue.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public String getString() {
        return this.myType == PlistValueType.STRING ? (String)this.myValue : this.myValue.toString();
    }

    public static PListValue value(Object value, PlistValueType type) {
        if (value == null) {
            return new NullablePListValue(type);
        }
        return new PListValue(value, type);
    }

    public static PListValue string(String value) {
        return PListValue.value(value, PlistValueType.STRING);
    }

    public static PListValue bool(Boolean value) {
        return PListValue.value(value, PlistValueType.BOOLEAN);
    }

    public static PListValue integer(Long value) {
        return PListValue.value(value, PlistValueType.INTEGER);
    }

    public static PListValue real(Double value) {
        return PListValue.value(value, PlistValueType.REAL);
    }

    public static PListValue date(Date value) {
        return PListValue.value(value, PlistValueType.DATE);
    }

    public static PListValue array(List<PListValue> value) {
        return PListValue.value(value, PlistValueType.ARRAY);
    }

    public static PListValue array(PListValue ... value) {
        return PListValue.value(ContainerUtil.newArrayList((Object[])value), PlistValueType.ARRAY);
    }

    public static PListValue dict(Plist value) {
        return PListValue.value(value, PlistValueType.DICT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PListValue value = (PListValue)o;
        if (this.myType != value.myType) {
            return false;
        }
        return !(this.myValue != null ? !this.myValue.equals(value.myValue) : value.myValue != null);
    }

    public int hashCode() {
        int result = this.myValue != null ? this.myValue.hashCode() : 0;
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public String toString() {
        return "PListValue{myValue=" + this.myValue + ", myType=" + (Object)((Object)this.myType) + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/textmate/plist/PListValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlist";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringArray";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NullablePListValue
    extends PListValue {
        private NullablePListValue(PlistValueType type) {
            super(null, type);
        }

        @Override
        @NotNull
        public Plist getPlist() {
            Plist plist = Plist.EMPTY_PLIST;
            if (plist == null) {
                NullablePListValue.$$$reportNull$$$0(0);
            }
            return plist;
        }

        @Override
        @NotNull
        public List<PListValue> getArray() {
            List<PListValue> list = Collections.emptyList();
            if (list == null) {
                NullablePListValue.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getStringArray() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                NullablePListValue.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @Nullable
        public String getString() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/textmate/plist/PListValue$NullablePListValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlist";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringArray";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

