/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;

public final class TextMateDefaultColorsProvider {
    private final TextAttributesKey BOLD = TextAttributesKey.createTextAttributesKey((String)"markup.bold", (TextAttributes)new TextAttributes(null, null, null, null, 1));
    private final TextAttributesKey ITALIC = TextAttributesKey.createTextAttributesKey((String)"markup.italic", (TextAttributes)new TextAttributes(null, null, null, null, 2));
    private final TextAttributesKey UNDERLINE = TextAttributesKey.createTextAttributesKey((String)"markup.underline", (TextAttributes)new TextAttributes(null, null, null, EffectType.LINE_UNDERSCORE, 0));
    private final TextAttributesKey HEADING = TextAttributesKey.createTextAttributesKey((String)"markup.heading", (TextAttributes)new TextAttributes(null, null, null, EffectType.BOLD_LINE_UNDERSCORE, 0));
    private final Map<String, TextAttributesKey> DEFAULT_HIGHLIGHTING_RULES = ContainerUtil.newHashMap((Pair)Pair.create((Object)"markup.bold", (Object)this.BOLD), (Pair[])new Pair[]{Pair.create((Object)"markup.italic", (Object)this.ITALIC), Pair.create((Object)"markup.underline", (Object)this.UNDERLINE), Pair.create((Object)"markup.heading", (Object)this.HEADING), Pair.create((Object)"markup.changed", (Object)DiffColors.DIFF_MODIFIED), Pair.create((Object)"markup.inserted", (Object)DiffColors.DIFF_INSERTED), Pair.create((Object)"markup.deleted", (Object)DiffColors.DIFF_DELETED), Pair.create((Object)"comment", (Object)DefaultLanguageHighlighterColors.LINE_COMMENT), Pair.create((Object)"comment.line", (Object)DefaultLanguageHighlighterColors.LINE_COMMENT), Pair.create((Object)"comment.block", (Object)DefaultLanguageHighlighterColors.BLOCK_COMMENT), Pair.create((Object)"comment.documentation", (Object)DefaultLanguageHighlighterColors.DOC_COMMENT), Pair.create((Object)"constant", (Object)DefaultLanguageHighlighterColors.CONSTANT), Pair.create((Object)"constant.number", (Object)DefaultLanguageHighlighterColors.NUMBER), Pair.create((Object)"constant.numeric", (Object)DefaultLanguageHighlighterColors.NUMBER), Pair.create((Object)"constant.character.escape", (Object)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE), Pair.create((Object)"constant.character.entity", (Object)DefaultLanguageHighlighterColors.MARKUP_ENTITY), Pair.create((Object)"invalid", (Object)HighlighterColors.BAD_CHARACTER), Pair.create((Object)"invalid.deprecated", (Object)CodeInsightColors.DEPRECATED_ATTRIBUTES), Pair.create((Object)"keyword", (Object)DefaultLanguageHighlighterColors.KEYWORD), Pair.create((Object)"keyword.operator", (Object)DefaultLanguageHighlighterColors.OPERATION_SIGN), Pair.create((Object)"storage", (Object)DefaultLanguageHighlighterColors.KEYWORD), Pair.create((Object)"storage.type", (Object)DefaultLanguageHighlighterColors.KEYWORD), Pair.create((Object)"string", (Object)DefaultLanguageHighlighterColors.STRING), Pair.create((Object)"variable", (Object)DefaultLanguageHighlighterColors.LOCAL_VARIABLE), Pair.create((Object)"variable.parameter", (Object)DefaultLanguageHighlighterColors.PARAMETER), Pair.create((Object)"entity", (Object)DefaultLanguageHighlighterColors.IDENTIFIER), Pair.create((Object)"entity.name", (Object)DefaultLanguageHighlighterColors.CLASS_NAME), Pair.create((Object)"entity.name.class", (Object)DefaultLanguageHighlighterColors.CLASS_NAME), Pair.create((Object)"entity.name.function", (Object)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION), Pair.create((Object)"entity.other.attribute-name", (Object)DefaultLanguageHighlighterColors.MARKUP_ATTRIBUTE), Pair.create((Object)"punctuation", (Object)DefaultLanguageHighlighterColors.DOT), Pair.create((Object)"punctuation.definition.tag", (Object)DefaultLanguageHighlighterColors.MARKUP_TAG), Pair.create((Object)"support.function", (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL), Pair.create((Object)"support.type", (Object)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL), Pair.create((Object)"meta.tag", (Object)DefaultLanguageHighlighterColors.METADATA), Pair.create((Object)"text source", (Object)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR)});

    public Set<String> getAllDefaultKeys() {
        return this.DEFAULT_HIGHLIGHTING_RULES.keySet();
    }

    public TextAttributes getTextAttributes(String selector) {
        return this.getTextAttributesKey(selector).getDefaultAttributes();
    }

    public TextAttributesKey getTextAttributesKey(String selector) {
        return this.DEFAULT_HIGHLIGHTING_RULES.getOrDefault(selector, HighlighterColors.TEXT);
    }
}

