/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BytecodeTransformer;
import com.intellij.ide.ClassUtilCore;
import com.intellij.idea.Main;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BootstrapClassLoaderUtil
extends ClassUtilCore {
    private static final String PROPERTY_IGNORE_CLASSPATH = "ignore.classpath";
    private static final String PROPERTY_ALLOW_BOOTSTRAP_RESOURCES = "idea.allow.bootstrap.resources";
    private static final String PROPERTY_ADDITIONAL_CLASSPATH = "idea.additional.classpath";
    public static final String CLASSPATH_ORDER_FILE = "classpath-order.txt";
    private static final String MARKETPLACE_PLUGIN_NAME = "marketplace";

    private BootstrapClassLoaderUtil() {
    }

    private static Logger getLogger() {
        return Logger.getInstance(BootstrapClassLoaderUtil.class);
    }

    @NotNull
    public static ClassLoader initClassLoader() throws MalformedURLException {
        UrlClassLoader.Builder builder;
        block7: {
            File marketplaceImpl;
            Collection<String> jarOrder = BootstrapClassLoaderUtil.loadJarOrder();
            LinkedHashSet<URL> classpath = new LinkedHashSet<URL>();
            BootstrapClassLoaderUtil.addParentClasspath(classpath, false);
            BootstrapClassLoaderUtil.addIDEALibraries(classpath, jarOrder);
            BootstrapClassLoaderUtil.addAdditionalClassPath(classpath);
            BootstrapClassLoaderUtil.addParentClasspath(classpath, true);
            File mpBoot = new File(PathManager.getPluginsPath(), "marketplace/lib/boot/marketplace-bootstrap.jar");
            boolean installMarketplace = mpBoot.exists();
            if (installMarketplace && (marketplaceImpl = new File(PathManager.getPluginsPath(), "marketplace/lib/boot/marketplace-impl.jar")).exists()) {
                classpath.add(marketplaceImpl.toURI().toURL());
            }
            builder = UrlClassLoader.build().urls(BootstrapClassLoaderUtil.filterClassPath(new ArrayList<URL>(classpath))).allowLock().usePersistentClasspathIndexForLocalClassDirectories().logJarAccess(jarOrder.isEmpty()).autoAssignUrlsWithProtectionDomain().useCache();
            if (Boolean.valueOf(System.getProperty(PROPERTY_ALLOW_BOOTSTRAP_RESOURCES, "true")).booleanValue()) {
                builder.allowBootstrapResources();
            }
            ClassLoaderUtil.addPlatformLoaderParentIfOnJdk9((UrlClassLoader.Builder)builder);
            if (installMarketplace) {
                TransformingLoader transformingLoader;
                block8: {
                    try {
                        SmartList transformers = new SmartList();
                        UrlClassLoader mpBootloader = UrlClassLoader.build().urls(new URL[]{mpBoot.toURI().toURL()}).parent(BootstrapClassLoaderUtil.class.getClassLoader()).get();
                        for (BytecodeTransformer transformer : ServiceLoader.load(BytecodeTransformer.class, (ClassLoader)mpBootloader)) {
                            transformers.add(transformer);
                        }
                        if (transformers.isEmpty()) break block7;
                        transformingLoader = new TransformingLoader(builder, (List<BytecodeTransformer>)transformers);
                        if (transformingLoader != null) break block8;
                    }
                    catch (Throwable e) {
                        String message = "As a workaround you may uninstall or update JetBrains Marketplace Support plugin at " + new File(PathManager.getPluginsPath(), MARKETPLACE_PLUGIN_NAME).getAbsolutePath();
                        Main.showMessage("JetBrains Marketplace boot failure", new Exception(message, e));
                    }
                    BootstrapClassLoaderUtil.$$$reportNull$$$0(0);
                }
                return transformingLoader;
            }
        }
        UrlClassLoader urlClassLoader = builder.get();
        if (urlClassLoader == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(1);
        }
        return urlClassLoader;
    }

    private static String getSystemPath() {
        String systemPath = System.getProperty("idea.system.path");
        if (systemPath != null) {
            if (systemPath.length() >= 3 && systemPath.startsWith("\"") && systemPath.endsWith("\"")) {
                systemPath = systemPath.substring(1, systemPath.length() - 1);
            }
            if (systemPath.startsWith("~/") || systemPath.startsWith("~\\")) {
                systemPath = System.getProperty("user.home") + systemPath.substring(1);
            }
        } else {
            String pathSelector = System.getProperty("idea.paths.selector");
            if (pathSelector != null) {
                systemPath = PathManager.getDefaultSystemPathFor((String)pathSelector);
            }
        }
        return systemPath;
    }

    private static void addParentClasspath(Collection<? super URL> classpath, boolean ext) throws MalformedURLException {
        if (!SystemInfo.IS_AT_LEAST_JAVA9) {
            String[] extDirs = System.getProperty("java.ext.dirs", "").split(File.pathSeparator);
            if (ext && extDirs.length == 0) {
                return;
            }
            ArrayList<URLClassLoader> loaders = new ArrayList<URLClassLoader>(2);
            for (ClassLoader loader = BootstrapClassLoaderUtil.class.getClassLoader(); loader != null; loader = loader.getParent()) {
                if (loader instanceof URLClassLoader) {
                    loaders.add(0, (URLClassLoader)loader);
                    continue;
                }
                BootstrapClassLoaderUtil.getLogger().warn("Unknown class loader: " + loader.getClass().getName());
            }
            String libPath = PathManager.getLibPath();
            for (URLClassLoader loader : loaders) {
                URL[] urls;
                for (URL url : urls = loader.getURLs()) {
                    String path = BootstrapClassLoaderUtil.urlToPath(url);
                    if (path.startsWith(libPath)) continue;
                    boolean isExt = false;
                    for (String extDir : extDirs) {
                        if (!path.startsWith(extDir) || path.length() <= extDir.length() || path.charAt(extDir.length()) != File.separatorChar) continue;
                        isExt = true;
                        break;
                    }
                    if (isExt != ext) continue;
                    classpath.add(url);
                }
            }
        } else if (!ext) {
            BootstrapClassLoaderUtil.parseClassPathString(ManagementFactory.getRuntimeMXBean().getClassPath(), classpath);
        }
    }

    private static String urlToPath(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI().getSchemeSpecificPart()).getPath();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(url.toString());
        }
    }

    private static void addIDEALibraries(Collection<? super URL> classpath, Collection<String> jarOrder) throws MalformedURLException {
        Class<BootstrapClassLoaderUtil> aClass = BootstrapClassLoaderUtil.class;
        String selfRoot = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        assert (selfRoot != null);
        URL selfRootUrl = new File(selfRoot).getAbsoluteFile().toURI().toURL();
        classpath.add(selfRootUrl);
        File libFolder = new File(PathManager.getLibPath());
        for (String jarName : jarOrder) {
            File jarFile = new File(libFolder, jarName);
            if (!jarFile.exists()) continue;
            classpath.add(jarFile.toURI().toURL());
        }
        BootstrapClassLoaderUtil.addLibraries(classpath, libFolder, selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ext"), selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ant/lib"), selfRootUrl);
    }

    private static Collection<String> loadJarOrder() {
        try {
            Path path = Paths.get(BootstrapClassLoaderUtil.getSystemPath(), CLASSPATH_ORDER_FILE);
            if (path.toFile().exists()) {
                return new LinkedHashSet<String>(Files.readAllLines(path));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static void addLibraries(Collection<? super URL> classPath, File fromDir, URL selfRootUrl) throws MalformedURLException {
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            URL url;
            if (!FileUtilRt.isJarOrZip((File)file) || selfRootUrl.equals(url = file.toURI().toURL())) continue;
            classPath.add(url);
        }
    }

    private static void addAdditionalClassPath(Collection<? super URL> classpath) {
        BootstrapClassLoaderUtil.parseClassPathString(System.getProperty(PROPERTY_ADDITIONAL_CLASSPATH), classpath);
    }

    private static void parseClassPathString(String pathString, Collection<? super URL> classpath) {
        if (pathString != null && !pathString.isEmpty()) {
            try {
                String libPath = PathManager.getLibPath();
                StringTokenizer tokenizer = new StringTokenizer(pathString, File.pathSeparator + ',', false);
                while (tokenizer.hasMoreTokens()) {
                    String pathItem = tokenizer.nextToken();
                    if (pathItem.startsWith(libPath)) continue;
                    classpath.add(new File(pathItem).toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                BootstrapClassLoaderUtil.getLogger().error((Throwable)e);
            }
        }
    }

    private static List<URL> filterClassPath(List<URL> classpath) {
        String ignoreProperty = System.getProperty(PROPERTY_IGNORE_CLASSPATH);
        if (ignoreProperty != null) {
            Pattern pattern = Pattern.compile(ignoreProperty);
            Iterator<URL> i = classpath.iterator();
            while (i.hasNext()) {
                String url = i.next().toExternalForm();
                if (!pattern.matcher(url).matches()) continue;
                i.remove();
            }
        }
        return classpath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BootstrapClassLoaderUtil", "initClassLoader"));
    }

    private static class TransformingLoader
    extends UrlClassLoader {
        private final List<BytecodeTransformer> myTransformers;

        TransformingLoader(@NotNull UrlClassLoader.Builder builder, List<BytecodeTransformer> transformers) {
            if (builder == null) {
                TransformingLoader.$$$reportNull$$$0(0);
            }
            super(builder);
            this.myTransformers = Collections.unmodifiableList(transformers);
        }

        protected Class _defineClass(String name, byte[] b) {
            return super._defineClass(name, this.doTransform(name, null, b));
        }

        protected Class _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
            return super._defineClass(name, this.doTransform(name, protectionDomain, b), protectionDomain);
        }

        private byte[] doTransform(String name, ProtectionDomain protectionDomain, byte[] bytes) {
            byte[] b = bytes;
            for (BytecodeTransformer transformer : this.myTransformers) {
                byte[] result = transformer.transform((ClassLoader)((Object)this), name, protectionDomain, b);
                if (result == null) continue;
                b = result;
            }
            return b;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/ide/BootstrapClassLoaderUtil$TransformingLoader", "<init>"));
        }
    }
}

