/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesFileStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileStructureViewModel
extends TextEditorBasedStructureViewModel
implements PropertiesGroupingStructureViewModel {
    private final GroupByWordPrefixes myByWordPrefixesGrouper;
    private volatile boolean myGroupingState = true;
    @NonNls
    public static final String KIND_SORTER_ID = "KIND_SORTER";
    private static final Sorter KIND_SORTER = new Sorter(){

        @NotNull
        public Comparator getComparator() {
            Comparator comparator = (o1, o2) -> {
                int weight1 = o1 instanceof PropertiesPrefixGroup ? 1 : 0;
                int weight2 = o2 instanceof PropertiesPrefixGroup ? 1 : 0;
                return weight1 - weight2;
            };
            if (comparator == null) {
                1.$$$reportNull$$$0(0);
            }
            return comparator;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            String name = IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]);
            ActionPresentationData actionPresentationData = new ActionPresentationData(name, name, AllIcons.ObjectBrowser.SortByType);
            if (actionPresentationData == null) {
                1.$$$reportNull$$$0(1);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (PropertiesFileStructureViewModel.KIND_SORTER_ID == null) {
                1.$$$reportNull$$$0(2);
            }
            return PropertiesFileStructureViewModel.KIND_SORTER_ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    public PropertiesFileStructureViewModel(PropertiesFileImpl file, Editor editor) {
        super(editor, (PsiFile)file);
        String separator = PropertiesSeparatorManager.getInstance(file.getProject()).getSeparator(file.getResourceBundle());
        this.myByWordPrefixesGrouper = new GroupByWordPrefixes(separator);
    }

    @Override
    public void setSeparator(String separator) {
        this.myByWordPrefixesGrouper.setSeparator(separator);
        PropertiesSeparatorManager separatorManager = PropertiesSeparatorManager.getInstance(this.getPsiFile().getProject());
        separatorManager.setSeparator(((PropertiesFileImpl)this.getPsiFile()).getResourceBundle(), separator);
    }

    @Override
    public String getSeparator() {
        return this.myByWordPrefixesGrouper.getSeparator();
    }

    @Override
    public void setGroupingActive(boolean state) {
        this.myGroupingState = state;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        PropertiesFileStructureViewElement propertiesFileStructureViewElement = new PropertiesFileStructureViewElement((PropertiesFileImpl)this.getPsiFile(), () -> this.myGroupingState);
        if (propertiesFileStructureViewElement == null) {
            PropertiesFileStructureViewModel.$$$reportNull$$$0(0);
        }
        return propertiesFileStructureViewElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = new Grouper[]{this.myByWordPrefixesGrouper};
        if (grouperArray == null) {
            PropertiesFileStructureViewModel.$$$reportNull$$$0(1);
        }
        return grouperArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER, KIND_SORTER};
        if (sorterArray == null) {
            PropertiesFileStructureViewModel.$$$reportNull$$$0(2);
        }
        return sorterArray;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        Class[] classArray = new Class[]{Property.class};
        if (classArray == null) {
            PropertiesFileStructureViewModel.$$$reportNull$$$0(3);
        }
        return classArray;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

