/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.logger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.CompletionEventLogger;
import com.intellij.stats.completion.LogEventSerializer;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.logger.FileLogger;
import com.intellij.stats.logger.SessionValidator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/stats/logger/EventLoggerWithValidation;", "Lcom/intellij/stats/completion/CompletionEventLogger;", "Lcom/intellij/openapi/Disposable;", "fileLogger", "Lcom/intellij/stats/logger/FileLogger;", "validator", "Lcom/intellij/stats/logger/SessionValidator;", "(Lcom/intellij/stats/logger/FileLogger;Lcom/intellij/stats/logger/SessionValidator;)V", "session", "", "Lcom/intellij/stats/completion/events/LogEvent;", "dispose", "", "log", "event", "validateAndLog", "", "validateAndLogInBackground", "flush", "", "intellij.statsCollector"})
public final class EventLoggerWithValidation
implements CompletionEventLogger,
Disposable {
    private final List<LogEvent> session;
    private final FileLogger fileLogger;
    private final SessionValidator validator;

    @Override
    public void log(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.session.isEmpty() || Intrinsics.areEqual((Object)event.getSessionUid(), (Object)((LogEvent)CollectionsKt.first(this.session)).getSessionUid())) {
            this.session.add(event);
        } else {
            this.validateAndLogInBackground(false);
            this.session.add(event);
        }
    }

    public void dispose() {
        this.validateAndLogInBackground(true);
    }

    private final void validateAndLogInBackground(boolean flush) {
        List lastSession = CollectionsKt.toList((Iterable)this.session);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, lastSession, flush){
            final /* synthetic */ EventLoggerWithValidation this$0;
            final /* synthetic */ List $lastSession;
            final /* synthetic */ boolean $flush;

            public final void run() {
                EventLoggerWithValidation.access$validateAndLog(this.this$0, this.$lastSession);
                if (this.$flush) {
                    EventLoggerWithValidation.access$getFileLogger$p(this.this$0).flush();
                }
            }
            {
                this.this$0 = eventLoggerWithValidation;
                this.$lastSession = list;
                this.$flush = bl;
            }
        });
        this.session.clear();
    }

    private final void validateAndLog(List<? extends LogEvent> session) {
        this.validator.validate(session);
        for (LogEvent logEvent : session) {
            this.fileLogger.println(LogEventSerializer.INSTANCE.toString(logEvent));
        }
    }

    public EventLoggerWithValidation(@NotNull FileLogger fileLogger, @NotNull SessionValidator validator) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)fileLogger, (String)"fileLogger");
        Intrinsics.checkParameterIsNotNull((Object)validator, (String)"validator");
        this.fileLogger = fileLogger;
        this.validator = validator;
        EventLoggerWithValidation eventLoggerWithValidation = this;
        boolean bl = false;
        eventLoggerWithValidation.session = list = (List)new ArrayList();
    }

    public static final /* synthetic */ void access$validateAndLog(EventLoggerWithValidation $this, List session) {
        $this.validateAndLog(session);
    }

    public static final /* synthetic */ FileLogger access$getFileLogger$p(EventLoggerWithValidation $this) {
        return $this.fileLogger;
    }
}

