/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NameUtilCore {
    @NotNull
    public static String[] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            NameUtilCore.$$$reportNull$$$0(0);
        }
        String[] underlineDelimited = name.split("_");
        ArrayList<String> result = new ArrayList<String>();
        for (String word : underlineDelimited) {
            NameUtilCore.addAllWords(word, result);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            NameUtilCore.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private static void addAllWords(@NotNull String text, @NotNull List<? super String> result) {
        if (text == null) {
            NameUtilCore.$$$reportNull$$$0(2);
        }
        if (result == null) {
            NameUtilCore.$$$reportNull$$$0(3);
        }
        int start = 0;
        while (start < text.length()) {
            int next = NameUtilCore.nextWord(text, start);
            result.add(text.substring(start, next));
            start = next;
        }
    }

    public static int nextWord(@NotNull String text, int start) {
        int i;
        if (text == null) {
            NameUtilCore.$$$reportNull$$$0(4);
        }
        if (!Character.isLetterOrDigit(text.charAt(start))) {
            return start + 1;
        }
        for (i = start; i < text.length() && Character.isDigit(text.charAt(i)); ++i) {
        }
        if (i > start) {
            return i;
        }
        while (i < text.length() && Character.isUpperCase(text.charAt(i))) {
            ++i;
        }
        if (i > start + 1) {
            if (i == text.length() || !Character.isLetter(text.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        if (i == start) {
            ++i;
        }
        while (i < text.length() && Character.isLetter(text.charAt(i)) && !NameUtilCore.isWordStart(text, i)) {
            ++i;
        }
        return i;
    }

    public static boolean isWordStart(String text, int i) {
        char c = text.charAt(i);
        if (Character.isUpperCase(c)) {
            if (i > 0 && Character.isUpperCase(text.charAt(i - 1))) {
                return i + 1 < text.length() && Character.isLowerCase(text.charAt(i + 1));
            }
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (!Character.isLetter(c)) {
            return false;
        }
        return i == 0 || !Character.isLetterOrDigit(text.charAt(i - 1)) || NameUtilCore.isHardCodedWordStart(text, i);
    }

    private static boolean isHardCodedWordStart(String text, int i) {
        return text.charAt(i) == 'l' && i < text.length() - 1 && text.charAt(i + 1) == 'n' && (text.length() == i + 2 || NameUtilCore.isWordStart(text, i + 2));
    }

    @NotNull
    public static String[] nameToWords(@NotNull String name) {
        if (name == null) {
            NameUtilCore.$$$reportNull$$$0(5);
        }
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            String word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (StringUtil.isEmptyOrSpaces(word = name.substring(wordStart, index))) continue;
            array.add(word);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(array);
        if (stringArray == null) {
            NameUtilCore.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/NameUtilCore";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/NameUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameIntoWords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitNameIntoWords";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAllWords";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nameToWords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

