/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Function;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClassLoadingLocks;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader {
    static final String CLASS_EXTENSION = ".class";
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private static final boolean ourClassPathIndexEnabled;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final ClassLoadingLocks myClassLoadingLocks;
    private final boolean myAllowBootstrapResources;
    private static final ThreadLocal<Boolean> ourSkipFindingResource;

    protected static void markParallelCapable(Class<? extends UrlClassLoader> loaderClass) {
        assert (ourParallelCapableLoaders != null);
        ourParallelCapableLoaders.add(loaderClass);
    }

    static boolean isUrlNeedsProtectionDomain(URL url) {
        String basename = PathUtilRt.getFileName(url.getPath());
        return basename.endsWith(".jar") && (basename.startsWith("bcprov-") || basename.startsWith("bcpkix-"));
    }

    void appendToClassPathForInstrumentation(String jar) {
        try {
            this.addURL(new File(jar).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @NotNull
    protected ClassPath getClassPath() {
        ClassPath classPath = this.myClassPath;
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        return classPath;
    }

    public List<URL> getBaseUrls() {
        return this.myClassPath.getBaseUrls();
    }

    public Collection<String> getJarAccessLog() {
        return this.myClassPath.getJarAccessLog();
    }

    @NotNull
    public static Builder build() {
        Builder builder = new Builder();
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        return builder;
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            UrlClassLoader.$$$reportNull$$$0(2);
        }
        this(UrlClassLoader.build().urls(((URLClassLoader)parent).getURLs()).parent(parent.getParent()).allowLock().useCache().usePersistentClasspathIndexForLocalClassDirectories().useLazyClassloadingCaches(Boolean.parseBoolean(System.getProperty("idea.lazy.classloading.caches", "false"))).autoAssignUrlsWithProtectionDomain());
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        super(builder.myParent);
        this.myURLs = ContainerUtilRt.map2List(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassLoadingLocks = ourParallelCapableLoaders != null && ourParallelCapableLoaders.contains(this.getClass()) ? new ClassLoadingLocks() : null;
    }

    @NotNull
    protected final ClassPath createClassPath(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        ClassPath classPath = new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition, builder.myErrorOnMissingJar, builder.myLazyClassloadingCaches, builder.myURLsWithProtectionDomain, builder.myLogJarAccess);
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        return classPath;
    }

    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    @Deprecated
    public void addURL(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(7);
        }
        this.getClassPath().addURL(UrlClassLoader.internProtocol(url));
        this.myURLs.add(url);
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this.myURLs);
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass = this.findLoadedClass(name);
        return aClass != null && aClass.getClassLoader() == this;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this._findClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Nullable
    protected final Class _findClass(@NotNull String name) {
        Resource res;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        if ((res = this.getClassPath().getResource(name.replace('.', '/') + CLASS_EXTENSION)) == null) {
            return null;
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res.getValue(Resource.Attribute.SPEC_TITLE), res.getValue(Resource.Attribute.SPEC_VERSION), res.getValue(Resource.Attribute.SPEC_VENDOR), res.getValue(Resource.Attribute.IMPL_TITLE), res.getValue(Resource.Attribute.IMPL_VERSION), res.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        ProtectionDomain protectionDomain = res.getProtectionDomain();
        if (protectionDomain != null) {
            return this._defineClass(name, b, protectionDomain);
        }
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    protected Class _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @Override
    public URL findResource(String name) {
        if (ourSkipFindingResource.get() != null) {
            return null;
        }
        Resource res = this.findResourceImpl(name);
        return res != null ? res.getURL() : null;
    }

    @Nullable
    private Resource findResourceImpl(String name) {
        String n = FileUtilRt.toCanonicalPath(name, '/', false);
        Resource resource = this.getClassPath().getResource(n);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            ourSkipFindingResource.set(Boolean.TRUE);
            try {
                InputStream stream = super.getResourceAsStream(name);
                if (stream != null) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
            }
            finally {
                ourSkipFindingResource.set(null);
            }
        }
        try {
            Resource res = this.findResourceImpl(name);
            return res != null ? res.getInputStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getClassPath().getResources(name);
    }

    @Override
    @NotNull
    protected Object getClassLoadingLock(String className) {
        Object object = this.myClassLoadingLocks != null ? this.myClassLoadingLocks.getOrCreateLock(className) : this;
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    public static CachePool createCachePool() {
        CachePoolImpl cachePoolImpl = new CachePoolImpl();
        if (cachePoolImpl == null) {
            UrlClassLoader.$$$reportNull$$$0(10);
        }
        return cachePoolImpl;
    }

    static {
        boolean capable;
        boolean isAtLeastJava7 = !System.getProperty("java.runtime.version", "unknown").startsWith("1.6.");
        boolean ibmJvm = System.getProperty("java.vm.vendor", "unknown").toLowerCase(Locale.ENGLISH).contains("ibm");
        boolean bl = capable = isAtLeastJava7 && !ibmJvm && Boolean.parseBoolean(System.getProperty("use.parallel.class.loading", "true"));
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
        ourSkipFindingResource = new ThreadLocal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachePool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createClassPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "_findClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }

    public static interface CachePool {
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtilRt.emptyList();
        private Set<URL> myURLsWithProtectionDomain = new HashSet<URL>();
        private ClassLoader myParent;
        private boolean myLockJars;
        private boolean myUseCache;
        private boolean myUsePersistentClasspathIndex;
        private boolean myAcceptUnescaped;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources;
        private boolean myErrorOnMissingJar = true;
        private boolean myLazyClassloadingCaches;
        private boolean myLogJarAccess;
        @Nullable
        private CachePoolImpl myCachePool;
        @Nullable
        private CachingCondition myCachingCondition;

        Builder() {
        }

        public Builder urls(@NotNull List<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myURLs = urls;
            return this;
        }

        public Builder urls(URL ... urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myURLs = Arrays.asList(urls);
            return this;
        }

        public Builder parent(ClassLoader parent) {
            this.myParent = parent;
            return this;
        }

        public Builder urlsWithProtectionDomain(@NotNull Set<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myURLsWithProtectionDomain = urls;
            return this;
        }

        public Builder urlsWithProtectionDomain(URL ... urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return this.urlsWithProtectionDomain(ContainerUtilRt.newHashSet(urls));
        }

        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        public Builder allowLock(boolean lockJars) {
            this.myLockJars = lockJars;
            return this;
        }

        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }

        public Builder useCache(boolean useCache) {
            this.myUseCache = useCache;
            return this;
        }

        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.myUsePersistentClasspathIndex = ourClassPathIndexEnabled;
            return this;
        }

        public Builder logJarAccess(boolean logJarAccess) {
            this.myLogJarAccess = logJarAccess;
            return this;
        }

        public Builder useCache(@NotNull CachePool pool, @NotNull CachingCondition condition) {
            if (pool == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (condition == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myUseCache = true;
            this.myCachePool = (CachePoolImpl)pool;
            this.myCachingCondition = condition;
            return this;
        }

        public Builder allowUnescaped() {
            this.myAcceptUnescaped = true;
            return this;
        }

        public Builder noPreload() {
            this.myPreload = false;
            return this;
        }

        public Builder allowBootstrapResources() {
            this.myAllowBootstrapResources = true;
            return this;
        }

        public Builder setLogErrorOnMissingJar(boolean log) {
            this.myErrorOnMissingJar = log;
            return this;
        }

        public Builder useLazyClassloadingCaches(boolean pleaseBeLazy) {
            this.myLazyClassloadingCaches = pleaseBeLazy;
            return this;
        }

        public Builder autoAssignUrlsWithProtectionDomain() {
            HashSet<URL> result = new HashSet<URL>();
            for (URL url : this.myURLs) {
                if (!UrlClassLoader.isUrlNeedsProtectionDomain(url)) continue;
                result.add(url);
            }
            return this.urlsWithProtectionDomain(result);
        }

        @NotNull
        public UrlClassLoader get() {
            UrlClassLoader urlClassLoader = new UrlClassLoader(this);
            if (urlClassLoader == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return urlClassLoader;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pool";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "urls";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "urlsWithProtectionDomain";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "useCache";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

