/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class ClassLoadingLocks {
    private final ConcurrentMap<String, WeakLockReference> myMap = new ConcurrentHashMap<String, WeakLockReference>();
    private final ReferenceQueue<Object> myQueue = new ReferenceQueue();

    ClassLoadingLocks() {
    }

    @NotNull
    Object getOrCreateLock(String className) {
        WeakLockReference oldRef;
        Object lock;
        WeakLockReference lockReference = (WeakLockReference)this.myMap.get(className);
        if (lockReference != null && (lock = lockReference.get()) != null) {
            Object t = lock;
            if (t == null) {
                ClassLoadingLocks.$$$reportNull$$$0(0);
            }
            return t;
        }
        Object newLock = new Object();
        WeakLockReference newRef = new WeakLockReference(className, newLock, this.myQueue);
        do {
            this.processQueue();
            oldRef = this.myMap.putIfAbsent(className, newRef);
            if (oldRef == null) {
                Object object = newLock;
                if (object == null) {
                    ClassLoadingLocks.$$$reportNull$$$0(1);
                }
                return object;
            }
            Object oldLock = oldRef.get();
            if (oldLock == null) continue;
            Object t = oldLock;
            if (t == null) {
                ClassLoadingLocks.$$$reportNull$$$0(2);
            }
            return t;
        } while (!this.myMap.replace(className, oldRef, newRef));
        Object object = newLock;
        if (object == null) {
            ClassLoadingLocks.$$$reportNull$$$0(3);
        }
        return object;
    }

    private void processQueue() {
        WeakLockReference ref;
        while ((ref = (WeakLockReference)this.myQueue.poll()) != null) {
            this.myMap.remove(ref.myClassName, ref);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/ClassLoadingLocks", "getOrCreateLock"));
    }

    private static class WeakLockReference
    extends WeakReference<Object> {
        final String myClassName;

        private WeakLockReference(@NotNull String className, Object lock, ReferenceQueue<Object> q) {
            if (className == null) {
                WeakLockReference.$$$reportNull$$$0(0);
            }
            super(lock, q);
            this.myClassName = className;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/util/lang/ClassLoadingLocks$WeakLockReference", "<init>"));
        }
    }
}

