/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class CompactDataInput
implements DataInput {
    private final InputStream in;
    private final byte[] readBuffer = IOUtil.allocReadWriteUTFBuffer();

    public CompactDataInput(InputStream in) {
        this.in = in;
    }

    @Override
    public void readFully(@NotNull byte[] b) throws IOException {
        if (b == null) {
            CompactDataInput.$$$reportNull$$$0(0);
        }
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
        int count;
        if (b == null) {
            CompactDataInput.$$$reportNull$$$0(1);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.in.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readInt() throws IOException {
        return DataInputOutputUtil.readINT(this);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not implemented!");
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        String string = IOUtil.readUTFFast(this.readBuffer, this);
        if (string == null) {
            CompactDataInput.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/CompactDataInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/CompactDataInput";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readUTF";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFully";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

