/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.EmptyListIterator;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtilRt {
    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(1);
        }
        HashMap<? extends K, ? extends V> hashMap = new HashMap<K, V>(map);
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    @Contract(value="_,_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys, @NotNull List<? extends V> values) {
        if (keys == null) {
            ContainerUtilRt.$$$reportNull$$$0(3);
        }
        if (values == null) {
            ContainerUtilRt.$$$reportNull$$$0(4);
        }
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " should have same length as " + values);
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    @Contract(value="_,_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtilRt.$$$reportNull$$$0(6);
        }
        if (entries == null) {
            ContainerUtilRt.$$$reportNull$$$0(7);
        }
        HashMap<K, V> map = new HashMap<K, V>(entries.length + 1);
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        HashMap hashMap = new HashMap(initialCapacity);
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = new TreeMap();
        if (treeMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(10);
        }
        return treeMap;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(11);
        }
        TreeMap<? extends K, ? extends V> treeMap = new TreeMap<K, V>(map);
        if (treeMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(12);
        }
        return treeMap;
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(13);
        }
        return linkedHashMap;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        LinkedHashMap linkedHashMap = new LinkedHashMap(capacity);
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(15);
        }
        LinkedHashMap<? extends K, ? extends V> linkedHashMap = new LinkedHashMap<K, V>(map);
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(16);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(value="_,_ -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtilRt.$$$reportNull$$$0(17);
        }
        if (entries == null) {
            ContainerUtilRt.$$$reportNull$$$0(18);
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        LinkedHashMap<K, V> linkedHashMap = map;
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(19);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = new LinkedList();
        if (linkedList == null) {
            ContainerUtilRt.$$$reportNull$$$0(20);
        }
        return linkedList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(21);
        }
        LinkedList linkedList = ContainerUtilRt.copy(new LinkedList(), elements);
        if (linkedList == null) {
            ContainerUtilRt.$$$reportNull$$$0(22);
        }
        return linkedList;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(24);
        }
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        ArrayList arrayList = list;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(26);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            ArrayList arrayList = new ArrayList(collection);
            if (arrayList == null) {
                ContainerUtilRt.$$$reportNull$$$0(27);
            }
            return arrayList;
        }
        ArrayList arrayList = ContainerUtilRt.copy(new ArrayList(), elements);
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    protected static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(29);
        }
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(30);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtilRt.$$$reportNull$$$0(31);
        }
        return c;
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = new HashSet(initialCapacity);
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(34);
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(elements));
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(36);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            HashSet hashSet = new HashSet(collection);
            if (hashSet == null) {
                ContainerUtilRt.$$$reportNull$$$0(37);
            }
            return hashSet;
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(elements.iterator());
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtilRt.$$$reportNull$$$0(39);
        }
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(41);
        }
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(Arrays.asList(elements));
        if (linkedHashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(42);
        }
        return linkedHashSet;
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet() {
        TreeSet treeSet = new TreeSet();
        if (treeSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(43);
        }
        return treeSet;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(44);
        }
        TreeSet treeSet = ContainerUtilRt.copy(new TreeSet(), elements);
        if (treeSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(45);
        }
        return treeSet;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        TreeSet<? super T> treeSet = new TreeSet<T>(comparator);
        if (treeSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(46);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            ContainerUtilRt.$$$reportNull$$$0(47);
        }
        return emptyList;
    }

    @Deprecated
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<? super T> result) {
        if (result == null) {
            ContainerUtilRt.$$$reportNull$$$0(48);
        }
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        if (result == null) {
            ContainerUtilRt.$$$reportNull$$$0(49);
        }
        if (element != null) {
            result.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (array == null) {
            ContainerUtilRt.$$$reportNull$$$0(50);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(51);
        }
        List<? extends V> list = ContainerUtilRt.map2List(Arrays.asList(array), mapper);
        if (list == null) {
            ContainerUtilRt.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(53);
        }
        if (mapping == null) {
            ContainerUtilRt.$$$reportNull$$$0(54);
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtilRt.emptyList();
            if (list == null) {
                ContainerUtilRt.$$$reportNull$$$0(55);
            }
            return list;
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List<T> list = result.isEmpty() ? ContainerUtilRt.emptyList() : result;
        if (list == null) {
            ContainerUtilRt.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(57);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(58);
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtilRt.emptyList();
            if (list == null) {
                ContainerUtilRt.$$$reportNull$$$0(59);
            }
            return list;
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(61);
        }
        if (map.isEmpty()) {
            List<Pair<K, V>> list = ContainerUtilRt.emptyList();
            if (list == null) {
                ContainerUtilRt.$$$reportNull$$$0(62);
            }
            return list;
        }
        ArrayList<Pair<K, V>> result = new ArrayList<Pair<K, V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        ArrayList<Pair<K, V>> arrayList = result;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(64);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(65);
        }
        Set<? extends V> set = ContainerUtilRt.map2Set(Arrays.asList(collection), mapper);
        if (set == null) {
            ContainerUtilRt.$$$reportNull$$$0(66);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(67);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(68);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtilRt.$$$reportNull$$$0(69);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(70);
        }
        return hashSet;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(71);
        }
        if (array == null) {
            ContainerUtilRt.$$$reportNull$$$0(72);
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ContainerUtilRt.$$$reportNull$$$0(73);
        }
        return TArray;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<? extends T> c, @NotNull T[] sample) {
        if (c == null) {
            ContainerUtilRt.$$$reportNull$$$0(74);
        }
        if (sample == null) {
            ContainerUtilRt.$$$reportNull$$$0(75);
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            ContainerUtilRt.$$$reportNull$$$0(76);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list, @Nullable T def) {
        return ContainerUtilRt.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list) {
        return ContainerUtilRt.getLastItem(list, null);
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<? extends V> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtilRt.$$$reportNull$$$0(77);
        }
        if (condition == null) {
            ContainerUtilRt.$$$reportNull$$$0(78);
        }
        return ContainerUtilRt.find(iterable.iterator(), condition);
    }

    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterator<? extends V> iterator, @NotNull Condition<? super T> condition) {
        if (iterator == null) {
            ContainerUtilRt.$$$reportNull$$$0(79);
        }
        if (condition == null) {
            ContainerUtilRt.$$$reportNull$$$0(80);
        }
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtilRt.$$$reportNull$$$0(81);
        }
        if (condition == null) {
            ContainerUtilRt.$$$reportNull$$$0(82);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtilRt";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 21: 
            case 24: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 29: 
            case 53: 
            case 57: 
            case 64: 
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 39: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 50: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 51: 
            case 58: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 78: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtilRt";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeMap";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 43: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeSet";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 52: 
            case 59: 
            case 60: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 66: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 73: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 34: 
            case 36: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "newTreeSet";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 64: 
            case 65: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 71: 
            case 72: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                EmptyList.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a == null) {
                EmptyList.$$$reportNull$$$0(1);
            }
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                EmptyList.$$$reportNull$$$0(2);
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                EmptyList.$$$reportNull$$$0(3);
            }
            return emptyIterator;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            EmptyListIterator emptyListIterator = EmptyListIterator.getInstance();
            if (emptyListIterator == null) {
                EmptyList.$$$reportNull$$$0(4);
            }
            return emptyListIterator;
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            if (c == null) {
                EmptyList.$$$reportNull$$$0(5);
            }
            return c.isEmpty();
        }

        @Override
        @Contract(pure=true)
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Contract(pure=true)
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtilRt$EmptyList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtilRt$EmptyList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "containsAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

