/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class AppScheduledExecutorService
extends SchedulingWrapper {
    static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private final MyThreadFactory myCountingThreadFactory;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance("#org.jetbrains.ide.PooledThreadExecutor");
        if (logger == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(1);
        }
        return appScheduledExecutorService;
    }

    AppScheduledExecutorService(@NotNull String name) {
        if (name == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(2);
        }
        super(new BackendThreadPoolExecutor(new MyThreadFactory()), new AppDelayQueue());
        this.myName = name;
        this.myCountingThreadFactory = (MyThreadFactory)((BackendThreadPoolExecutor)this.backendExecutorService).getThreadFactory();
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    public void setNewThreadListener(@NotNull Consumer<? super Thread> threadListener) {
        if (threadListener == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(3);
        }
        this.myCountingThreadFactory.setNewThreadListener(threadListener);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = AppScheduledExecutorService.error();
        if (list == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        List<Runnable> list = ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdownNow());
        if (list == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void shutdownAppScheduledExecutorService() {
        Disposer.dispose(this.myLowMemoryWatcherManager);
        this.delayQueue.shutdown();
        this.doShutdown();
    }

    @NotNull
    public String statistics() {
        String string = this.myName + " threads created counter = " + this.myCountingThreadFactory.counter;
        if (string == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String dumpQueue() {
        return this.delayQueue.toString();
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    void setBackendPoolCorePoolSize(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superSetCorePoolSize(size);
    }

    int getBackendPoolCorePoolSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getCorePoolSize();
    }

    @NotNull
    public Thread getPeriodicTasksThread() {
        Thread thread = this.delayQueue.getThread();
        if (thread == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(7);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void awaitQuiescence(long timeout, @NotNull TimeUnit timeUnit) {
        HashSet workers;
        if (timeUnit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(8);
        }
        BackendThreadPoolExecutor executor = (BackendThreadPoolExecutor)this.backendExecutorService;
        executor.getKeepAliveTime(TimeUnit.NANOSECONDS);
        executor.superSetKeepAliveTime(1L, TimeUnit.NANOSECONDS);
        executor.superSetCorePoolSize(0);
        ReentrantLock mainLock = ReflectionUtil.getField(executor.getClass(), executor, ReentrantLock.class, "mainLock");
        mainLock.lock();
        try {
            HashSet workersField = ReflectionUtil.getField(executor.getClass(), executor, HashSet.class, "workers");
            workers = new HashSet(workersField);
        }
        finally {
            mainLock.unlock();
        }
        executor.superSetKeepAliveTime(1L, TimeUnit.SECONDS);
        for (Object worker : workers) {
            void unit;
            Thread thread = ReflectionUtil.getField(worker.getClass(), worker, Thread.class, "thread");
            try {
                thread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException e) {
                String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                System.err.println("Executor " + executor + " is still active after " + unit.toSeconds(timeout) + " seconds://///\nThread " + thread + " dump:\n" + trace + "all thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n/////");
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadListener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doShutdownNow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "statistics";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeriodicTasksThread";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNewThreadListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "awaitQuiescence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory) {
            if (factory == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(0);
            }
            super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), factory);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Logger logger = AppScheduledExecutorService.getLogger();
            if (logger.isTraceEnabled()) {
                logger.trace("beforeExecute " + BoundedTaskExecutor.info(r) + " in " + t);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Logger logger = AppScheduledExecutorService.getLogger();
            if (logger.isTraceEnabled()) {
                logger.trace("afterExecute  " + BoundedTaskExecutor.info(r) + " in " + Thread.currentThread());
            }
            if (t != null) {
                logger.error("Worker exited due to exception", t);
            }
        }

        private void superShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> superShutdownNow() {
            List<Runnable> list = super.shutdownNow();
            if (list == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = AppScheduledExecutorService.error();
            if (list == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        private void superSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        private void superSetKeepAliveTime(long time, TimeUnit unit) {
            super.setKeepAliveTime(time, unit);
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superShutdownNow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyThreadFactory
    extends CountingThreadFactory {
        private Consumer<? super Thread> newThreadListener;

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            if (r == null) {
                MyThreadFactory.$$$reportNull$$$0(0);
            }
            Thread thread = new Thread(r, AppScheduledExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            Consumer<? super Thread> listener = this.newThreadListener;
            if (listener != null) {
                listener.consume(thread);
            }
            Thread thread2 = thread;
            if (thread2 == null) {
                MyThreadFactory.$$$reportNull$$$0(1);
            }
            return thread2;
        }

        void setNewThreadListener(@NotNull Consumer<? super Thread> threadListener) {
            if (threadListener == null) {
                MyThreadFactory.$$$reportNull$$$0(2);
            }
            if (this.newThreadListener != null) {
                throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
            }
            this.newThreadListener = threadListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "newThread";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewThreadListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance");

        private Holder() {
        }
    }
}

