/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ParallelActivity {
    PREPARE_APP_INIT("prepareAppInitActivity"),
    PRELOAD_ACTIVITY("preloadActivity"),
    APP_OPTIONS_TOP_HIT_PROVIDER("appOptionsTopHitProvider"),
    PROJECT_OPTIONS_TOP_HIT_PROVIDER("projectOptionsTopHitProvider"),
    COMPONENT("component"),
    SERVICE("service"),
    EXTENSION("extension"),
    PROJECT_OPEN_HANDLER("openHandler"),
    POST_STARTUP_ACTIVITY("projectPostStartupActivity"),
    GC("GC"),
    REOPENING_EDITOR("reopeningEditor");

    public static final long MEASURE_THRESHOLD;
    private final String jsonName;
    private final AtomicInteger counter;

    private ParallelActivity(String jsonName) {
        if (jsonName == null) {
            ParallelActivity.$$$reportNull$$$0(0);
        }
        this.counter = new AtomicInteger();
        this.jsonName = jsonName;
    }

    @NotNull
    public String getJsonName() {
        String string = this.jsonName;
        if (string == null) {
            ParallelActivity.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Activity start(@NotNull String name) {
        if (name == null) {
            ParallelActivity.$$$reportNull$$$0(2);
        }
        ActivityImpl activityImpl = ActivityImpl.createParallelActivity(this, name);
        if (activityImpl == null) {
            ParallelActivity.$$$reportNull$$$0(3);
        }
        return activityImpl;
    }

    @NotNull
    public Activity start(@NotNull String name, @NotNull StartUpMeasurer.Level level) {
        if (name == null) {
            ParallelActivity.$$$reportNull$$$0(4);
        }
        if (level == null) {
            ParallelActivity.$$$reportNull$$$0(5);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, null, StartUpMeasurer.getCurrentTime(), null, level, this, null);
        if (activityImpl == null) {
            ParallelActivity.$$$reportNull$$$0(6);
        }
        return activityImpl;
    }

    @NotNull
    public Activity start(@NotNull String name, @NotNull StartUpMeasurer.Level level, @Nullable String pluginId) {
        if (name == null) {
            ParallelActivity.$$$reportNull$$$0(7);
        }
        if (level == null) {
            ParallelActivity.$$$reportNull$$$0(8);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, null, StartUpMeasurer.getCurrentTime(), null, level, this, pluginId);
        if (activityImpl == null) {
            ParallelActivity.$$$reportNull$$$0(9);
        }
        return activityImpl;
    }

    public long record(long start, @Nullable Class<?> clazz, @Nullable String pluginId) {
        return this.record(start, clazz, null, pluginId);
    }

    /*
     * WARNING - void declaration
     */
    public long record(long start, @NotNull Class<?> clazz, @Nullable StartUpMeasurer.Level level) {
        void level2;
        if (clazz == null) {
            ParallelActivity.$$$reportNull$$$0(10);
        }
        return this.record(start, clazz, (StartUpMeasurer.Level)level2, null);
    }

    public long record(long start, @Nullable Class<?> clazz, @Nullable StartUpMeasurer.Level level, String pluginId) {
        long end = StartUpMeasurer.getCurrentTime();
        long duration = end - start;
        if (duration <= MEASURE_THRESHOLD) {
            return duration;
        }
        ActivityImpl item = new ActivityImpl(clazz == null ? Integer.toString(this.counter.incrementAndGet()) : clazz.getName(), null, start, null, level, this, pluginId);
        item.setEnd(end);
        StartUpMeasurer.add(item);
        return duration;
    }

    static {
        MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/ParallelActivity";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/ParallelActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonName";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

