/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum LoadingPhase {
    BOOTSTRAP,
    SPLASH,
    CONFIGURATION_STORE_INITIALIZED,
    FRAME_SHOWN,
    PROJECT_OPENED,
    INDEXING_FINISHED;

    private static final boolean KEEP_IN_MIND_LOADING_PHASE;
    private static final Set<Throwable> stackTraces;
    private static final AtomicReference<LoadingPhase> currentPhase;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(LoadingPhase.class);
        if (logger == null) {
            LoadingPhase.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void setCurrentPhase(@NotNull LoadingPhase phase) {
        if (phase == null) {
            LoadingPhase.$$$reportNull$$$0(1);
        }
        currentPhase.set(phase);
        LoadingPhase.logPhaseSet(phase);
    }

    public static void compareAndSet(@NotNull LoadingPhase expect, @NotNull LoadingPhase phase) {
        if (expect == null) {
            LoadingPhase.$$$reportNull$$$0(2);
        }
        if (phase == null) {
            LoadingPhase.$$$reportNull$$$0(3);
        }
        if (currentPhase.compareAndSet(expect, phase)) {
            LoadingPhase.logPhaseSet(phase);
        }
    }

    private static void logPhaseSet(@NotNull LoadingPhase phase) {
        if (phase == null) {
            LoadingPhase.$$$reportNull$$$0(4);
        }
        LoadingPhase.getLogger().info("Reached " + (Object)((Object)phase) + " loading phase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertAtLeast(@NotNull LoadingPhase phase) {
        if (phase == null) {
            LoadingPhase.$$$reportNull$$$0(5);
        }
        if (!KEEP_IN_MIND_LOADING_PHASE) {
            return;
        }
        LoadingPhase currentPhase = LoadingPhase.currentPhase.get();
        if (currentPhase.ordinal() >= phase.ordinal() || LoadingPhase.isKnownViolator()) {
            return;
        }
        Throwable t = new Throwable();
        Set<Throwable> set = stackTraces;
        synchronized (set) {
            if (!stackTraces.add(t)) {
                return;
            }
            LoadingPhase.getLogger().warn("Should be called at least at phase " + (Object)((Object)phase) + ", the current phase is: " + (Object)((Object)currentPhase) + "\nCurrent violators count: " + stackTraces.size() + "\n\n", t);
        }
    }

    private static boolean isKnownViolator() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> {
            String className = element.getClassName();
            return className.equals("com.intellij.openapi.application.Preloader") || className.contains("com.intellij.util.indexing.IndexInfrastructure");
        });
    }

    public static boolean isStartupComplete() {
        return LoadingPhase.isComplete(INDEXING_FINISHED);
    }

    public static boolean isComplete(@NotNull LoadingPhase phase) {
        if (phase == null) {
            LoadingPhase.$$$reportNull$$$0(6);
        }
        return currentPhase.get().ordinal() >= phase.ordinal();
    }

    static {
        KEEP_IN_MIND_LOADING_PHASE = Boolean.parseBoolean("idea.keep.in.mind.loading.phase");
        stackTraces = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Throwable>(){

            public int computeHashCode(Throwable throwable) {
                return this.getCollect(throwable).hashCode();
            }

            private String getCollect(Throwable throwable) {
                return Arrays.stream(throwable.getStackTrace()).map(element -> element.getClassName() + element.getMethodName()).collect(Collectors.joining());
            }

            public boolean equals(Throwable o1, Throwable o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 == null || o2 == null) {
                    return false;
                }
                return Comparing.equal(this.getCollect(o1), this.getCollect(o2));
            }
        });
        currentPhase = new AtomicReference<LoadingPhase>(BOOTSTRAP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/LoadingPhase";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/LoadingPhase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentPhase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logPhaseSet";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertAtLeast";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isComplete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

