/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.RemoveAnnotationFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PatternAnnotationNotApplicable
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PatternAnnotationNotApplicable.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            final String annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getPatternAnnotationClass();
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                String name = annotation.getQualifiedName();
                if (this.annotationName.equals(name)) {
                    PatternAnnotationNotApplicable.this.checkAnnotation(annotation, holder);
                } else if (name != null && (psiClass = JavaPsiFacade.getInstance((Project)annotation.getProject()).findClass(name, annotation.getResolveScope())) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)this.annotationName, (int)2)) {
                    PatternAnnotationNotApplicable.this.checkAnnotation(annotation, holder);
                }
            }
        };
        if (javaElementVisitor == null) {
            PatternAnnotationNotApplicable.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private void checkAnnotation(PsiAnnotation annotation, ProblemsHolder holder) {
        PsiType type;
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
        if (owner instanceof PsiVariable) {
            PsiType type2 = ((PsiVariable)owner).getType();
            if (!PsiUtilEx.isString(type2)) {
                this.registerProblem(annotation, holder);
            }
        } else if (owner instanceof PsiMethod && (type = ((PsiMethod)owner).getReturnType()) != null && !PsiUtilEx.isString(type)) {
            this.registerProblem(annotation, holder);
        }
    }

    private void registerProblem(PsiAnnotation annotation, ProblemsHolder holder) {
        holder.registerProblem((PsiElement)annotation, "Pattern Annotation is only applicable to elements of type String", new LocalQuickFix[]{new RemoveAnnotationFix(this)});
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("PatternNotApplicable" == null) {
            PatternAnnotationNotApplicable.$$$reportNull$$$0(2);
        }
        return "PatternNotApplicable";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/pattern/PatternAnnotationNotApplicable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/pattern/PatternAnnotationNotApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

