/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.lighthouse;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import icons.TasksCoreIcons;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Lighthouse")
public class LighthouseRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.lighthouse.LighthouseRepository");
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d).*(\\d\\d:\\d\\d:\\d\\d).*");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Pattern myPattern;
    private String myProjectId;

    public LighthouseRepository() {
    }

    public LighthouseRepository(TaskRepositoryType type) {
        super(type);
    }

    @NotNull
    public BaseRepository clone() {
        LighthouseRepository lighthouseRepository = new LighthouseRepository(this);
        if (lighthouseRepository == null) {
            LighthouseRepository.$$$reportNull$$$0(0);
        }
        return lighthouseRepository;
    }

    private LighthouseRepository(LighthouseRepository other) {
        super((BaseRepositoryImpl)other);
        this.setProjectId(other.myProjectId);
    }

    public void testConnection() throws Exception {
        this.getIssues(null, 10, 0L);
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.getProjectId()) && StringUtil.isNotEmpty((String)this.getPassword());
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        HttpMethod method;
        InputStream stream;
        Element element;
        String url = "/projects/" + this.myProjectId + "/tickets.xml";
        url = url + "?q=" + LighthouseRepository.encodeUrl((String)"state:open sort:updated ");
        if (!StringUtil.isEmpty((String)query)) {
            url = url + LighthouseRepository.encodeUrl((String)query);
        }
        ArrayList tasks = new ArrayList();
        int page = 1;
        HttpClient client = this.login();
        while (tasks.size() < max && !"nil-classes".equals((element = new SAXBuilder(false).build(stream = (method = this.doREST(url + "&page=" + page, false, client)).getResponseBodyAsStream()).getRootElement()).getName())) {
            if (!"tickets".equals(element.getName())) {
                LOG.warn("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode());
                throw new Exception("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode() + "\n" + element.getText());
            }
            List children = element.getChildren("ticket");
            List taskList = ContainerUtil.mapNotNull((Collection)children, (Function)((NullableFunction)o -> this.createIssue((Element)o)));
            tasks.addAll(taskList);
            ++page;
        }
        return tasks.toArray(Task.EMPTY_ARRAY);
    }

    @Nullable
    private Task createIssue(Element element) {
        final String id = element.getChildText("number");
        if (id == null) {
            return null;
        }
        final String summary = element.getChildText("title");
        if (summary == null) {
            return null;
        }
        final String description = element.getChildText("original-body");
        final boolean isClosed = "true".equals(element.getChildText("closed"));
        final Ref updated = new Ref();
        final Ref created = new Ref();
        try {
            updated.set((Object)LighthouseRepository.parseDate(element, "updated-at"));
            created.set((Object)LighthouseRepository.parseDate(element, "created-at"));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
        }
        return new Task(){

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return LighthouseRepository.this.getUrl() + "/projects/" + LighthouseRepository.this.myProjectId + "/tickets/" + this.getId() + ".xml";
            }

            @NotNull
            public String getId() {
                String string = LighthouseRepository.this.myProjectId + "-" + id;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = summary;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String getDescription() {
                return description;
            }

            @NotNull
            public Comment[] getComments() {
                if (Comment.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(2);
                }
                return Comment.EMPTY_ARRAY;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = TasksCoreIcons.Lighthouse;
                if (icon == null) {
                    1.$$$reportNull$$$0(3);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = TaskType.BUG;
                if (taskType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return taskType;
            }

            public Date getUpdated() {
                return (Date)updated.get();
            }

            public Date getCreated() {
                return (Date)created.get();
            }

            public boolean isClosed() {
                return isClosed;
            }

            public TaskRepository getRepository() {
                return LighthouseRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/tasks/lighthouse/LighthouseRepository$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    private static Date parseDate(Element element, String name) throws ParseException {
        Matcher m = DATE_PATTERN.matcher(element.getChildText(name));
        if (m.find()) {
            return DATE_FORMAT.parse(m.group(1) + " " + m.group(2));
        }
        return null;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher;
        if (taskName == null) {
            LighthouseRepository.$$$reportNull$$$0(1);
        }
        return (matcher = this.myPattern.matcher(taskName)).find() ? matcher.group(1) : null;
    }

    private HttpMethod doREST(String request, boolean post, HttpClient client) throws Exception {
        String uri = this.getUrl() + request;
        PostMethod method = post ? new PostMethod(uri) : new GetMethod(uri);
        this.configureHttpMethod((HttpMethod)method);
        client.executeMethod((HttpMethod)method);
        return method;
    }

    private HttpClient login() throws Exception {
        HttpClient client = this.getHttpClient();
        GetMethod method = new GetMethod(this.getUrl() + "/projects.xml");
        this.configureHttpMethod((HttpMethod)method);
        client.getParams().setContentCharset("UTF-8");
        client.executeMethod((HttpMethod)method);
        if (method.getStatusCode() != 200) {
            throw new Exception("Cannot login: HTTP returned " + method.getStatusCode());
        }
        String response = method.getResponseBodyAsString();
        if (response == null) {
            throw new NullPointerException();
        }
        if (response.contains("<errors>")) {
            int length;
            int pos = response.indexOf("</errors>");
            if (pos > (length = "<errors>".length())) {
                response = response.substring(length, pos);
            }
            throw new Exception("Cannot login: " + response);
        }
        return client;
    }

    protected void configureHttpMethod(HttpMethod method) {
        method.addRequestHeader("X-LighthouseToken", this.getPassword());
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            LighthouseRepository.$$$reportNull$$$0(2);
        }
        String[] split = id.split("\\-");
        String projectId = split[0];
        String realId = split[1];
        if (!Comparing.strEqual((String)projectId, (String)this.myProjectId)) {
            return null;
        }
        HttpMethod method = this.doREST("/projects/" + this.myProjectId + "/tickets/" + realId + ".xml", false, this.login());
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        return element.getName().equals("ticket") ? this.createIssue(element) : null;
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(String projectId) {
        this.myProjectId = projectId;
        this.myPattern = Pattern.compile("(" + projectId + "\\-\\d+):\\s+");
    }

    @Deprecated
    public String getAPIKey() {
        return null;
    }

    @Deprecated
    public void setAPIKey(String APIKey) {
        this.setPassword(APIKey);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LighthouseRepository)) {
            return false;
        }
        LighthouseRepository that = (LighthouseRepository)((Object)o);
        return !(this.getProjectId() != null ? !this.getProjectId().equals(that.getProjectId()) : that.getProjectId() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/lighthouse/LighthouseRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/lighthouse/LighthouseRepository";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

