/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigFilesCollector;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleStatusBarUIContributor;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParserCallback;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    private static final Map<String, List<String>> DEPENDENCIES = new HashMap<String, List<String>>();

    private static void addDependency(@NotNull String name, String ... dependentNames) {
        if (name == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(0);
        }
        DEPENDENCIES.put(name, Arrays.asList(dependentNames));
    }

    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Project project;
        if (settings == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(2);
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (Utils.isFullIntellijSettingsSupport() && file != null && !(project = psiFile.getProject()).isDisposed() && Utils.isEnabled((CodeStyleSettings)settings)) {
            try {
                MyContext context = new MyContext((CodeStyleSettings)settings, psiFile);
                EditorConfigCodeStyleSettingsModifier.processEditorConfig(project, psiFile, context);
                if (EditorConfigCodeStyleSettingsModifier.applyCodeStyleSettings(context)) {
                    settings.addDependencies(context.getEditorConfigFiles());
                    EditorConfigNavigationActionsFactory.getInstance(psiFile.getVirtualFile()).updateEditorConfigFilePaths(context.getFilePaths());
                    return true;
                }
            }
            catch (EditorConfigException editorConfigException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(3);
        }
        return new EditorConfigCodeStyleStatusBarUIContributor();
    }

    private static boolean applyCodeStyleSettings(@NotNull MyContext context) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(4);
        }
        AbstractCodeStylePropertyMapper mapper = EditorConfigCodeStyleSettingsModifier.getPropertyMapper(context);
        HashSet<String> processed = new HashSet<String>();
        boolean isModified = EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, false, processed);
        isModified = EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, true, processed) || isModified;
        return isModified;
    }

    @NotNull
    private static AbstractCodeStylePropertyMapper getPropertyMapper(@NotNull MyContext context) {
        LanguageCodeStyleSettingsProvider provider;
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(5);
        }
        if ((provider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)context.getLanguage())) != null) {
            AbstractCodeStylePropertyMapper abstractCodeStylePropertyMapper = provider.getPropertyMapper(context.getSettings());
            if (abstractCodeStylePropertyMapper == null) {
                EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(6);
            }
            return abstractCodeStylePropertyMapper;
        }
        GeneralCodeStylePropertyMapper generalCodeStylePropertyMapper = new GeneralCodeStylePropertyMapper(context.getSettings());
        if (generalCodeStylePropertyMapper == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(7);
        }
        return generalCodeStylePropertyMapper;
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        if (project == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(8);
        }
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && Utils.editorConfigExists(project);
    }

    public String getName() {
        return "EditorConfig";
    }

    private static boolean processOptions(@NotNull MyContext context, @NotNull AbstractCodeStylePropertyMapper mapper, boolean languageSpecific, Set<String> processed) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(9);
        }
        if (mapper == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(10);
        }
        String langPrefix = languageSpecific ? mapper.getLanguageDomainId() + "_" : null;
        boolean isModified = false;
        for (EditorConfig.OutPair option : context.getOptions()) {
            String optionKey = option.getKey();
            String intellijName = EditorConfigIntellijNameUtil.toIntellijName(optionKey);
            CodeStylePropertyAccessor accessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, intellijName, langPrefix);
            if (accessor == null) continue;
            String val = EditorConfigCodeStyleSettingsModifier.preprocessValue(context, optionKey, option.getVal());
            if (DEPENDENCIES.containsKey(optionKey)) {
                for (String dependency : DEPENDENCIES.get(optionKey)) {
                    CodeStylePropertyAccessor dependencyAccessor;
                    if (processed.contains(dependency) || (dependencyAccessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, dependency, null)) == null) continue;
                    isModified |= dependencyAccessor.setFromString(val);
                }
            }
            isModified |= accessor.setFromString(val);
            processed.add(intellijName);
        }
        return isModified;
    }

    private static String preprocessValue(@NotNull MyContext context, @NotNull String optionKey, @NotNull String optionValue) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(11);
        }
        if (optionKey == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(12);
        }
        if (optionValue == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(13);
        }
        if ("indent_size".equals(optionKey) && "tab".equals(optionValue)) {
            return context.getTabSize();
        }
        return optionValue;
    }

    @Nullable
    private static CodeStylePropertyAccessor findAccessor(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName, @Nullable String langPrefix) {
        if (mapper == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(15);
        }
        if (langPrefix != null) {
            String prefixlessName;
            EditorConfigPropertyKind propertyKind;
            if (propertyName.startsWith(langPrefix) && ((propertyKind = IntellijPropertyKindMap.getPropertyKind(prefixlessName = StringUtil.trimStart((String)propertyName, (String)langPrefix))) == EditorConfigPropertyKind.LANGUAGE || propertyKind == EditorConfigPropertyKind.COMMON)) {
                return mapper.getAccessor(prefixlessName);
            }
        } else {
            return mapper.getAccessor(propertyName);
        }
        return null;
    }

    private static void processEditorConfig(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull MyContext context) throws EditorConfigException {
        if (project == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(16);
        }
        if (psiFile == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(17);
        }
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(18);
        }
        String filePath = Utils.getFilePath(project, psiFile.getVirtualFile());
        Set<String> rootDirs = SettingsProviderComponent.getInstance().getRootDirs(project);
        context.setOptions(new EditorConfig().getProperties(filePath, rootDirs, (ParserCallback)context));
    }

    @Nullable
    public Consumer<CodeStyleSettings> getDisablingFunction() {
        return settings -> {
            EditorConfigSettings editorConfigSettings = (EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class);
            editorConfigSettings.ENABLED = false;
        };
    }

    static {
        EditorConfigCodeStyleSettingsModifier.addDependency("indent_size", "continuation_indent_size");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionKey";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modifySettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatusBarUiContributor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyCodeStyleSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMapper";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mayOverrideSettingsOf";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processOptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "preprocessValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAccessor";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processEditorConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyContext
    extends EditorConfigFilesCollector {
        @NotNull
        private final CodeStyleSettings mySettings;
        @Nullable
        private List<EditorConfig.OutPair> myOptions;
        @NotNull
        private final PsiFile myFile;

        private MyContext(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
            if (settings == null) {
                MyContext.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyContext.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            this.myFile = file;
        }

        public void setOptions(@NotNull List<EditorConfig.OutPair> options) {
            if (options == null) {
                MyContext.$$$reportNull$$$0(2);
            }
            this.myOptions = options;
        }

        @NotNull
        private CodeStyleSettings getSettings() {
            CodeStyleSettings codeStyleSettings = this.mySettings;
            if (codeStyleSettings == null) {
                MyContext.$$$reportNull$$$0(3);
            }
            return codeStyleSettings;
        }

        @NotNull
        private List<EditorConfig.OutPair> getOptions() {
            List<Object> list = this.myOptions == null ? Collections.emptyList() : this.myOptions;
            if (list == null) {
                MyContext.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private Language getLanguage() {
            Language language = this.myFile.getLanguage();
            if (language == null) {
                MyContext.$$$reportNull$$$0(5);
            }
            return language;
        }

        private String getTabSize() {
            for (EditorConfig.OutPair pair : this.getOptions()) {
                if (!"tab_width".equals(pair.getKey())) continue;
                return pair.getVal();
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions(this.myFile.getFileType());
            return String.valueOf(indentOptions.TAB_SIZE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$MyContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$MyContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setOptions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

