/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.io.IOException;
import org.editorconfig.configmanagement.editor.EditorConfigEditorWithPreview;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFile;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFileEditor;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.language.filetype.EditorConfigFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigEditorProvider
implements AsyncFileEditorProvider,
DumbAware {
    private static final String EDITOR_TYPE_ID = "org.editorconfig.configmanagement.editor";
    static final int MAX_PREVIEW_LENGTH = 10000;
    private static final PsiAwareTextEditorProvider myMainEditorProvider = new PsiAwareTextEditorProvider();

    @NotNull
    public AsyncFileEditorProvider.Builder createEditorAsync(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(1);
        }
        MyEditorBuilder myEditorBuilder = new MyEditorBuilder(project, file);
        if (myEditorBuilder == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(2);
        }
        return myEditorBuilder;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(4);
        }
        return ((Object)((Object)EditorConfigFileType.INSTANCE)).equals(file.getFileType());
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(6);
        }
        FileEditor fileEditor = new MyEditorBuilder(project, file).build();
        if (fileEditor == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(7);
        }
        return fileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (EDITOR_TYPE_ID == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(8);
        }
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(9);
        }
        return fileEditorPolicy;
    }

    @Nullable
    static Language getLanguage(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            EditorConfigEditorProvider.$$$reportNull$$$0(10);
        }
        return (fileType = virtualFile.getFileType()) instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigEditorProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigEditorProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorAsync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditorAsync";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditorBuilder
    extends AsyncFileEditorProvider.Builder {
        private final Project myProject;
        private final VirtualFile myFile;

        private MyEditorBuilder(Project project, VirtualFile file) {
            this.myProject = project;
            this.myFile = file;
        }

        public FileEditor build() {
            VirtualFile contextFile = EditorConfigPreviewManager.getInstance(this.myProject).getAssociatedPreviewFile(this.myFile);
            if (contextFile != null) {
                Document document = EditorFactory.getInstance().createDocument((CharSequence)MyEditorBuilder.getPreviewText(contextFile));
                EditorConfigPreviewFile previewFile = new EditorConfigPreviewFile(this.myProject, contextFile, document);
                FileEditor previewEditor = this.createPreviewEditor(document, previewFile);
                TextEditor ecTextEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(this.myProject, this.myFile);
                EditorConfigEditorWithPreview splitEditor = new EditorConfigEditorWithPreview(ecTextEditor, previewEditor);
                Disposer.register((Disposable)splitEditor, (Disposable)previewFile);
                return splitEditor;
            }
            return myMainEditorProvider.createEditor(this.myProject, this.myFile);
        }

        private FileEditor createPreviewEditor(@NotNull Document document, @NotNull EditorConfigPreviewFile previewFile) {
            Editor previewEditor;
            if (document == null) {
                MyEditorBuilder.$$$reportNull$$$0(0);
            }
            if (previewFile == null) {
                MyEditorBuilder.$$$reportNull$$$0(1);
            }
            if ((previewEditor = EditorFactory.getInstance().createEditor(document, this.myProject)) instanceof EditorEx) {
                EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)previewFile);
                ((EditorEx)previewEditor).setHighlighter(highlighter);
            }
            return new EditorConfigPreviewFileEditor(previewEditor, previewFile);
        }

        @NotNull
        private static String getPreviewText(@NotNull VirtualFile file) {
            String sample;
            LanguageCodeStyleSettingsProvider provider;
            Language language;
            if (file == null) {
                MyEditorBuilder.$$$reportNull$$$0(2);
            }
            if (file.getLength() <= 10000L) {
                String string;
                try {
                    string = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)file));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (string == null) {
                    MyEditorBuilder.$$$reportNull$$$0(3);
                }
                return string;
            }
            if ((language = EditorConfigEditorProvider.getLanguage(file)) != null && (provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language)) != null && (sample = provider.getCodeSample(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS)) != null) {
                String string = sample;
                if (string == null) {
                    MyEditorBuilder.$$$reportNull$$$0(4);
                }
                return string;
            }
            if ("No preview" == null) {
                MyEditorBuilder.$$$reportNull$$$0(5);
            }
            return "No preview";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigEditorProvider$MyEditorBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigEditorProvider$MyEditorBuilder";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviewText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPreviewEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPreviewText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

