/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.ScalarProperty;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.stateProperties.ObjectStateStoredPropertyBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u00020\u0004B\u001d\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J,\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/serialization/stateProperties/EnumStoredProperty;", "T", "", "Lcom/intellij/serialization/stateProperties/ObjectStateStoredPropertyBase;", "Lcom/intellij/openapi/components/ScalarProperty;", "defaultValue", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Enum;Ljava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "Ljava/lang/Enum;", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "getModificationCount", "", "isEqualToDefault", "", "parseAndSetValue", "", "rawValue", "", "setValue", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "property", "Lkotlin/reflect/KProperty;", "newValue", "(Lcom/intellij/openapi/components/BaseState;Lkotlin/reflect/KProperty;Ljava/lang/Enum;)V", "intellij.platform.objectSerializer"})
public final class EnumStoredProperty<T extends Enum<?>>
extends ObjectStateStoredPropertyBase<T>
implements ScalarProperty {
    private final T defaultValue;
    @NotNull
    private final Class<T> clazz;

    @Override
    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.STRING;
    }

    public boolean isEqualToDefault() {
        return (Enum)this.getValue() == this.defaultValue;
    }

    public long getModificationCount() {
        return 0L;
    }

    @Override
    public void setValue(@NotNull BaseState thisRef, @NotNull KProperty<?> property, @Nullable T newValue) {
        T v;
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        T t = newValue;
        if (t == null) {
            t = v = this.defaultValue;
        }
        if ((Enum)this.getValue() != v) {
            thisRef.intIncrementModificationCount();
            this.setValue(v);
        }
    }

    public void parseAndSetValue(@Nullable String rawValue) {
        if (rawValue == null) {
            this.setValue(this.defaultValue);
        } else {
            Enum enum_ = (Enum)ClassUtil.stringToEnum((String)rawValue, this.clazz, (boolean)true);
            if (enum_ == null) {
                enum_ = this.defaultValue;
            }
            this.setValue(enum_);
        }
    }

    @NotNull
    public final Class<T> getClazz() {
        return this.clazz;
    }

    public EnumStoredProperty(@Nullable T defaultValue, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        super(defaultValue);
        this.defaultValue = defaultValue;
        this.clazz = clazz;
    }
}

