/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.serialization.ObjectSerializer;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadConfiguration;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.VersionedFileKt;
import com.intellij.serialization.WriteConfiguration;
import com.intellij.util.ParameterizedTypeImpl;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001JT\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172+\b\u0002\u0010\u0018\u001a%\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0019j\u0004\u0018\u0001`\u001dH\u0007\u00a2\u0006\u0002\u0010\u001eJE\u0010\u001f\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010$\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010%J8\u0010&\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010'\"\u0004\b\u0000\u0010\u00152\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010$\u001a\u00020\u0007H\u0007J\b\u0010)\u001a\u00020*H\u0002J\t\u0010+\u001a\u00020,H\u00d6\u0001J4\u0010-\u001a\u00020*\"\u0004\b\u0000\u0010\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00150/2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\b\b\u0002\u0010 \u001a\u000200H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lcom/intellij/serialization/VersionedFile;", "", "file", "Ljava/nio/file/Path;", "version", "", "isCompressed", "", "(Ljava/nio/file/Path;IZ)V", "getFile", "()Ljava/nio/file/Path;", "getVersion", "()I", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "read", "T", "objectClass", "Ljava/lang/Class;", "beanConstructed", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "instance", "Lcom/intellij/serialization/BeanConstructed;", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readAndHandleErrors", "configuration", "Lcom/intellij/serialization/ReadConfiguration;", "originalType", "Ljava/lang/reflect/Type;", "renameToCorruptedOnError", "(Ljava/lang/Class;Lcom/intellij/serialization/ReadConfiguration;Ljava/lang/reflect/Type;Z)Ljava/lang/Object;", "readList", "", "itemClass", "renameSilentlyToCorrupted", "", "toString", "", "writeList", "data", "", "Lcom/intellij/serialization/WriteConfiguration;", "intellij.platform.objectSerializer"})
public final class VersionedFile {
    @NotNull
    private final Path file;
    private final int version;
    private final boolean isCompressed;

    @JvmOverloads
    public final <T> void writeList(@NotNull Collection<? extends T> data, @NotNull Class<T> itemClass, @NotNull WriteConfiguration configuration) throws IOException {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        Intrinsics.checkParameterIsNotNull(itemClass, (String)"itemClass");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        PathKt.writeSafe((Path)this.file, (Function1)((Function1)new Function1<OutputStream, Unit>(this, data, itemClass, configuration){
            final /* synthetic */ VersionedFile this$0;
            final /* synthetic */ Collection $data;
            final /* synthetic */ Class $itemClass;
            final /* synthetic */ WriteConfiguration $configuration;

            public final void invoke(@NotNull OutputStream fileOut) {
                Object object;
                FilterOutputStream filterOutputStream;
                Intrinsics.checkParameterIsNotNull((Object)fileOut, (String)"fileOut");
                if (VersionedFile.access$isCompressed$p(this.this$0)) {
                    filterOutputStream = (FilterOutputStream)new LZ4FrameOutputStream(fileOut, LZ4FrameOutputStream.BLOCKSIZE.SIZE_4MB);
                } else {
                    object = fileOut;
                    int n = 32768;
                    boolean bl = false;
                    filterOutputStream = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
                }
                FilterOutputStream out = filterOutputStream;
                object = this.$configuration;
                Type type = (Type)new ParameterizedTypeImpl((Type)this.$data.getClass(), new Type[]{this.$itemClass});
                ObjectSerializer.Companion.getInstance().getSerializer$intellij_platform_objectSerializer().writeVersioned(this.$data, out, this.this$0.getVersion(), (WriteConfiguration)object, type);
            }
            {
                this.this$0 = versionedFile;
                this.$data = collection;
                this.$itemClass = clazz;
                this.$configuration = writeConfiguration;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void writeList$default(VersionedFile versionedFile, Collection collection, Class clazz, WriteConfiguration writeConfiguration, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            writeConfiguration = VersionedFileKt.access$getVersionedFileDefaultWriteConfiguration$p();
        }
        versionedFile.writeList(collection, clazz, writeConfiguration);
    }

    @JvmOverloads
    public final <T> void writeList(@NotNull Collection<? extends T> data, @NotNull Class<T> itemClass) throws IOException {
        VersionedFile.writeList$default(this, data, itemClass, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final <T> List<T> readList(@NotNull Class<T> itemClass, @NotNull ReadConfiguration configuration, boolean renameToCorruptedOnError) throws IOException, SerializationException {
        Intrinsics.checkParameterIsNotNull(itemClass, (String)"itemClass");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        return this.readAndHandleErrors(ArrayList.class, configuration, (Type)new ParameterizedTypeImpl((Type)((Object)ArrayList.class), new Type[]{itemClass}), renameToCorruptedOnError);
    }

    public static /* synthetic */ List readList$default(VersionedFile versionedFile, Class clazz, ReadConfiguration readConfiguration, boolean bl, int n, Object object) throws IOException, SerializationException {
        if ((n & 2) != 0) {
            readConfiguration = new ReadConfiguration(false, null, null, null, 15, null);
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return versionedFile.readList(clazz, readConfiguration, bl);
    }

    @JvmOverloads
    @Nullable
    public final <T> List<T> readList(@NotNull Class<T> itemClass, @NotNull ReadConfiguration configuration) throws IOException, SerializationException {
        return VersionedFile.readList$default(this, itemClass, configuration, false, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final <T> List<T> readList(@NotNull Class<T> itemClass) throws IOException, SerializationException {
        return VersionedFile.readList$default(this, itemClass, null, false, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final <T> T read(@NotNull Class<T> objectClass, @Nullable Function1<Object, ? extends Object> beanConstructed) throws IOException, SerializationException {
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        return (T)VersionedFile.readAndHandleErrors$default(this, objectClass, new ReadConfiguration(false, null, beanConstructed, null, 11, null), null, false, 12, null);
    }

    public static /* synthetic */ Object read$default(VersionedFile versionedFile, Class clazz, Function1 function1, int n, Object object) throws IOException, SerializationException {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return versionedFile.read(clazz, (Function1<Object, ? extends Object>)function1);
    }

    @JvmOverloads
    @Nullable
    public final <T> T read(@NotNull Class<T> objectClass) throws IOException, SerializationException {
        return (T)VersionedFile.read$default(this, objectClass, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T readAndHandleErrors(Class<T> objectClass, ReadConfiguration configuration, Type originalType, boolean renameToCorruptedOnError) {
        Object v0;
        block16: {
            Closeable closeable;
            Path file$iv = this.file;
            boolean $i$f$readPossiblyCompressedIonFile = false;
            try {
                closeable = Files.newByteChannel(file$iv, SetsKt.setOf((Object)StandardOpenOption.READ), new FileAttribute[0]);
            }
            catch (NoSuchFileException e$iv) {
                v0 = null;
                break block16;
            }
            catch (IOException e$iv) {
                ObjectSerializerKt.getLOG().error((Throwable)e$iv);
                v0 = null;
                break block16;
            }
            SeekableByteChannel channel$iv = closeable;
            closeable = channel$iv;
            boolean bl = false;
            Throwable throwable = null;
            try {
                ReadConfiguration readConfiguration;
                InputStream inputStream;
                Closeable it$iv = closeable;
                boolean bl2 = false;
                ByteBuffer lz4Magic$iv = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
                channel$iv.read(lz4Magic$iv);
                channel$iv.position(0L);
                InputStream input$iv = Channels.newInputStream(channel$iv);
                switch (lz4Magic$iv.getInt(0)) {
                    case 407708164: {
                        inputStream = (InputStream)new LZ4FrameInputStream(input$iv);
                        break;
                    }
                    default: {
                        InputStream inputStream2 = input$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"input");
                        InputStream inputStream3 = inputStream2;
                        int n = 32768;
                        boolean bl3 = false;
                        inputStream = inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n);
                    }
                }
                InputStream input = input$iv = inputStream;
                boolean bl4 = false;
                try {
                    readConfiguration = configuration;
                    Type type = originalType;
                    readConfiguration = ObjectSerializer.Companion.getInstance().getSerializer$intellij_platform_objectSerializer().readVersioned(objectClass, input, this.file, this.version, readConfiguration, type);
                }
                catch (Exception e) {
                    if (renameToCorruptedOnError) {
                        this.renameSilentlyToCorrupted();
                    }
                    ObjectSerializerKt.getLOG().error((Throwable)e);
                    T t = null;
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    return t;
                }
                ReadConfiguration result = readConfiguration;
                if (result == null && renameToCorruptedOnError) {
                    this.renameSilentlyToCorrupted();
                }
                ReadConfiguration readConfiguration2 = result;
                return (T)readConfiguration2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return v0;
    }

    static /* synthetic */ Object readAndHandleErrors$default(VersionedFile versionedFile, Class clazz, ReadConfiguration readConfiguration, Type type, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            type = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return versionedFile.readAndHandleErrors(clazz, readConfiguration, type, bl);
    }

    private final void renameSilentlyToCorrupted() {
        try {
            Path path = this.file.getParent().resolve(this.file.getFileName() + ".corrupted");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.parent.resolve(\"${file.fileName}.corrupted\")");
            PathKt.move((Path)this.file, (Path)path);
        }
        catch (Exception e) {
            ObjectSerializerKt.getLOG().debug((Throwable)e);
        }
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    public final int getVersion() {
        return this.version;
    }

    @JvmOverloads
    public VersionedFile(@NotNull Path file, int version, boolean isCompressed) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.version = version;
        this.isCompressed = isCompressed;
    }

    public /* synthetic */ VersionedFile(Path path, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(path, n, bl);
    }

    @JvmOverloads
    public VersionedFile(@NotNull Path file, int version) {
        this(file, version, false, 4, null);
    }

    public static final /* synthetic */ boolean access$isCompressed$p(VersionedFile $this) {
        return $this.isCompressed;
    }

    @NotNull
    public final Path component1() {
        return this.file;
    }

    public final int component2() {
        return this.version;
    }

    private final boolean component3() {
        return this.isCompressed;
    }

    @NotNull
    public final VersionedFile copy(@NotNull Path file, int version, boolean isCompressed) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new VersionedFile(file, version, isCompressed);
    }

    public static /* synthetic */ VersionedFile copy$default(VersionedFile versionedFile, Path path, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            path = versionedFile.file;
        }
        if ((n2 & 2) != 0) {
            n = versionedFile.version;
        }
        if ((n2 & 4) != 0) {
            bl = versionedFile.isCompressed;
        }
        return versionedFile.copy(path, n, bl);
    }

    @NotNull
    public String toString() {
        return "VersionedFile(file=" + this.file + ", version=" + this.version + ", isCompressed=" + this.isCompressed + ")";
    }

    public int hashCode() {
        Path path = this.file;
        int n = ((path != null ? ((Object)path).hashCode() : 0) * 31 + Integer.hashCode(this.version)) * 31;
        int n2 = this.isCompressed ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof VersionedFile)) break block3;
                VersionedFile versionedFile = (VersionedFile)object;
                if (!Intrinsics.areEqual((Object)this.file, (Object)versionedFile.file) || !(this.version == versionedFile.version) || !(this.isCompressed == versionedFile.isCompressed)) break block3;
            }
            return true;
        }
        return false;
    }
}

