/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.LogEntryPath;

public class LogEntry {
    public static final LogEntry EMPTY = new Builder().setRevision(-1L).setHasChildren(false).build();
    private final long myRevision;
    @Nullable
    private final Date myDate;
    private final String myMessage;
    private final String myAuthor;
    @NotNull
    private final Map<String, LogEntryPath> myChangedPaths;
    private final boolean myHasChildren;

    public LogEntry(@NotNull Builder builder) {
        if (builder == null) {
            LogEntry.$$$reportNull$$$0(0);
        }
        this.myRevision = builder.revision;
        this.myChangedPaths = LogEntry.toImmutable(builder.changedPaths);
        this.myAuthor = builder.author;
        this.myDate = builder.date;
        this.myMessage = builder.message;
        this.myHasChildren = builder.hasChildren();
    }

    @NotNull
    private static Map<String, LogEntryPath> toImmutable(@NotNull List<LogEntryPath.Builder> paths) {
        if (paths == null) {
            LogEntry.$$$reportNull$$$0(1);
        }
        ContainerUtil.ImmutableMapBuilder builder = ContainerUtil.immutableMapBuilder();
        for (LogEntryPath.Builder path : paths) {
            builder.put((Object)path.getPath(), (Object)path.build());
        }
        Map map = builder.build();
        if (map == null) {
            LogEntry.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    public Map<String, LogEntryPath> getChangedPaths() {
        Map<String, LogEntryPath> map = this.myChangedPaths;
        if (map == null) {
            LogEntry.$$$reportNull$$$0(3);
        }
        return map;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    @Nullable
    public Date getDate() {
        return this.myDate;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/LogEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/LogEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toImmutable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toImmutable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="logentry")
    public static class Builder {
        @XmlAttribute(name="revision")
        private long revision;
        @XmlElement(name="author")
        private String author;
        @XmlElement(name="date")
        private Date date;
        @XmlElement(name="msg")
        private String message;
        @XmlElementWrapper(name="paths")
        @XmlElement(name="path")
        private final List<LogEntryPath.Builder> changedPaths = new ArrayList<LogEntryPath.Builder>();
        @XmlElement(name="logentry")
        private final List<Builder> childEntries = new ArrayList<Builder>();

        @NotNull
        public List<Builder> getChildEntries() {
            List<Builder> list = this.childEntries;
            if (list == null) {
                Builder.$$$reportNull$$$0(0);
            }
            return list;
        }

        public boolean hasChildren() {
            return !this.childEntries.isEmpty();
        }

        @NotNull
        public Builder setRevision(long revision) {
            this.revision = revision;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setAuthor(String author) {
            this.author = author;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setDate(Date date) {
            this.date = date;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setMessage(String message) {
            this.message = message;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setHasChildren(boolean hasChildren) {
            this.childEntries.clear();
            if (hasChildren) {
                this.childEntries.add(this);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder addPath(@NotNull LogEntryPath.Builder path) {
            if (path == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.changedPaths.add(path);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public LogEntry build() {
            LogEntry logEntry = new LogEntry(this);
            if (logEntry == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return logEntry;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/history/LogEntry$Builder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildEntries";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAuthor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMessage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setHasChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/history/LogEntry$Builder";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addPath";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

