/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum ConflictReason {
    EDITED("edit", "edited"),
    OBSTRUCTED("obstruction", "obstruct", "obstructed"),
    DELETED("delete", "deleted"),
    MISSING("missing", "miss"),
    UNVERSIONED("unversioned", "unversion"),
    ADDED("add", "added"),
    REPLACED("replace", "replaced"),
    MOVED_AWAY("moved-away", new String[0]),
    MOVED_HERE("moved-here", new String[0]);

    @NotNull
    private static final Map<String, ConflictReason> ourAllReasons;
    @NotNull
    private final String myKey;
    @NotNull
    private final String[] myOtherKeys;

    private ConflictReason(String key, String ... otherKeys) {
        if (key == null) {
            ConflictReason.$$$reportNull$$$0(0);
        }
        if (otherKeys == null) {
            ConflictReason.$$$reportNull$$$0(1);
        }
        this.myKey = key;
        this.myOtherKeys = otherKeys;
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(@NotNull ConflictReason reason) {
        if (reason == null) {
            ConflictReason.$$$reportNull$$$0(2);
        }
        ourAllReasons.put(reason.myKey, reason);
        for (String key : reason.myOtherKeys) {
            ourAllReasons.put(key, reason);
        }
    }

    @NotNull
    public static ConflictReason from(@NotNull String reasonName) {
        ConflictReason result;
        if (reasonName == null) {
            ConflictReason.$$$reportNull$$$0(3);
        }
        if ((result = ourAllReasons.get(reasonName)) == null) {
            throw new IllegalArgumentException("Unknown conflict reason " + reasonName);
        }
        ConflictReason conflictReason = result;
        if (conflictReason == null) {
            ConflictReason.$$$reportNull$$$0(4);
        }
        return conflictReason;
    }

    static {
        ourAllReasons = new HashMap<String, ConflictReason>();
        for (ConflictReason reason : ConflictReason.values()) {
            ConflictReason.register(reason);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherKeys";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reasonName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/conflict/ConflictReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/conflict/ConflictReason";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

