/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopiesBuilder;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangeProviderContext;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnRecursiveStatusWalker;
import org.jetbrains.idea.svn.SvnScopeZipper;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangeProvider");
    public static final String PROPERTY_LAYER = "Property";
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final VcsContextFactory myFactory;
    @NotNull
    private final SvnFileUrlMappingImpl mySvnFileUrlMapping;

    public SvnChangeProvider(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnChangeProvider.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myFactory = VcsContextFactory.SERVICE.getInstance();
        this.mySvnFileUrlMapping = (SvnFileUrlMappingImpl)vcs.getSvnFileUrlMapping();
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            SvnChangeProvider.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            SvnChangeProvider.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            SvnChangeProvider.$$$reportNull$$$0(3);
        }
        if (addGate == null) {
            SvnChangeProvider.$$$reportNull$$$0(4);
        }
        SvnScopeZipper zipper = new SvnScopeZipper(dirtyScope);
        zipper.run();
        MultiMap<FilePath, FilePath> nonRecursiveMap = zipper.getNonRecursiveDirs();
        try {
            SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, progress);
            NestedCopiesBuilder nestedCopiesBuilder = new NestedCopiesBuilder(this.myVcs, this.mySvnFileUrlMapping);
            EventDispatcher statusReceiver = EventDispatcher.create(StatusReceiver.class);
            statusReceiver.addListener((EventListener)context);
            statusReceiver.addListener((EventListener)nestedCopiesBuilder);
            SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, (StatusReceiver)statusReceiver.getMulticaster(), progress);
            for (FilePath path : zipper.getRecursiveDirs()) {
                walker.go(path, Depth.INFINITY);
            }
            walker.setNonRecursiveScope(nonRecursiveMap);
            for (FilePath path : nonRecursiveMap.keySet()) {
                walker.go(path, Depth.IMMEDIATES);
            }
            ((StatusReceiver)statusReceiver.getMulticaster()).finish();
            this.processCopiedAndDeleted(context, dirtyScope);
            SvnChangeProvider.processUnsaved(dirtyScope, addGate, context);
            this.mySvnFileUrlMapping.acceptNestedData(nestedCopiesBuilder.getCopies());
        }
        catch (SvnExceptionWrapper e) {
            LOG.info((Throwable)e);
            throw new VcsException(e.getCause());
        }
    }

    private static void processUnsaved(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangeListManagerGate addGate, @NotNull SvnChangeProviderContext context) throws SvnBindException {
        if (dirtyScope == null) {
            SvnChangeProvider.$$$reportNull$$$0(5);
        }
        if (addGate == null) {
            SvnChangeProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SvnChangeProvider.$$$reportNull$$$0(7);
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : fileDocumentManager.getUnsavedDocuments()) {
            FileStatus status;
            VirtualFile file = fileDocumentManager.getFile(unsavedDocument);
            if (file == null || !dirtyScope.belongsTo(VcsUtil.getFilePath((VirtualFile)file)) || !fileDocumentManager.isFileModified(file) || (status = addGate.getStatus(file)) != null && !FileStatus.NOT_CHANGED.equals(status)) continue;
            context.addModifiedNotSavedChange(file);
        }
    }

    private void processCopiedAndDeleted(@NotNull SvnChangeProviderContext context, @Nullable VcsDirtyScope dirtyScope) throws SvnBindException {
        if (context == null) {
            SvnChangeProvider.$$$reportNull$$$0(8);
        }
        for (SvnChangedFile copiedFile : context.getCopiedFiles()) {
            context.checkCanceled();
            this.processCopiedFile(copiedFile, context, dirtyScope);
        }
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            context.checkCanceled();
            context.processStatus(deletedFile.getFilePath(), deletedFile.getStatus());
        }
    }

    public void getChanges(@NotNull FilePath path, boolean recursive, @NotNull ChangelistBuilder builder) throws SvnBindException {
        if (path == null) {
            SvnChangeProvider.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            SvnChangeProvider.$$$reportNull$$$0(10);
        }
        SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, null);
        SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, context, ProgressManager.getInstance().getProgressIndicator());
        walker.go(path, recursive ? Depth.INFINITY : Depth.IMMEDIATES);
        this.processCopiedAndDeleted(context, null);
    }

    private void processCopiedFile(@NotNull SvnChangedFile copiedFile, @NotNull SvnChangeProviderContext context, @Nullable VcsDirtyScope dirtyScope) throws SvnBindException {
        File file;
        if (copiedFile == null) {
            SvnChangeProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            SvnChangeProvider.$$$reportNull$$$0(12);
        }
        boolean foundRename = false;
        Status copiedStatus = copiedFile.getStatus();
        Url copyFromURL = (Url)ObjectUtils.notNull((Object)copiedFile.getCopyFromURL());
        HashSet<SvnChangedFile> deletedToDelete = new HashSet<SvnChangedFile>();
        for (SvnChangedFile svnChangedFile : context.getDeletedFiles()) {
            Status deletedStatus = svnChangedFile.getStatus();
            if (!Comparing.equal((Object)copyFromURL, (Object)deletedStatus.getUrl())) continue;
            String clName = SvnUtil.getChangelistName(copiedFile.getStatus());
            this.applyMovedChange(context, copiedFile.getFilePath(), dirtyScope, deletedToDelete, svnChangedFile, copiedStatus, clName);
            for (SvnChangedFile deletedChild : context.getDeletedFiles()) {
                Status childStatus = deletedChild.getStatus();
                Url childUrl = childStatus.getUrl();
                if (childUrl == null || !SvnUtil.isAncestor(copyFromURL, childUrl)) continue;
                String relativePath = SvnUtil.getRelativeUrl(copyFromURL, childUrl);
                File newPath = new File(copiedFile.getFilePath().getIOFile(), relativePath);
                FilePath newFilePath = this.myFactory.createFilePathOn(newPath);
                if (context.isDeleted(newFilePath)) continue;
                this.applyMovedChange(context, newFilePath, dirtyScope, deletedToDelete, deletedChild, context.getTreeConflictStatus(newPath), clName);
            }
            foundRename = true;
            break;
        }
        List<SvnChangedFile> deletedFiles = context.getDeletedFiles();
        for (SvnChangedFile file2 : deletedToDelete) {
            deletedFiles.remove(file2);
        }
        if (!foundRename && copiedStatus.getUrl() != null && (file = this.myVcs.getSvnFileUrlMapping().getLocalPath(copyFromURL)) != null) {
            Status status;
            try {
                status = this.myVcs.getFactory(file).createStatusClient().doStatus(file, false);
            }
            catch (SvnBindException ex) {
                LOG.info((Throwable)((Object)ex));
                status = null;
            }
            if (status != null && status.is(StatusType.STATUS_DELETED)) {
                FilePath filePath = this.myFactory.createFilePathOn(file, false);
                SvnContentRevision beforeRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, status.getRevision());
                ContentRevision afterRevision = CurrentContentRevision.create((FilePath)copiedFile.getFilePath());
                context.getBuilder().processChangeInList(context.createMovedChange(beforeRevision, afterRevision, copiedStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                foundRename = true;
            }
        }
        if (!foundRename) {
            LOG.info("Rename not found for " + copiedFile.getFilePath().getPresentableUrl());
            context.processStatus(copiedFile.getFilePath(), copiedStatus);
        }
    }

    private void applyMovedChange(@NotNull SvnChangeProviderContext context, @NotNull FilePath oldPath, @Nullable VcsDirtyScope dirtyScope, @NotNull Set<SvnChangedFile> deletedToDelete, @NotNull SvnChangedFile deletedFile, @Nullable Status copiedStatus, @Nullable String clName) throws SvnBindException {
        boolean isUnder;
        if (context == null) {
            SvnChangeProvider.$$$reportNull$$$0(13);
        }
        if (oldPath == null) {
            SvnChangeProvider.$$$reportNull$$$0(14);
        }
        if (deletedToDelete == null) {
            SvnChangeProvider.$$$reportNull$$$0(15);
        }
        if (deletedFile == null) {
            SvnChangeProvider.$$$reportNull$$$0(16);
        }
        Change change = context.createMovedChange(this.createBeforeRevision(deletedFile, true), CurrentContentRevision.create((FilePath)oldPath), copiedStatus, deletedFile.getStatus());
        boolean bl = isUnder = dirtyScope == null ? true : (Boolean)ReadAction.compute(() -> ChangeListManagerImpl.isUnder((Change)change, (VcsDirtyScope)dirtyScope));
        if (isUnder) {
            context.getBuilder().removeRegisteredChangeFor(oldPath);
            context.getBuilder().processChangeInList(change, clName, SvnVcs.getKey());
            deletedToDelete.add(deletedFile);
        }
    }

    @NotNull
    private SvnContentRevision createBeforeRevision(@NotNull SvnChangedFile changedFile, boolean forDeleted) {
        if (changedFile == null) {
            SvnChangeProvider.$$$reportNull$$$0(17);
        }
        Status status = changedFile.getStatus();
        FilePath path = changedFile.getFilePath();
        SvnContentRevision svnContentRevision = SvnContentRevision.createBaseRevision(this.myVcs, forDeleted ? VcsUtil.getFilePath((File)status.getFile(), (boolean)path.isDirectory()) : path, status.getRevision());
        if (svnContentRevision == null) {
            SvnChangeProvider.$$$reportNull$$$0(18);
        }
        return svnContentRevision;
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(@NotNull List<VirtualFile> files) {
        if (files == null) {
            SvnChangeProvider.$$$reportNull$$$0(19);
        }
        new CleanupWorker(this.myVcs, files).execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addGate";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedToDelete";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnChangeProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnChangeProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createBeforeRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUnsaved";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCopiedAndDeleted";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processCopiedFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyMovedChange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createBeforeRevision";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doCleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

