/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class NestedCopiesBuilder
implements StatusReceiver {
    @NotNull
    private final Set<NestedCopyInfo> myCopies;
    @NotNull
    private final SvnFileUrlMapping myMapping;
    @NotNull
    private final SvnVcs myVcs;

    public NestedCopiesBuilder(@NotNull SvnVcs vcs, @NotNull SvnFileUrlMapping mapping) {
        if (vcs == null) {
            NestedCopiesBuilder.$$$reportNull$$$0(0);
        }
        if (mapping == null) {
            NestedCopiesBuilder.$$$reportNull$$$0(1);
        }
        this.myVcs = vcs;
        this.myMapping = mapping;
        this.myCopies = new HashSet<NestedCopyInfo>();
    }

    @Override
    public void process(@NotNull FilePath path, Status status) {
        VirtualFile file;
        if (path == null) {
            NestedCopiesBuilder.$$$reportNull$$$0(2);
        }
        if ((file = path.getVirtualFile()) != null) {
            if (status.is(StatusType.STATUS_EXTERNAL)) {
                this.myCopies.add(new NestedCopyInfo(file, null, WorkingCopyFormat.UNKNOWN, NestedCopyType.external, null));
            } else if (status.getUrl() != null && !status.is(StatusType.STATUS_UNVERSIONED) && status.isSwitched()) {
                this.myCopies.add(new NestedCopyInfo(file, status.getUrl(), this.myVcs.getWorkingCopyFormat(path.getIOFile()), NestedCopyType.switched, status.getRepositoryRootUrl()));
            }
        }
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
    }

    @Override
    public void processCopyRoot(@NotNull VirtualFile file, @Nullable Url url, @NotNull WorkingCopyFormat format, @Nullable Url rootURL) {
        if (file == null) {
            NestedCopiesBuilder.$$$reportNull$$$0(3);
        }
        if (format == null) {
            NestedCopiesBuilder.$$$reportNull$$$0(4);
        }
        this.myCopies.add(new NestedCopyInfo(file, url, format, NestedCopyType.inner, rootURL));
    }

    @Override
    public void bewareRoot(@NotNull VirtualFile vf, Url url) {
        if (vf == null) {
            NestedCopiesBuilder.$$$reportNull$$$0(5);
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
        RootUrlInfo info2 = this.myMapping.getWcRootForFilePath(VcsUtil.getFilePath((VirtualFile)vf));
        if (info2 != null && FileUtil.filesEqual((File)ioFile, (File)info2.getIoFile()) && !info2.getUrl().equals(url)) {
            this.myVcs.invokeRefreshSvnRoots();
        }
    }

    @Override
    public void finish() {
    }

    @NotNull
    public Set<NestedCopyInfo> getCopies() {
        Set<NestedCopyInfo> set = this.myCopies;
        if (set == null) {
            NestedCopiesBuilder.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/NestedCopiesBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/NestedCopiesBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCopyRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bewareRoot";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

