/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLAnchor;

public class YAMLRenamePsiElementProcessor
extends RenamePsiElementProcessor {
    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        List anchorsTail;
        Optional<YAMLAnchor> postOpt;
        if (element == null) {
            YAMLRenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            YAMLRenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        if (conflicts == null) {
            YAMLRenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        assert (element instanceof YAMLAnchor);
        PsiFile file = element.getContainingFile();
        YAMLAnchor anchor = (YAMLAnchor)element;
        int start = anchor.getTextOffset();
        Collection uses = this.findReferences((PsiElement)anchor, anchor.getUseScope(), false);
        OptionalInt lastUsePosOpt = uses.stream().mapToInt(r -> r.getElement().getTextOffset()).max();
        int endOfScope = lastUsePosOpt.isPresent() ? lastUsePosOpt.getAsInt() : file.getTextLength();
        ArrayList allAnchors = new ArrayList(PsiTreeUtil.collectElementsOfType((PsiElement)file, (Class[])new Class[]{YAMLAnchor.class}));
        int idx = allAnchors.indexOf(anchor);
        if (idx == -1) {
            return;
        }
        Predicate<YAMLAnchor> hasNewName = a -> a.getName().equals(newName);
        Optional<YAMLAnchor> prevOpt = allAnchors.subList(0, idx).stream().filter(hasNewName).reduce((x1, x2) -> x2);
        if (prevOpt.isPresent()) {
            YAMLAnchor prev = prevOpt.get();
            this.findReferences((PsiElement)prev, prev.getUseScope(), false).stream().map(r -> r.getElement()).filter(alias -> start < alias.getTextOffset() && alias.getTextOffset() < endOfScope).forEach(alias -> conflicts.putValue(alias, (Object)YAMLBundle.message("YAMLAnchorRenameProcessor.lost.alias")));
            if (!conflicts.isEmpty()) {
                conflicts.putValue((Object)prev, (Object)YAMLBundle.message("YAMLAnchorRenameProcessor.reuse"));
            }
        }
        if ((postOpt = (anchorsTail = allAnchors.subList(idx + 1, allAnchors.size())).stream().filter(hasNewName).findFirst()).isPresent()) {
            YAMLAnchor post = postOpt.get();
            uses.stream().map(r -> r.getElement()).filter(alias -> post.getTextOffset() < alias.getTextOffset()).forEach(alias -> conflicts.putValue(alias, (Object)YAMLBundle.message("YAMLAnchorRenameProcessor.lost.alias")));
            if (lastUsePosOpt.isPresent()) {
                anchorsTail.stream().filter(hasNewName).filter(anc -> start < anc.getTextOffset() && anc.getTextOffset() < lastUsePosOpt.getAsInt()).forEach(anc -> conflicts.putValue(anc, (Object)YAMLBundle.message("YAMLAnchorRenameProcessor.reuse")));
            }
        }
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            YAMLRenamePsiElementProcessor.$$$reportNull$$$0(3);
        }
        return element instanceof YAMLAnchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/resolve/YAMLRenamePsiElementProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

