/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class QueueProcessor<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.concurrency.QueueProcessor");
    private final PairConsumer<? super T, ? super Runnable> myProcessor;
    private final Deque<T> myQueue;
    private boolean isProcessing;
    private boolean myStarted;
    private final ThreadToUse myThreadToUse;
    private final Condition<?> myDeathCondition;
    private final Map<Object, ModalityState> myModalityState;

    public QueueProcessor(@NotNull Consumer<? super T> processor) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(0);
        }
        this(processor, Conditions.alwaysFalse());
    }

    public QueueProcessor(@NotNull Consumer<? super T> processor, @NotNull Condition<?> deathCondition) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(1);
        }
        if (deathCondition == null) {
            QueueProcessor.$$$reportNull$$$0(2);
        }
        this(processor, deathCondition, true);
    }

    public QueueProcessor(@NotNull Consumer<? super T> processor, @NotNull Condition<?> deathCondition, boolean autostart) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(3);
        }
        if (deathCondition == null) {
            QueueProcessor.$$$reportNull$$$0(4);
        }
        this(QueueProcessor.wrappingProcessor(processor), autostart, ThreadToUse.POOLED, deathCondition);
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor() {
        QueueProcessor<Runnable> queueProcessor = new QueueProcessor<Runnable>(new RunnableConsumer());
        if (queueProcessor == null) {
            QueueProcessor.$$$reportNull$$$0(5);
        }
        return queueProcessor;
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor(ThreadToUse threadToUse) {
        QueueProcessor<Runnable> queueProcessor = new QueueProcessor<Runnable>(QueueProcessor.wrappingProcessor(new RunnableConsumer()), true, threadToUse, Conditions.FALSE);
        if (queueProcessor == null) {
            QueueProcessor.$$$reportNull$$$0(6);
        }
        return queueProcessor;
    }

    @NotNull
    private static <T> PairConsumer<T, Runnable> wrappingProcessor(@NotNull Consumer<? super T> processor) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(7);
        }
        PairConsumer pairConsumer = (item, continuation) -> {
            try (SilentAutoClosable ignored = continuation::run;){
                QueueProcessor.runSafely(() -> processor.consume(item));
            }
        };
        if (pairConsumer == null) {
            QueueProcessor.$$$reportNull$$$0(8);
        }
        return pairConsumer;
    }

    public QueueProcessor(@NotNull PairConsumer<? super T, ? super Runnable> processor, boolean autostart, @NotNull ThreadToUse threadToUse, @NotNull Condition<?> deathCondition) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(9);
        }
        if (threadToUse == null) {
            QueueProcessor.$$$reportNull$$$0(10);
        }
        if (deathCondition == null) {
            QueueProcessor.$$$reportNull$$$0(11);
        }
        this.myQueue = new ArrayDeque<T>();
        this.myModalityState = ContainerUtil.newIdentityTroveMap();
        this.myProcessor = processor;
        this.myStarted = autostart;
        this.myThreadToUse = threadToUse;
        this.myDeathCondition = deathCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            if (this.myStarted) {
                return;
            }
            this.myStarted = true;
            if (!this.myQueue.isEmpty()) {
                this.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcessing(boolean continueProcessing) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.isProcessing = false;
            if (this.myQueue.isEmpty()) {
                this.myQueue.notifyAll();
            } else if (continueProcessing) {
                this.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull T t, ModalityState state) {
        if (t == null) {
            QueueProcessor.$$$reportNull$$$0(12);
        }
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myModalityState.put(t, state);
        }
        this.doAdd(t, false);
    }

    public void add(@NotNull T element) {
        if (element == null) {
            QueueProcessor.$$$reportNull$$$0(13);
        }
        this.doAdd(element, false);
    }

    public void addFirst(@NotNull T element) {
        if (element == null) {
            QueueProcessor.$$$reportNull$$$0(14);
        }
        this.doAdd(element, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(@NotNull T element, boolean atHead) {
        if (element == null) {
            QueueProcessor.$$$reportNull$$$0(15);
        }
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            if (atHead) {
                this.myQueue.addFirst(element);
            } else {
                this.myQueue.add(element);
            }
            this.startProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            while (this.isProcessing) {
                try {
                    this.myQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitFor(long timeoutMS) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            long start = System.currentTimeMillis();
            while (this.isProcessing) {
                long rest = timeoutMS - (System.currentTimeMillis() - start);
                if (rest <= 0L) {
                    return !this.isProcessing;
                }
                try {
                    this.myQueue.wait(rest);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private void startProcessing() {
        LOG.assertTrue(Thread.holdsLock(this.myQueue));
        if (this.isProcessing || !this.myStarted) {
            return;
        }
        this.isProcessing = true;
        T item = this.myQueue.removeFirst();
        Runnable runnable = () -> {
            if (this.myDeathCondition.value(null)) {
                this.finishProcessing(false);
                return;
            }
            QueueProcessor.runSafely(() -> this.myProcessor.consume(item, () -> this.finishProcessing(true)));
        };
        Application application = ApplicationManager.getApplication();
        if (this.myThreadToUse == ThreadToUse.AWT) {
            ModalityState state = this.myModalityState.remove(item);
            if (state != null) {
                application.invokeLater(runnable, state);
            } else {
                application.invokeLater(runnable);
            }
        } else {
            application.executeOnPooledThread(runnable);
        }
    }

    public static void runSafely(@NotNull Runnable run) {
        if (run == null) {
            QueueProcessor.$$$reportNull$$$0(16);
        }
        try {
            run.run();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                LOG.error(e);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.isEmpty() && !this.isProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissLastTasks(int remaining) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            while (this.myQueue.size() > remaining) {
                this.myQueue.pollLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingItemsToProcess() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return !this.myQueue.isEmpty();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deathCondition";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/QueueProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "run";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/QueueProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunnableQueueProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "wrappingProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrappingProcessor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFirst";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doAdd";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runSafely";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RunnableConsumer
    implements Consumer<Runnable> {
        public void consume(Runnable runnable) {
            runnable.run();
        }
    }

    @FunctionalInterface
    protected static interface SilentAutoClosable
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static enum ThreadToUse {
        AWT,
        POOLED;

    }
}

