/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfigHelperKt;
import git4idea.repo.GitRemote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitConfig {
    private static final Logger LOG = Logger.getInstance(GitConfig.class);
    private static final Pattern REMOTE_SECTION = Pattern.compile("(?:svn-)?remote \"(.*)\"", 2);
    private static final Pattern URL_SECTION = Pattern.compile("url \"(.*)\"", 2);
    private static final Pattern BRANCH_INFO_SECTION = Pattern.compile("branch \"(.*)\"", 2);
    private static final Pattern BRANCH_COMMON_PARAMS_SECTION = Pattern.compile("branch", 2);
    @NotNull
    private final Collection<? extends Remote> myRemotes;
    @NotNull
    private final Collection<? extends Url> myUrls;
    @NotNull
    private final Collection<? extends BranchConfig> myTrackedInfos;

    private GitConfig(@NotNull Collection<? extends Remote> remotes, @NotNull Collection<? extends Url> urls, @NotNull Collection<? extends BranchConfig> trackedInfos) {
        if (remotes == null) {
            GitConfig.$$$reportNull$$$0(0);
        }
        if (urls == null) {
            GitConfig.$$$reportNull$$$0(1);
        }
        if (trackedInfos == null) {
            GitConfig.$$$reportNull$$$0(2);
        }
        this.myRemotes = remotes;
        this.myUrls = urls;
        this.myTrackedInfos = trackedInfos;
    }

    @NotNull
    Collection<GitRemote> parseRemotes() {
        List list = ((StreamEx)StreamEx.of(this.myRemotes).map(remote -> GitConfig.convertRemoteToGitRemote(this.myUrls, remote)).filter(remote -> !remote.getUrls().isEmpty())).toList();
        if (list == null) {
            GitConfig.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static GitRemote convertRemoteToGitRemote(@NotNull Collection<? extends Url> urls, @NotNull Remote remote) {
        if (urls == null) {
            GitConfig.$$$reportNull$$$0(4);
        }
        if (remote == null) {
            GitConfig.$$$reportNull$$$0(5);
        }
        UrlsAndPushUrls substitutedUrls = GitConfig.substituteUrls(urls, remote);
        GitRemote gitRemote = new GitRemote(remote.myName, substitutedUrls.getUrls(), substitutedUrls.getPushUrls(), remote.getFetchSpecs(), remote.getPushSpec());
        if (gitRemote == null) {
            GitConfig.$$$reportNull$$$0(6);
        }
        return gitRemote;
    }

    @NotNull
    Collection<GitBranchTrackInfo> parseTrackInfos(@NotNull Collection<? extends GitLocalBranch> localBranches, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (localBranches == null) {
            GitConfig.$$$reportNull$$$0(7);
        }
        if (remoteBranches == null) {
            GitConfig.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.mapNotNull(this.myTrackedInfos, config -> GitConfig.convertBranchConfig(config, localBranches, remoteBranches));
        if (list == null) {
            GitConfig.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    static GitConfig read(@NotNull File configFile) {
        Ini ini;
        if (configFile == null) {
            GitConfig.$$$reportNull$$$0(10);
        }
        GitConfig emptyConfig = new GitConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        if (!configFile.exists()) {
            LOG.info("No .git/config file at " + configFile.getPath());
            GitConfig gitConfig = emptyConfig;
            if (gitConfig == null) {
                GitConfig.$$$reportNull$$$0(11);
            }
            return gitConfig;
        }
        try {
            ini = GitConfigHelperKt.loadIniFile(configFile);
        }
        catch (IOException e) {
            GitConfig gitConfig = emptyConfig;
            if (gitConfig == null) {
                GitConfig.$$$reportNull$$$0(12);
            }
            return gitConfig;
        }
        ClassLoader classLoader = GitConfigHelperKt.findClassLoader();
        Pair<Collection<Remote>, Collection<Url>> remotesAndUrls = GitConfig.parseRemotes(ini, classLoader);
        Collection<BranchConfig> trackedInfos = GitConfig.parseTrackedInfos(ini, classLoader);
        GitConfig gitConfig = new GitConfig((Collection)remotesAndUrls.getFirst(), (Collection)remotesAndUrls.getSecond(), trackedInfos);
        if (gitConfig == null) {
            GitConfig.$$$reportNull$$$0(13);
        }
        return gitConfig;
    }

    @NotNull
    private static Collection<BranchConfig> parseTrackedInfos(@NotNull Ini ini, @Nullable ClassLoader classLoader) {
        if (ini == null) {
            GitConfig.$$$reportNull$$$0(14);
        }
        ArrayList<BranchConfig> configs = new ArrayList<BranchConfig>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            BranchConfig branchConfig;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (!StringUtil.startsWithIgnoreCase((String)sectionName, (String)"branch") || (branchConfig = GitConfig.parseBranchSection(sectionName, section, classLoader)) == null) continue;
            configs.add(branchConfig);
        }
        ArrayList<BranchConfig> arrayList = configs;
        if (arrayList == null) {
            GitConfig.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static GitBranchTrackInfo convertBranchConfig(@Nullable BranchConfig branchConfig, @NotNull Collection<? extends GitLocalBranch> localBranches, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (localBranches == null) {
            GitConfig.$$$reportNull$$$0(16);
        }
        if (remoteBranches == null) {
            GitConfig.$$$reportNull$$$0(17);
        }
        if (branchConfig == null) {
            return null;
        }
        String branchName = branchConfig.getName();
        String remoteName = branchConfig.getBean().getRemote();
        String mergeName = branchConfig.getBean().getMerge();
        String rebaseName = branchConfig.getBean().getRebase();
        if (StringUtil.isEmptyOrSpaces((String)mergeName) && StringUtil.isEmptyOrSpaces((String)rebaseName)) {
            LOG.debug("No branch." + branchName + ".merge/rebase item in the .git/config");
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)remoteName)) {
            LOG.debug("No branch." + branchName + ".remote item in the .git/config");
            return null;
        }
        boolean merge = mergeName != null;
        String remoteBranchName = StringUtil.unquoteString((String)(merge ? mergeName : rebaseName));
        GitLocalBranch localBranch = GitConfig.findLocalBranch(branchName, localBranches);
        GitRemoteBranch remoteBranch = GitConfig.findRemoteBranch(remoteBranchName, remoteName, remoteBranches);
        if (localBranch == null || remoteBranch == null) {
            LOG.debug("localBranch: " + localBranch + ", remoteBranch: " + remoteBranch);
            return null;
        }
        return new GitBranchTrackInfo(localBranch, remoteBranch, merge);
    }

    @Nullable
    private static GitLocalBranch findLocalBranch(@NotNull String branchName, @NotNull Collection<? extends GitLocalBranch> localBranches) {
        if (branchName == null) {
            GitConfig.$$$reportNull$$$0(18);
        }
        if (localBranches == null) {
            GitConfig.$$$reportNull$$$0(19);
        }
        String name = GitBranchUtil.stripRefsPrefix(branchName);
        return (GitLocalBranch)ContainerUtil.find(localBranches, input -> input.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull String remoteBranchName, @NotNull String remoteName, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (remoteBranchName == null) {
            GitConfig.$$$reportNull$$$0(20);
        }
        if (remoteName == null) {
            GitConfig.$$$reportNull$$$0(21);
        }
        if (remoteBranches == null) {
            GitConfig.$$$reportNull$$$0(22);
        }
        String branchName = GitBranchUtil.stripRefsPrefix(remoteBranchName);
        return (GitRemoteBranch)ContainerUtil.find(remoteBranches, branch -> branch.getNameForRemoteOperations().equals(branchName) && branch.getRemote().getName().equals(remoteName));
    }

    @Nullable
    private static BranchConfig parseBranchSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        if (sectionName == null) {
            GitConfig.$$$reportNull$$$0(23);
        }
        if (section == null) {
            GitConfig.$$$reportNull$$$0(24);
        }
        BranchBean branchBean = (BranchBean)section.as(BranchBean.class, classLoader);
        Matcher matcher = BRANCH_INFO_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new BranchConfig(matcher.group(1), branchBean);
        }
        if (BRANCH_COMMON_PARAMS_SECTION.matcher(sectionName).matches()) {
            LOG.debug(String.format("Common branch option(s) defined .git/config. sectionName: %s%n section: %s", sectionName, section));
            return null;
        }
        LOG.error(String.format("Invalid branch section format in .git/config. sectionName: %s%n section: %s", sectionName, section));
        return null;
    }

    @NotNull
    private static Pair<Collection<Remote>, Collection<Url>> parseRemotes(@NotNull Ini ini, @Nullable ClassLoader classLoader) {
        if (ini == null) {
            GitConfig.$$$reportNull$$$0(25);
        }
        ArrayList<Remote> remotes = new ArrayList<Remote>();
        ArrayList<Url> urls = new ArrayList<Url>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            Profile.Section section;
            String sectionName = (String)stringSectionEntry.getKey();
            Remote remote = GitConfig.parseRemoteSection(sectionName, section = (Profile.Section)stringSectionEntry.getValue(), classLoader);
            if (remote != null) {
                remotes.add(remote);
                continue;
            }
            Url url = GitConfig.parseUrlSection(sectionName, section, classLoader);
            if (url == null) continue;
            urls.add(url);
        }
        Pair pair = Pair.create(remotes, urls);
        if (pair == null) {
            GitConfig.$$$reportNull$$$0(26);
        }
        return pair;
    }

    @NotNull
    private static UrlsAndPushUrls substituteUrls(@NotNull Collection<? extends Url> urlSections, @NotNull Remote remote) {
        String insteadOf;
        boolean substituted;
        if (urlSections == null) {
            GitConfig.$$$reportNull$$$0(27);
        }
        if (remote == null) {
            GitConfig.$$$reportNull$$$0(28);
        }
        ArrayList<String> urls = new ArrayList<String>(remote.getUrls().size());
        ArrayList<String> pushUrls = new ArrayList<String>();
        for (String remoteUrl : remote.getUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                String pushInsteadOf = url.getPushInsteadOf();
                if (insteadOf != null && remoteUrl.startsWith(insteadOf)) {
                    urls.add(GitConfig.substituteUrl(remoteUrl, url, insteadOf));
                    substituted = true;
                    break;
                }
                if (pushInsteadOf == null || !remoteUrl.startsWith(pushInsteadOf)) continue;
                if (remote.getPushUrls().isEmpty()) {
                    pushUrls.add(GitConfig.substituteUrl(remoteUrl, url, pushInsteadOf));
                }
                urls.add(remoteUrl);
                substituted = true;
                break;
            }
            if (substituted) continue;
            urls.add(remoteUrl);
        }
        for (String remotePushUrl : remote.getPushUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                if (insteadOf == null || !remotePushUrl.startsWith(insteadOf)) continue;
                pushUrls.add(GitConfig.substituteUrl(remotePushUrl, url, insteadOf));
                substituted = true;
                break;
            }
            if (substituted) continue;
            pushUrls.add(remotePushUrl);
        }
        if (pushUrls.isEmpty()) {
            pushUrls = new ArrayList(urls);
        }
        UrlsAndPushUrls urlsAndPushUrls = new UrlsAndPushUrls(urls, pushUrls);
        if (urlsAndPushUrls == null) {
            GitConfig.$$$reportNull$$$0(29);
        }
        return urlsAndPushUrls;
    }

    @NotNull
    private static String substituteUrl(@NotNull String remoteUrl, @NotNull Url url, @NotNull String insteadOf) {
        if (remoteUrl == null) {
            GitConfig.$$$reportNull$$$0(30);
        }
        if (url == null) {
            GitConfig.$$$reportNull$$$0(31);
        }
        if (insteadOf == null) {
            GitConfig.$$$reportNull$$$0(32);
        }
        String string = url.myName + remoteUrl.substring(insteadOf.length());
        if (string == null) {
            GitConfig.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    private static Remote parseRemoteSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        Matcher matcher;
        if (sectionName == null) {
            GitConfig.$$$reportNull$$$0(34);
        }
        if (section == null) {
            GitConfig.$$$reportNull$$$0(35);
        }
        if ((matcher = REMOTE_SECTION.matcher(sectionName)).matches() && matcher.groupCount() == 1) {
            return new Remote(matcher.group(1), (RemoteBean)section.as(RemoteBean.class, classLoader));
        }
        return null;
    }

    @Nullable
    private static Url parseUrlSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        Matcher matcher;
        if (sectionName == null) {
            GitConfig.$$$reportNull$$$0(36);
        }
        if (section == null) {
            GitConfig.$$$reportNull$$$0(37);
        }
        if ((matcher = URL_SECTION.matcher(sectionName)).matches() && matcher.groupCount() == 1) {
            return new Url(matcher.group(1), (UrlBean)section.as(UrlBean.class, classLoader));
        }
        return null;
    }

    @NotNull
    private static String[] notNull(@Nullable String[] s) {
        String[] stringArray = s == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : s;
        if (stringArray == null) {
            GitConfig.$$$reportNull$$$0(38);
        }
        return stringArray;
    }

    @NotNull
    private static Collection<String> nonNullCollection(@Nullable String[] array) {
        ArrayList<String> arrayList = array == null ? Collections.emptyList() : new ArrayList<String>(Arrays.asList(array));
        if (arrayList == null) {
            GitConfig.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackedInfos";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitConfig";
                break;
            }
            case 5: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 7: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 8: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ini";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranchName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 23: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 24: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlSections";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insteadOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitConfig";
                break;
            }
            case 3: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRemotes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRemoteToGitRemote";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTrackInfos";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTrackedInfos";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteUrls";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteUrl";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "nonNullCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 39: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertRemoteToGitRemote";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseTrackInfos";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseTrackedInfos";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertBranchConfig";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBranch";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseBranchSection";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseRemotes";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "substituteUrls";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "substituteUrl";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parseRemoteSection";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseUrlSection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface BranchBean {
        @Nullable
        public String getRemote();

        @Nullable
        public String getMerge();

        @Nullable
        public String getRebase();
    }

    private static class BranchConfig {
        private final String myName;
        private final BranchBean myBean;

        BranchConfig(String name, BranchBean bean) {
            this.myName = name;
            this.myBean = bean;
        }

        public String getName() {
            return this.myName;
        }

        public BranchBean getBean() {
            return this.myBean;
        }
    }

    private static interface UrlBean {
        @Nullable
        public String getInsteadof();

        @Nullable
        public String getPushinsteadof();
    }

    private static class Url {
        private final String myName;
        private final UrlBean myUrlBean;

        private Url(String name, UrlBean urlBean) {
            this.myUrlBean = urlBean;
            this.myName = name;
        }

        @Nullable
        public String getInsteadOf() {
            return this.myUrlBean.getInsteadof();
        }

        @Nullable
        public String getPushInsteadOf() {
            return this.myUrlBean.getPushinsteadof();
        }
    }

    private static interface RemoteBean {
        @Nullable
        public String[] getFetch();

        @Nullable
        public String[] getPush();

        @Nullable
        public String[] getUrl();

        @Nullable
        public String[] getPushurl();
    }

    private static class Remote {
        private final String myName;
        private final RemoteBean myRemoteBean;

        private Remote(@NotNull String name, @NotNull RemoteBean remoteBean) {
            if (name == null) {
                Remote.$$$reportNull$$$0(0);
            }
            if (remoteBean == null) {
                Remote.$$$reportNull$$$0(1);
            }
            this.myRemoteBean = remoteBean;
            this.myName = name;
        }

        @NotNull
        private Collection<String> getUrls() {
            Collection collection = GitConfig.nonNullCollection(this.myRemoteBean.getUrl());
            if (collection == null) {
                Remote.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        private Collection<String> getPushUrls() {
            Collection collection = GitConfig.nonNullCollection(this.myRemoteBean.getPushurl());
            if (collection == null) {
                Remote.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        private List<String> getPushSpec() {
            String[] push = this.myRemoteBean.getPush();
            List<Object> list = push == null ? Collections.emptyList() : Arrays.asList(push);
            if (list == null) {
                Remote.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private List<String> getFetchSpecs() {
            List<String> list = Arrays.asList(GitConfig.notNull(this.myRemoteBean.getFetch()));
            if (list == null) {
                Remote.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteBean";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/repo/GitConfig$Remote";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/repo/GitConfig$Remote";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPushUrls";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPushSpec";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFetchSpecs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UrlsAndPushUrls {
        final List<String> myUrls;
        final Collection<String> myPushUrls;

        private UrlsAndPushUrls(List<String> urls, Collection<String> pushUrls) {
            this.myPushUrls = pushUrls;
            this.myUrls = urls;
        }

        public Collection<String> getPushUrls() {
            return this.myPushUrls;
        }

        public List<String> getUrls() {
            return this.myUrls;
        }
    }
}

