/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerAuthenticationManager;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitImplBase
implements Git {
    private static final Logger LOG = Logger.getInstance(GitImplBase.class);
    public static final String REMOTE_PROGRESS_PREFIX = "remote: ";
    public static final String[] PROGRESS_INDICATORS = new String[]{"Counting objects:", "Compressing objects:", "Writing objects:", "Receiving objects:", "Resolving deltas:"};
    public static final String[] ERROR_INDICATORS = new String[]{"warning:", "error:", "fatal:", "remote: error", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable", "The file will have its original", "runnerw:"};

    GitImplBase() {
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(0);
        }
        GitCommandResult gitCommandResult = this.run(handler, GitImplBase.getCollectingCollector());
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(1);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<? extends GitLineHandler> handlerConstructor) {
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(2);
        }
        GitCommandResult gitCommandResult = this.run(handlerConstructor, (Computable<? extends OutputCollector>)((Computable)GitImplBase::getCollectingCollector));
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(3);
        }
        return gitCommandResult;
    }

    @NotNull
    private static OutputCollector getCollectingCollector() {
        OutputCollector outputCollector = new OutputCollector(){

            @Override
            public void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.addOutputLine(line);
            }

            @Override
            public void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (Registry.is((String)"git.allow.stderr.to.stdout.mixing") && !GitImplBase.looksLikeError(line)) {
                    this.addOutputLine(line);
                } else {
                    this.addErrorLine(line);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (outputCollector == null) {
            GitImplBase.$$$reportNull$$$0(4);
        }
        return outputCollector;
    }

    @Override
    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(5);
        }
        GitCommandResult gitCommandResult = this.run(handler, new OutputCollector(){

            @Override
            protected void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            protected void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.addErrorLine(line);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(6);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult run(@NotNull Computable<? extends GitLineHandler> handlerConstructor, @NotNull Computable<? extends OutputCollector> outputCollectorConstructor) {
        GitCommandResult result2;
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(7);
        }
        if (outputCollectorConstructor == null) {
            GitImplBase.$$$reportNull$$$0(8);
        }
        int authAttempt = 0;
        do {
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            OutputCollector outputCollector = (OutputCollector)outputCollectorConstructor.compute();
            boolean isCredHelperUsed = GitVcsApplicationSettings.getInstance().isUseCredentialHelper();
            result2 = this.run(handler, outputCollector);
            if (isCredHelperUsed != GitVcsApplicationSettings.getInstance().isUseCredentialHelper()) continue;
            ++authAttempt;
        } while (result2.isAuthenticationFailed() && authAttempt < 2);
        GitCommandResult gitCommandResult = result2;
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(9);
        }
        return gitCommandResult;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private GitCommandResult run(@NotNull GitLineHandler handler, @NotNull OutputCollector outputCollector) {
        GitVersion version;
        block27: {
            GitCommandResult gitCommandResult;
            Throwable throwable;
            GitHandlerAuthenticationManager authenticationManager;
            block25: {
                block26: {
                    Project project;
                    if (handler == null) {
                        GitImplBase.$$$reportNull$$$0(10);
                    }
                    if (outputCollector == null) {
                        GitImplBase.$$$reportNull$$$0(11);
                    }
                    version = GitVersion.NULL;
                    if (handler.isPreValidateExecutable()) {
                        String executablePath = handler.getExecutablePath();
                        try {
                            version = GitExecutableManager.getInstance().identifyVersion(executablePath);
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            GitCommandResult gitCommandResult2 = GitImplBase.handlePreValidationException(handler.project(), e);
                            if (gitCommandResult2 == null) {
                                GitImplBase.$$$reportNull$$$0(12);
                            }
                            return gitCommandResult2;
                        }
                    }
                    if ((project = handler.project()) != null && project.isDisposed()) {
                        LOG.warn("Project has already been disposed");
                        throw new ProcessCanceledException();
                    }
                    if (project == null) break block27;
                    authenticationManager = GitHandlerAuthenticationManager.prepare(project, handler, version);
                    throwable = null;
                    GitCommandResult result2 = GitImplBase.doRun(handler, version, outputCollector);
                    gitCommandResult = GitCommandResult.withAuthentication(result2, authenticationManager.isHttpAuthFailed());
                    if (authenticationManager == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        authenticationManager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block25;
                }
                authenticationManager.close();
            }
            GitCommandResult gitCommandResult3 = gitCommandResult;
            if (gitCommandResult3 == null) {
                GitImplBase.$$$reportNull$$$0(13);
            }
            return gitCommandResult3;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (authenticationManager != null) {
                                if (throwable != null) {
                                    try {
                                        authenticationManager.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    authenticationManager.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        GitCommandResult gitCommandResult4 = GitCommandResult.startError("Failed to start Git process " + e.getLocalizedMessage());
                        if (gitCommandResult4 == null) {
                            GitImplBase.$$$reportNull$$$0(14);
                        }
                        return gitCommandResult4;
                    }
                }
            }
        }
        GitCommandResult gitCommandResult = GitImplBase.doRun(handler, version, outputCollector);
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(15);
        }
        return gitCommandResult;
    }

    @NotNull
    private static GitCommandResult doRun(@NotNull GitLineHandler handler, @NotNull GitVersion version, @NotNull OutputCollector outputCollector) {
        boolean canSuppressOptionalLocks;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(16);
        }
        if (version == null) {
            GitImplBase.$$$reportNull$$$0(17);
        }
        if (outputCollector == null) {
            GitImplBase.$$$reportNull$$$0(18);
        }
        GitImplBase.getGitTraceEnvironmentVariables(version).forEach(handler::addCustomEnvironmentVariable);
        boolean bl = canSuppressOptionalLocks = Registry.is((String)"git.use.no.optional.locks") && GitVersionSpecialty.ENV_GIT_OPTIONAL_LOCKS_ALLOWED.existsIn(version);
        if (canSuppressOptionalLocks) {
            handler.addCustomEnvironmentVariable("GIT_OPTIONAL_LOCKS", "0");
        }
        GitCommandResultListener resultListener = new GitCommandResultListener(outputCollector);
        handler.addLineListener(resultListener);
        try (AccessToken ignored = GitImplBase.lock(handler);){
            GitImplBase.writeOutputToConsole(handler);
            handler.runInCurrentThread();
        }
        catch (IOException e) {
            GitCommandResult gitCommandResult = GitCommandResult.error("Error processing input stream: " + e.getLocalizedMessage());
            if (gitCommandResult == null) {
                GitImplBase.$$$reportNull$$$0(19);
            }
            return gitCommandResult;
        }
        GitCommandResult gitCommandResult = new GitCommandResult(resultListener.myStartFailed, resultListener.myExitCode, outputCollector.myErrorOutput, outputCollector.myOutput);
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(20);
        }
        return gitCommandResult;
    }

    @NotNull
    public static Map<String, String> getGitTraceEnvironmentVariables(@NotNull GitVersion version) {
        if (version == null) {
            GitImplBase.$$$reportNull$$$0(21);
        }
        HashMap<String, String> environment = new HashMap<String, String>(5);
        environment.put("GIT_TRACE", "0");
        if (GitVersionSpecialty.ENV_GIT_TRACE_PACK_ACCESS_ALLOWED.existsIn(version)) {
            environment.put("GIT_TRACE_PACK_ACCESS", "");
        }
        environment.put("GIT_TRACE_PACKET", "");
        environment.put("GIT_TRACE_PERFORMANCE", "0");
        environment.put("GIT_TRACE_SETUP", "0");
        HashMap<String, String> hashMap = environment;
        if (hashMap == null) {
            GitImplBase.$$$reportNull$$$0(22);
        }
        return hashMap;
    }

    @NotNull
    private static GitCommandResult handlePreValidationException(@Nullable Project project, @NotNull Exception e) {
        if (e == null) {
            GitImplBase.$$$reportNull$$$0(23);
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (project != null && progressIndicator != null && !progressIndicator.getModalityState().dominates(ModalityState.NON_MODAL)) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            throw new ProcessCanceledException((Throwable)e);
        }
        GitCommandResult gitCommandResult = GitCommandResult.startError(GitBundle.getString("git.executable.validation.error.start.title") + ": \n" + GitExecutableProblemsNotifier.getPrettyErrorMessage(e));
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(24);
        }
        return gitCommandResult;
    }

    private static void writeOutputToConsole(final @NotNull GitLineHandler handler) {
        Project project;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(25);
        }
        if ((project = handler.project()) != null && !project.isDefault()) {
            final GitVcsConsoleWriter vcsConsoleWriter = GitVcsConsoleWriter.getInstance(project);
            handler.addLineListener(new GitLineHandlerListener(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (!handler.isSilent() && !StringUtil.isEmptyOrSpaces((String)line)) {
                        if (outputType == ProcessOutputTypes.STDOUT && !handler.isStdoutSuppressed()) {
                            vcsConsoleWriter.showMessage(line);
                        } else if (outputType == ProcessOutputTypes.STDERR && !handler.isStderrSuppressed() && !GitImplBase.looksLikeProgress(line)) {
                            vcsConsoleWriter.showErrorMessage(line);
                        }
                    }
                }
            });
            if (!handler.isSilent()) {
                vcsConsoleWriter.showCommandLine("[" + GitImplBase.stringifyWorkingDir(project.getBasePath(), handler.getWorkingDirectory()) + "] " + handler.printableCommandLine());
            }
        }
    }

    @NotNull
    private static AccessToken lock(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(26);
        }
        Project project = handler.project();
        GitCommand.LockingPolicy lockingPolicy = handler.getCommand().lockingPolicy();
        if (project == null || project.isDefault() || lockingPolicy == GitCommand.LockingPolicy.READ) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                GitImplBase.$$$reportNull$$$0(27);
            }
            return accessToken;
        }
        final ReadWriteLock executionLock = GitVcs.getInstance(project).getCommandLock();
        executionLock.writeLock().lock();
        AccessToken accessToken = new AccessToken(){

            public void finish() {
                executionLock.writeLock().unlock();
            }
        };
        if (accessToken == null) {
            GitImplBase.$$$reportNull$$$0(28);
        }
        return accessToken;
    }

    private static boolean looksLikeProgress(@NotNull String line) {
        if (line == null) {
            GitImplBase.$$$reportNull$$$0(29);
        }
        String trimmed = StringUtil.trimStart((String)line, (String)REMOTE_PROGRESS_PREFIX);
        return ContainerUtil.exists((Object[])PROGRESS_INDICATORS, indicator -> StringUtil.startsWith((CharSequence)trimmed, (CharSequence)indicator));
    }

    private static boolean looksLikeError(@NotNull String text) {
        if (text == null) {
            GitImplBase.$$$reportNull$$$0(30);
        }
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, indicator -> StringUtil.startsWithIgnoreCase((String)text.trim(), (String)indicator));
    }

    @NotNull
    static String stringifyWorkingDir(@Nullable String basePath, @NotNull File workingDir) {
        if (workingDir == null) {
            GitImplBase.$$$reportNull$$$0(31);
        }
        if (basePath != null) {
            String relPath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemIndependentName((String)workingDir.getPath()), (char)'/');
            if (".".equals(relPath)) {
                String string = workingDir.getName();
                if (string == null) {
                    GitImplBase.$$$reportNull$$$0(32);
                }
                return string;
            }
            if (relPath != null) {
                String string = FileUtil.toSystemDependentName((String)relPath);
                if (string == null) {
                    GitImplBase.$$$reportNull$$$0(33);
                }
                return string;
            }
        }
        String string = workingDir.getPath();
        if (string == null) {
            GitImplBase.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImplBase";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerConstructor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollectorConstructor";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollector";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImplBase";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectingCollector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommandWithoutCollectingOutput";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitTraceEnvironmentVariables";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "handlePreValidationException";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "lock";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runCommandWithoutCollectingOutput";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getGitTraceEnvironmentVariables";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "handlePreValidationException";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeOutputToConsole";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeProgress";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeError";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "stringifyWorkingDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class OutputCollector {
        final List<String> myOutput = new ArrayList<String>();
        final List<String> myErrorOutput = new ArrayList<String>();

        private OutputCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addOutputLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(0);
            }
            List<String> list = this.myOutput;
            synchronized (list) {
                this.myOutput.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addErrorLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(1);
            }
            List<String> list = this.myErrorOutput;
            synchronized (list) {
                this.myErrorOutput.add(line);
            }
        }

        abstract void outputLineReceived(@NotNull String var1);

        abstract void errorLineReceived(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "line";
            objectArray2[1] = "git4idea/commands/GitImplBase$OutputCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOutputLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addErrorLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GitCommandResultListener
    implements GitLineHandlerListener {
        private final OutputCollector myOutputCollector;
        private int myExitCode = 0;
        private boolean myStartFailed = false;

        GitCommandResultListener(OutputCollector outputCollector) {
            this.myOutputCollector = outputCollector;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOutputCollector.outputLineReceived(line);
            } else if (outputType == ProcessOutputTypes.STDERR && !GitImplBase.looksLikeProgress(line)) {
                this.myOutputCollector.errorLineReceived(line);
            }
        }

        public void processTerminated(int code) {
            this.myExitCode = code;
        }

        public void startFailed(@NotNull Throwable t) {
            if (t == null) {
                GitCommandResultListener.$$$reportNull$$$0(0);
            }
            this.myStartFailed = true;
            this.myOutputCollector.errorLineReceived("Failed to start Git process " + t.getLocalizedMessage());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "git4idea/commands/GitImplBase$GitCommandResultListener", "startFailed"));
        }
    }
}

