/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.config.GitVcsSettings;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitUserNameNotDefinedDialog
extends DialogWrapper {
    @NotNull
    private final Collection<? extends VirtualFile> myRootsWithUndefinedProps;
    @NotNull
    private final Collection<? extends VirtualFile> myAllRootsAffectedByCommit;
    @Nullable
    private final Couple<String> myProposedValues;
    @NotNull
    private final GitVcsSettings mySettings;
    private JTextField myNameTextField;
    private JTextField myEmailTextField;
    private JBCheckBox myGlobalCheckbox;

    GitUserNameNotDefinedDialog(@NotNull Project project, @NotNull Collection<? extends VirtualFile> rootsWithUndefinedProps, @NotNull Collection<? extends VirtualFile> allRootsAffectedByCommit, @NotNull Map<VirtualFile, Couple<String>> rootsWithDefinedProps) {
        if (project == null) {
            GitUserNameNotDefinedDialog.$$$reportNull$$$0(0);
        }
        if (rootsWithUndefinedProps == null) {
            GitUserNameNotDefinedDialog.$$$reportNull$$$0(1);
        }
        if (allRootsAffectedByCommit == null) {
            GitUserNameNotDefinedDialog.$$$reportNull$$$0(2);
        }
        if (rootsWithDefinedProps == null) {
            GitUserNameNotDefinedDialog.$$$reportNull$$$0(3);
        }
        super(project, false);
        this.myRootsWithUndefinedProps = rootsWithUndefinedProps;
        this.myAllRootsAffectedByCommit = allRootsAffectedByCommit;
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myProposedValues = GitUserNameNotDefinedDialog.calcProposedValues(rootsWithDefinedProps);
        this.setTitle("Git User Name Is Not Defined");
        this.setOKButtonText("Set and Commit");
        this.init();
    }

    protected ValidationInfo doValidate() {
        String message = "You have to specify user name and email for Git";
        if (StringUtil.isEmptyOrSpaces((String)this.getUserName())) {
            return new ValidationInfo(message, (JComponent)this.myNameTextField);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getUserEmail())) {
            return new ValidationInfo(message, (JComponent)this.myEmailTextField);
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    @Nullable
    private static Couple<String> calcProposedValues(Map<VirtualFile, Couple<String>> rootsWithDefinedProps) {
        if (rootsWithDefinedProps.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<VirtualFile, Couple<String>>> iterator = rootsWithDefinedProps.entrySet().iterator();
        Couple<String> firstValue = iterator.next().getValue();
        while (iterator.hasNext()) {
            if (firstValue.equals(iterator.next().getValue())) continue;
            return null;
        }
        return firstValue;
    }

    protected JComponent createCenterPanel() {
        JLabel icon = new JLabel(UIUtil.getWarningIcon(), 2);
        JLabel description = new JLabel(this.getMessageText());
        this.myNameTextField = new JTextField(20);
        JBLabel nameLabel = new JBLabel("Name: ");
        nameLabel.setDisplayedMnemonic('n');
        nameLabel.setLabelFor((Component)this.myNameTextField);
        this.myEmailTextField = new JTextField(20);
        JBLabel emailLabel = new JBLabel("E-mail: ");
        emailLabel.setDisplayedMnemonic('e');
        emailLabel.setLabelFor((Component)this.myEmailTextField);
        if (this.myProposedValues != null) {
            this.myNameTextField.setText((String)this.myProposedValues.getFirst());
            this.myEmailTextField.setText((String)this.myProposedValues.getSecond());
        } else {
            this.myNameTextField.setText(SystemProperties.getUserName());
        }
        this.myGlobalCheckbox = new JBCheckBox("Set properties globally", this.mySettings.shouldSetUserNameGlobally());
        this.myGlobalCheckbox.setMnemonic('g');
        JPanel rootPanel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultInsets(new Insets(0, 0, 4, 10)).setDefaultAnchor(21).setDefaultFill(2);
        rootPanel.add((Component)description, g.nextLine().next().coverLine(3).pady(10));
        rootPanel.add((Component)icon, g.nextLine().next().coverColumn(3));
        rootPanel.add((Component)nameLabel, g.next().fillCellNone().insets(new Insets(0, 6, 4, 10)));
        rootPanel.add((Component)this.myNameTextField, g.next());
        rootPanel.add((Component)emailLabel, g.nextLine().next().next().fillCellNone().insets(new Insets(0, 6, 4, 10)));
        rootPanel.add((Component)this.myEmailTextField, g.next());
        rootPanel.add((Component)this.myGlobalCheckbox, g.nextLine().next().next().coverLine(2));
        return rootPanel;
    }

    protected JComponent createNorthPanel() {
        return null;
    }

    @NotNull
    private String getMessageText() {
        if (this.myAllRootsAffectedByCommit.size() == this.myRootsWithUndefinedProps.size()) {
            if ("" == null) {
                GitUserNameNotDefinedDialog.$$$reportNull$$$0(4);
            }
            return "";
        }
        String text = "Git user.name and user.email properties are not defined in " + StringUtil.pluralize((String)"root", (int)this.myRootsWithUndefinedProps.size()) + "<br/>";
        for (VirtualFile virtualFile : this.myRootsWithUndefinedProps) {
            text = text + virtualFile.getPresentableUrl() + "<br/>";
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)text);
        if (string == null) {
            GitUserNameNotDefinedDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String getUserName() {
        return this.myNameTextField.getText();
    }

    public String getUserEmail() {
        return this.myEmailTextField.getText();
    }

    public boolean isGlobal() {
        return this.myGlobalCheckbox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsWithUndefinedProps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRootsAffectedByCommit";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsWithDefinedProps";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/checkin/GitUserNameNotDefinedDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/checkin/GitUserNameNotDefinedDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

