/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitCommit;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.changes.GitRepositoryLocation;
import git4idea.changes.GitVersionFilterComponent;
import git4idea.commands.GitHandler;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommittedChangeListProvider
implements CommittedChangesProvider<CommittedChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(GitCommittedChangeListProvider.class);
    @NotNull
    private final Project myProject;

    public GitCommittedChangeListProvider(@NotNull Project project) {
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new GitVersionFilterComponent(showDateFilter);
    }

    public RepositoryLocation getLocationFor(@NotNull FilePath rootPath) {
        VirtualFile gitRoot;
        if (rootPath == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(1);
        }
        if ((gitRoot = rootPath.getVirtualFile()) == null) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(gitRoot);
        if (repository == null) {
            LOG.info("No GitRepository for " + gitRoot);
            return null;
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        GitRemoteBranch trackedBranch = currentBranch.findTrackedBranch(repository);
        if (trackedBranch == null) {
            return null;
        }
        File rootFile = new File(gitRoot.getPath());
        return new GitRepositoryLocation(trackedBranch.getRemote().getFirstUrl(), rootFile);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<? super CommittedChangeList> consumer2) throws VcsException {
        try {
            this.getCommittedChangesImpl(settings, location, maxCount, (Consumer<? super GitCommittedChangeList>)((Consumer)gitCommittedChangeList -> consumer2.consume((Object)gitCommittedChangeList)));
        }
        finally {
            consumer2.finished();
        }
    }

    public List<CommittedChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        this.getCommittedChangesImpl(settings, location, maxCount, (Consumer<? super GitCommittedChangeList>)((Consumer)committedChangeList -> result2.add((CommittedChangeList)committedChangeList)));
        return result2;
    }

    private void getCommittedChangesImpl(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, Consumer<? super GitCommittedChangeList> consumer2) throws VcsException {
        GitRepositoryLocation l = (GitRepositoryLocation)location;
        Long beforeRev = settings.getChangeBeforeFilter();
        Long afterRev = settings.getChangeAfterFilter();
        Date beforeDate = settings.getDateBeforeFilter();
        Date afterDate = settings.getDateAfterFilter();
        String author = settings.getUserFilter();
        VirtualFile root = LocalFileSystem.getInstance().findFileByIoFile(l.getRoot());
        if (root == null) {
            throw new VcsException("The repository does not exists anymore: " + l.getRoot());
        }
        GitUtil.getLocalCommittedChanges(this.myProject, root, (Consumer<? super GitHandler>)((Consumer)h -> {
            if (!StringUtil.isEmpty((String)author)) {
                h.addParameters("--author=" + author);
            }
            if (beforeDate != null) {
                h.addParameters("--before=" + GitUtil.gitTime(beforeDate));
            }
            if (afterDate != null) {
                h.addParameters("--after=" + GitUtil.gitTime(afterDate));
            }
            if (maxCount != this.getUnlimitedCountValue()) {
                h.addParameters("-n" + maxCount);
            }
            if (beforeRev != null && afterRev != null) {
                h.addParameters(GitUtil.formatLongRev(afterRev) + ".." + GitUtil.formatLongRev(beforeRev));
            } else if (beforeRev != null) {
                h.addParameters(GitUtil.formatLongRev(beforeRev));
            } else if (afterRev != null) {
                h.addParameters(GitUtil.formatLongRev(afterRev) + "..");
            }
        }), consumer2, false);
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{ChangeListColumn.NUMBER, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION, ChangeListColumn.NAME};
    }

    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }

    public int getUnlimitedCountValue() {
        return -1;
    }

    public Pair<CommittedChangeList, FilePath> getOneList(@NotNull VirtualFile file, @NotNull VcsRevisionNumber number) throws VcsException {
        if (file == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(2);
        }
        if (number == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(3);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        if (!(number instanceof GitRevisionNumber)) {
            LOG.error("Unsupported revision number: " + number);
            return null;
        }
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)filePath));
        if (repository == null) {
            return null;
        }
        VirtualFile root = repository.getRoot();
        VcsFullCommitDetails gitCommit = GitCommittedChangeListProvider.getCommitDetails(this.myProject, root, number);
        if (gitCommit == null) {
            return null;
        }
        GitCommittedChangeList commit2 = GitCommittedChangeListProvider.createCommittedChangeList(this.myProject, gitCommit, (GitRevisionNumber)number);
        Collection changes = commit2.getChanges();
        if (changes.size() == 1) {
            Change change = (Change)changes.iterator().next();
            return Pair.create((Object)((Object)commit2), (Object)ChangesUtil.getFilePath((Change)change));
        }
        for (Change change : changes) {
            if (change.getAfterRevision() == null || !FileUtil.filesEqual((File)filePath.getIOFile(), (File)change.getAfterRevision().getFile().getIOFile())) continue;
            return Pair.create((Object)((Object)commit2), (Object)filePath);
        }
        String afterTime = "--after=" + GitUtil.gitTime(new Date(gitCommit.getCommitTime()));
        List<VcsFileRevision> history = GitFileHistory.collectHistory(this.myProject, filePath, afterTime);
        if (history.isEmpty()) {
            return Pair.create((Object)((Object)commit2), (Object)filePath);
        }
        return Pair.create((Object)((Object)commit2), (Object)((GitFileRevision)history.get(history.size() - 1)).getPath());
    }

    @Nullable
    private static VcsFullCommitDetails getCommitDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsRevisionNumber number) throws VcsException {
        GitVcs gitVcs;
        String[] hashParameters;
        List<GitCommit> gitCommits;
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(5);
        }
        if (number == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(6);
        }
        if ((gitCommits = GitHistoryUtils.history(project, root, hashParameters = GitHistoryUtils.formHashParameters(gitVcs = GitVcs.getInstance(project), Collections.singleton(number.asString())))).size() != 1) {
            return null;
        }
        return (VcsFullCommitDetails)gitCommits.get(0);
    }

    @NotNull
    private static GitCommittedChangeList createCommittedChangeList(@NotNull Project project, @NotNull VcsFullCommitDetails gitCommit, @NotNull GitRevisionNumber revisionNumber) {
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(7);
        }
        if (gitCommit == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(8);
        }
        if (revisionNumber == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(9);
        }
        GitCommittedChangeList gitCommittedChangeList = new GitCommittedChangeList(gitCommit.getFullMessage() + " (" + ((Hash)gitCommit.getId()).toShortString() + ")", gitCommit.getFullMessage(), VcsUserUtil.toExactString((VcsUser)gitCommit.getAuthor()), revisionNumber, new Date(gitCommit.getAuthorTime()), gitCommit.getChanges(), GitVcs.getInstance(project), true);
        if (gitCommittedChangeList == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(10);
        }
        return gitCommittedChangeList;
    }

    @Nullable
    public static GitCommittedChangeList getCommittedChangeList(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitRevisionNumber revisionNumber) throws VcsException {
        VcsFullCommitDetails details;
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(12);
        }
        if (revisionNumber == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(13);
        }
        if ((details = GitCommittedChangeListProvider.getCommitDetails(project, root, (VcsRevisionNumber)revisionNumber)) == null) {
            return null;
        }
        return GitCommittedChangeListProvider.createCommittedChangeList(project, details, revisionNumber);
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        return null;
    }

    public boolean supportsIncomingChanges() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitCommit";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/changes/GitCommittedChangeListProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/changes/GitCommittedChangeListProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommittedChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOneList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommitDetails";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCommittedChangeList";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedChangeList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

