/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.rebase.GitRebaseDialog;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GitRebase
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitRebase.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project = e.getProject();
        if (project == null || !GitUtil.hasGitRepositories(project)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(GitRebaseUtils.getRebasingRepositories(project).size() < GitUtil.getRepositories(project).size());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GitRebase.$$$reportNull$$$0(1);
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(GitUtil.getRepositories(project));
        repositories.removeAll(GitRebaseUtils.getRebasingRepositories(project));
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(GitUtil.getRootsFromRepositories(DvcsUtil.sortRepositories(repositories)));
        VirtualFile defaultRoot = DvcsUtil.guessVcsRoot((Project)project, (VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)));
        final GitRebaseDialog dialog = new GitRebaseDialog(project, roots, defaultRoot);
        if (dialog.showAndGet()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Rebasing..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GitRebaseUtils.rebase(project, Collections.singletonList(dialog.getSelectedRepository()), dialog.getSelectedParams(), indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitRebase$1", "run"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "git4idea/actions/GitRebase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

