/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class RootCellRenderer
extends SimpleColoredRenderer
implements TableCellRenderer {
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private Color myColor;
    @NotNull
    private Color myBorderColor;
    private boolean isNarrow;

    RootCellRenderer(@NotNull VcsLogUiProperties properties, @NotNull VcsLogColorManager colorManager) {
        if (properties == null) {
            RootCellRenderer.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            RootCellRenderer.$$$reportNull$$$0(1);
        }
        this.myColor = UIUtil.getTableBackground();
        this.myBorderColor = UIUtil.getTableBackground();
        this.isNarrow = true;
        this.myProperties = properties;
        this.myColorManager = colorManager;
        this.setTextAlign(0);
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.myColor);
        if (this.isNarrow) {
            g.fillRect(x, 0, width - JBUIScale.scale((int)5), height);
            g.setColor(this.myBorderColor);
            g.fillRect(x + width - JBUIScale.scale((int)5), 0, JBUIScale.scale((int)5), height);
        } else {
            g.fillRect(x, 0, width, height);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
        this.clear();
        VirtualFile root = (VirtualFile)value;
        this.myColor = root == null ? UIUtil.getTableBackground((boolean)isSelected, (boolean)hasFocus) : VcsLogGraphTable.getRootBackgroundColor(root, this.myColorManager);
        this.myBorderColor = (Color)ObjectUtils.assertNotNull((Object)((VcsLogGraphTable)((Object)table)).getStyle(row2, column, hasFocus, isSelected).getBackground());
        this.setForeground(UIUtil.getTableForeground((boolean)false, (boolean)hasFocus));
        if (this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES).booleanValue()) {
            if (RootCellRenderer.isTextShown(table, value, row2, column)) {
                this.append(root == null ? "" : root.getName());
            }
            this.isNarrow = false;
        } else {
            this.append("");
            this.isNarrow = true;
        }
        return this;
    }

    private static boolean isTextShown(JTable table, Object value, int row2, int column) {
        int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)table.getRowHeight() * 0.5f));
        if (row2 < readableRow) {
            return false;
        }
        return row2 == 0 || readableRow == row2 || !Objects.equals(value, table.getModel().getValueAt(row2 - 1, column));
    }

    public void setBackground(Color bg) {
        this.myBorderColor = bg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "properties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "colorManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/ui/table/RootCellRenderer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

