/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.BranchFilters;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPair;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogUserFilterImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    private final BranchFilterModel myBranchFilterModel;
    @NotNull
    private final FilterModel.SingleFilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    private final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    private final FileFilterModel myStructureFilterModel;
    @NotNull
    private final TextFilterModel myTextFilterModel;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui2, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack, @Nullable VcsLogFilterCollection filters) {
        if (ui2 == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(2);
        }
        if (initialDataPack == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(3);
        }
        this.myUi = ui2;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        NotNullComputable dataPackGetter = () -> this.myDataPack;
        this.myBranchFilterModel = new BranchFilterModel((Computable<? extends VcsLogDataPack>)dataPackGetter, this.myLogData.getStorage(), this.myLogData.getRoots(), this.myUiProperties, filters);
        this.myUserFilterModel = new UserFilterModel(this.myUiProperties, filters);
        this.myDateFilterModel = new DateFilterModel(this.myUiProperties, filters);
        this.myStructureFilterModel = new FileFilterModel(this.myLogData.getLogProviders().keySet(), this.myUiProperties, filters);
        this.myTextFilterModel = new TextFilterModel(this.myUiProperties, filters, ui2);
        this.updateUiOnFilterChange();
        this.myUi.applyFiltersAndUpdateUi(this.getFilters());
    }

    private void updateUiOnFilterChange() {
        FilterModel[] models;
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(() -> {
                this.myUi.applyFiltersAndUpdateUi(this.getFilters());
                this.myBranchFilterModel.onStructureFilterChanged(this.myStructureFilterModel.getRootFilter(), this.myStructureFilterModel.getStructureFilter());
            });
        }
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        if (dataPack == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(4);
        }
        this.myDataPack = dataPack;
    }

    @NotNull
    public SearchTextField createTextFilter() {
        TextFilterField textFilterField = new TextFilterField(this.myTextFilterModel);
        if (textFilterField == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(5);
        }
        return textFilterField;
    }

    @NotNull
    public ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new BranchFilterPopupComponent(this.myUiProperties, this.myBranchFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new UserFilterPopupComponent(this.myUiProperties, this.myLogData, this.myUserFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new DateFilterPopupComponent(this.myDateFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new StructureFilterPopupComponent(this.myUiProperties, this.myStructureFilterModel, this.myUi.getColorManager()).initUi())));
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(6);
        }
        return defaultActionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[]{this.myBranchFilterModel.getBranchFilter(), this.myBranchFilterModel.getRevisionFilter(), this.myBranchFilterModel.getRangeFilter(), this.myTextFilterModel.getFilter1(), this.myTextFilterModel.getFilter2(), this.myStructureFilterModel.getFilter1(), this.myStructureFilterModel.getFilter2(), (VcsLogFilter)this.myDateFilterModel.getFilter(), (VcsLogFilter)this.myUserFilterModel.getFilter()});
        if (vcsLogFilterCollection == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(7);
        }
        return vcsLogFilterCollection;
    }

    public void setFilter(@Nullable VcsLogFilter filter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filter == null) {
            this.myBranchFilterModel.setFilter(null);
            this.myStructureFilterModel.setFilter(null);
            this.myDateFilterModel.setFilter(null);
            this.myTextFilterModel.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
            this.myUserFilterModel.setFilter(null);
        } else if (filter instanceof VcsLogBranchFilter) {
            this.myBranchFilterModel.setBranchFilter((VcsLogBranchFilter)filter);
        } else if (filter instanceof VcsLogStructureFilter) {
            this.myStructureFilterModel.setStructureFilter((VcsLogStructureFilter)filter);
        }
        JComponent toolbar = this.myUi.getToolbar();
        toolbar.revalidate();
        toolbar.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDataPack";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextFilterField
    extends SearchTextField {
        @NotNull
        private final TextFilterModel myTextFilterModel;

        TextFilterField(@NotNull TextFilterModel model) {
            if (model == null) {
                TextFilterField.$$$reportNull$$$0(0);
            }
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.myTextFilterModel = model;
            this.setText(this.myTextFilterModel.getText());
            this.getTextEditor().addActionListener(e -> this.applyFilter());
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        myTextFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        LOG.error((Throwable)ex);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField$1", "textChanged"));
                }
            });
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter");
            if (!shortcutText.isEmpty()) {
                this.getTextEditor().setToolTipText("Use " + shortcutText + " to switch between text filter and commits list");
            }
        }

        protected void applyFilter() {
            this.myTextFilterModel.setFilterText(this.getText());
            this.addCurrentTextToHistory();
        }

        protected void onFieldCleared() {
            this.myTextFilterModel.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
        }

        protected void onFocusLost() {
            if (this.myTextFilterModel.hasUnsavedChanges()) {
                this.applyFilter();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField", "<init>"));
        }
    }

    private class UserFilterModel
    extends FilterModel.SingleFilterModel<VcsLogUserFilter> {
        UserFilterModel(@Nullable MainVcsLogUiProperties uiProperties, VcsLogFilterCollection filters) {
            if (uiProperties == null) {
                UserFilterModel.$$$reportNull$$$0(0);
            }
            super(VcsLogFilterCollection.USER_FILTER, uiProperties, filters);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                UserFilterModel.$$$reportNull$$$0(1);
            }
            VcsLogUserFilter vcsLogUserFilter = VcsLogFilterObject.fromUserNames(values, VcsLogClassicFilterUi.this.myLogData);
            if (vcsLogUserFilter == null) {
                UserFilterModel.$$$reportNull$$$0(2);
            }
            return vcsLogUserFilter;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter) {
            if (filter == null) {
                UserFilterModel.$$$reportNull$$$0(3);
            }
            ArrayList<String> arrayList = new ArrayList<String>(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
            if (arrayList == null) {
                UserFilterModel.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DateFilterModel
    extends FilterModel.SingleFilterModel<VcsLogDateFilter> {
        DateFilterModel(@NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            if (uiProperties == null) {
                DateFilterModel.$$$reportNull$$$0(0);
            }
            super(VcsLogFilterCollection.DATE_FILTER, uiProperties, filters);
        }

        @Override
        @Nullable
        protected VcsLogDateFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                DateFilterModel.$$$reportNull$$$0(1);
            }
            if (values.size() != 2) {
                LOG.warn("Can not create date filter from " + values + " before and after dates are required.");
                return null;
            }
            String after = values.get(0);
            String before = values.get(1);
            try {
                return VcsLogFilterObject.fromDates(after.isEmpty() ? 0L : Long.parseLong(after), before.isEmpty() ? 0L : Long.parseLong(before));
            }
            catch (NumberFormatException e) {
                LOG.warn("Can not create date filter from " + values);
                return null;
            }
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter) {
            if (filter == null) {
                DateFilterModel.$$$reportNull$$$0(2);
            }
            Date after = filter.getAfter();
            Date before = filter.getBefore();
            List<String> list = Arrays.asList(after == null ? "" : Long.toString(after.getTime()), before == null ? "" : Long.toString(before.getTime()));
            if (list == null) {
                DateFilterModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FileFilterModel
    extends FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter> {
        @NotNull
        private static final String DIR = "dir:";
        @NotNull
        private static final String FILE = "file:";
        @NotNull
        private final Set<VirtualFile> myRoots;

        public FileFilterModel(@NotNull Set<VirtualFile> roots, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            if (roots == null) {
                FileFilterModel.$$$reportNull$$$0(0);
            }
            if (uiProperties == null) {
                FileFilterModel.$$$reportNull$$$0(1);
            }
            super(VcsLogFilterCollection.STRUCTURE_FILTER, VcsLogFilterCollection.ROOT_FILTER, uiProperties, filters);
            this.myRoots = roots;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogStructureFilter filter) {
            if (filter == null) {
                FileFilterModel.$$$reportNull$$$0(2);
            }
            List<String> list = FileFilterModel.getFilterValues(filter);
            if (list == null) {
                FileFilterModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogRootFilter filter) {
            if (filter == null) {
                FileFilterModel.$$$reportNull$$$0(4);
            }
            List list = ContainerUtil.map((Collection)filter.getRoots(), VirtualFile::getPath);
            if (list == null) {
                FileFilterModel.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        static List<String> getFilterValues(@NotNull VcsLogStructureFilter filter) {
            if (filter == null) {
                FileFilterModel.$$$reportNull$$$0(6);
            }
            List list = ContainerUtil.map((Collection)filter.getFiles(), path -> (path.isDirectory() ? DIR : FILE) + path.getPath());
            if (list == null) {
                FileFilterModel.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Override
        @NotNull
        protected VcsLogStructureFilter createFilter1(@NotNull List<String> values) {
            if (values == null) {
                FileFilterModel.$$$reportNull$$$0(8);
            }
            VcsLogStructureFilter vcsLogStructureFilter = FileFilterModel.createStructureFilter(values);
            if (vcsLogStructureFilter == null) {
                FileFilterModel.$$$reportNull$$$0(9);
            }
            return vcsLogStructureFilter;
        }

        @Override
        @Nullable
        protected VcsLogRootFilter createFilter2(@NotNull List<String> values) {
            if (values == null) {
                FileFilterModel.$$$reportNull$$$0(10);
            }
            ArrayList<VirtualFile> selectedRoots = new ArrayList<VirtualFile>();
            for (String path : values) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    if (this.myRoots.contains(root)) {
                        selectedRoots.add(root);
                        continue;
                    }
                    LOG.warn("Can not find VCS root for filtering " + root);
                    continue;
                }
                LOG.warn("Can not filter by file that does not exist " + path);
            }
            if (selectedRoots.isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRoots(selectedRoots);
        }

        @Nullable
        protected VcsLogRootFilter getRootFilter() {
            return (VcsLogRootFilter)this.getFilter2();
        }

        @Nullable
        protected VcsLogStructureFilter getStructureFilter() {
            return (VcsLogStructureFilter)this.getFilter1();
        }

        @NotNull
        Set<VirtualFile> getRoots() {
            Set<VirtualFile> set = this.myRoots;
            if (set == null) {
                FileFilterModel.$$$reportNull$$$0(11);
            }
            return set;
        }

        protected void setStructureFilter(@NotNull VcsLogStructureFilter filter) {
            if (filter == null) {
                FileFilterModel.$$$reportNull$$$0(12);
            }
            this.setFilter(new FilterPair<VcsLogStructureFilter, Object>(filter, null));
        }

        @NotNull
        static VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
            if (values == null) {
                FileFilterModel.$$$reportNull$$$0(13);
            }
            VcsLogStructureFilter vcsLogStructureFilter = VcsLogFilterObject.fromPaths(ContainerUtil.map(values, path -> {
                if (path.startsWith(DIR)) {
                    return VcsUtil.getFilePath((String)path.substring(DIR.length()), (boolean)true);
                }
                if (path.startsWith(FILE)) {
                    return VcsUtil.getFilePath((String)path.substring(FILE.length()), (boolean)false);
                }
                return VcsUtil.getFilePath((String)path);
            }));
            if (vcsLogStructureFilter == null) {
                FileFilterModel.$$$reportNull$$$0(14);
            }
            return vcsLogStructureFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel";
                    break;
                }
                case 8: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter1Values";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter2Values";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFilter1";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStructureFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter1Values";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter2Values";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter1";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter2";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setStructureFilter";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createStructureFilter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TextFilterModel
    extends FilterModel.PairFilterModel<VcsLogTextFilter, VcsLogHashFilter> {
        @Nullable
        private String myText;

        TextFilterModel(@NotNull MainVcsLogUiProperties properties, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
            VcsLogTextFilter textFilter;
            if (properties == null) {
                TextFilterModel.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                TextFilterModel.$$$reportNull$$$0(1);
            }
            super(VcsLogFilterCollection.TEXT_FILTER, VcsLogFilterCollection.HASH_FILTER, properties, filters);
            if (filters != null && (textFilter = (VcsLogTextFilter)filters.get(VcsLogFilterCollection.TEXT_FILTER)) != null) {
                this.myUiProperties.set(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, textFilter.matchesCase());
                this.myUiProperties.set(MainVcsLogUiProperties.TEXT_FILTER_REGEX, textFilter.isRegex());
            }
            VcsLogUiProperties.PropertiesChangeListener listener = new VcsLogUiProperties.PropertiesChangeListener(){

                @Override
                public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                    if (property == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((MainVcsLogUiProperties.TEXT_FILTER_REGEX.equals(property) || MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE.equals(property)) && this.getFilter1() != null) {
                        myFilter = this.getFilterFromProperties();
                        this.notifyFiltersChanged();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel$1", "onPropertyChanged"));
                }
            };
            properties.addChangeListener(listener);
            Disposer.register((Disposable)parentDisposable, () -> properties.removeChangeListener(listener));
        }

        @Override
        @Nullable
        protected FilterPair<VcsLogTextFilter, VcsLogHashFilter> getFilterFromProperties() {
            Object filterPair = super.getFilterFromProperties();
            if (filterPair == null) {
                return null;
            }
            VcsLogTextFilter textFilter = (VcsLogTextFilter)((FilterPair)filterPair).getFilter1();
            VcsLogHashFilter hashFilter = (VcsLogHashFilter)((FilterPair)filterPair).getFilter2();
            if (textFilter != null && StringUtil.isEmptyOrSpaces((String)textFilter.getText())) {
                LOG.warn("Saved text filter is empty. Removing.");
                textFilter = null;
            }
            if (textFilter != null) {
                VcsLogHashFilter hashFilterFromText = VcsLogFilterObject.fromHash(textFilter.getText());
                if (!Objects.equals(hashFilter, hashFilterFromText)) {
                    LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with text filter. Replacing with " + hashFilterFromText);
                    hashFilter = hashFilterFromText;
                }
            } else if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
                textFilter = this.createTextFilter(StringUtil.join((Collection)hashFilter.getHashes(), (String)" "));
                LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with empty text filter. Using text filter " + textFilter);
            }
            return new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilter, hashFilter);
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                String string = this.myText;
                if (string == null) {
                    TextFilterModel.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.getFilter1() != null) {
                String string = ((VcsLogTextFilter)this.getFilter1()).getText();
                if (string == null) {
                    TextFilterModel.$$$reportNull$$$0(3);
                }
                return string;
            }
            if ("" == null) {
                TextFilterModel.$$$reportNull$$$0(4);
            }
            return "";
        }

        void setUnsavedText(@NotNull String text) {
            if (text == null) {
                TextFilterModel.$$$reportNull$$$0(5);
            }
            this.myText = text;
        }

        boolean hasUnsavedChanges() {
            if (this.myText == null) {
                return false;
            }
            return this.getFilter1() == null || !this.myText.equals(((VcsLogTextFilter)this.getFilter1()).getText());
        }

        @Override
        void setFilter(@Nullable FilterPair<VcsLogTextFilter, VcsLogHashFilter> filter) {
            super.setFilter(filter);
            this.myText = null;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogTextFilter filter) {
            if (filter == null) {
                TextFilterModel.$$$reportNull$$$0(6);
            }
            List<String> list = Collections.singletonList(filter.getText());
            if (list == null) {
                TextFilterModel.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogHashFilter filter) {
            if (filter == null) {
                TextFilterModel.$$$reportNull$$$0(8);
            }
            ArrayList<String> arrayList = new ArrayList<String>(filter.getHashes());
            if (arrayList == null) {
                TextFilterModel.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @Override
        @Nullable
        protected VcsLogTextFilter createFilter1(@NotNull List<String> values) {
            if (values == null) {
                TextFilterModel.$$$reportNull$$$0(10);
            }
            return this.createTextFilter((String)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(values)));
        }

        @Override
        @Nullable
        protected VcsLogHashFilter createFilter2(@NotNull List<String> values) {
            if (values == null) {
                TextFilterModel.$$$reportNull$$$0(11);
            }
            return VcsLogFilterObject.fromHashes(values);
        }

        @NotNull
        private VcsLogTextFilter createTextFilter(@NotNull String text) {
            if (text == null) {
                TextFilterModel.$$$reportNull$$$0(12);
            }
            VcsLogTextFilter vcsLogTextFilter = VcsLogFilterObject.fromPattern(text, this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
            if (vcsLogTextFilter == null) {
                TextFilterModel.$$$reportNull$$$0(13);
            }
            return vcsLogTextFilter;
        }

        public void setFilterText(@NotNull String text) {
            if (text == null) {
                TextFilterModel.$$$reportNull$$$0(14);
            }
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                this.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
            } else {
                VcsLogTextFilter textFilter = this.createTextFilter(text);
                VcsLogHashFilter hashFilter = VcsLogFilterObject.fromHash(text);
                this.setFilter(new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilter, hashFilter));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel";
                    break;
                }
                case 5: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter1Values";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter2Values";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTextFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 13: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setUnsavedText";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter1Values";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter2Values";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter1";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter2";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createTextFilter";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "setFilterText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BranchFilterModel
    extends FilterModel<BranchFilters> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;
        @NotNull
        private final Computable<? extends VcsLogDataPack> myDataPackProvider;

        BranchFilterModel(@NotNull Computable<? extends VcsLogDataPack> dataPackProvider, @NotNull VcsLogStorage storage, @NotNull Collection<VirtualFile> roots, @NotNull MainVcsLogUiProperties properties, @Nullable VcsLogFilterCollection filters) {
            if (dataPackProvider == null) {
                BranchFilterModel.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                BranchFilterModel.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                BranchFilterModel.$$$reportNull$$$0(2);
            }
            if (properties == null) {
                BranchFilterModel.$$$reportNull$$$0(3);
            }
            super(properties);
            this.myStorage = storage;
            this.myRoots = roots;
            this.myDataPackProvider = dataPackProvider;
            if (filters != null) {
                this.saveFilterToProperties(new BranchFilters((VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER), (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER), (VcsLogRangeFilter)filters.get(VcsLogFilterCollection.RANGE_FILTER)));
            }
        }

        @Override
        void setFilter(@Nullable BranchFilters filters) {
            BranchFilterModel.triggerFilterSet(filters, BranchFilters::getBranchFilter, this.myFilter, VcsLogFilterCollection.BRANCH_FILTER.getName());
            BranchFilterModel.triggerFilterSet(filters, BranchFilters::getRevisionFilter, this.myFilter, VcsLogFilterCollection.REVISION_FILTER.getName());
            BranchFilterModel.triggerFilterSet(filters, BranchFilters::getRangeFilter, this.myFilter, VcsLogFilterCollection.RANGE_FILTER.getName());
            super.setFilter(filters);
        }

        @Override
        protected void saveFilterToProperties(@Nullable BranchFilters filters) {
            if (filters == null || filters.getBranchFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName(), BranchFilterModel.getBranchFilterValues(filters.getBranchFilter()));
            }
            if (filters == null || filters.getRevisionFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName(), BranchFilterModel.getRevisionFilterValues(filters.getRevisionFilter()));
            }
            if (filters == null || filters.getRangeFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName(), BranchFilterModel.getRangeFilterValues(filters.getRangeFilter()));
            }
        }

        @Override
        @Nullable
        protected BranchFilters getFilterFromProperties() {
            List<String> branchFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName());
            VcsLogBranchFilter branchFilter = null;
            if (branchFilterValues != null) {
                branchFilter = this.createBranchFilter(branchFilterValues);
            }
            List<String> revisionFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName());
            VcsLogRevisionFilter revisionFilter = null;
            if (revisionFilterValues != null) {
                revisionFilter = this.createRevisionFilter(revisionFilterValues);
            }
            List<String> rangeFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName());
            VcsLogRangeFilter rangeFilter = null;
            if (rangeFilterValues != null) {
                rangeFilter = BranchFilterModel.createRangeFilter(rangeFilterValues);
            }
            if (branchFilter == null && revisionFilter == null && rangeFilter == null) {
                return null;
            }
            return new BranchFilters(branchFilter, revisionFilter, rangeFilter);
        }

        public void onStructureFilterChanged(@Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
            this.myVisibleRoots = rootFilter == null && structureFilter == null ? null : VcsLogUtil.getAllVisibleRoots(this.myRoots, rootFilter, structureFilter);
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }

        @NotNull
        VcsLogDataPack getDataPack() {
            VcsLogDataPack vcsLogDataPack = (VcsLogDataPack)this.myDataPackProvider.compute();
            if (vcsLogDataPack == null) {
                BranchFilterModel.$$$reportNull$$$0(4);
            }
            return vcsLogDataPack;
        }

        @Nullable
        protected VcsLogBranchFilter createBranchFilter(@NotNull List<String> values) {
            if (values == null) {
                BranchFilterModel.$$$reportNull$$$0(5);
            }
            return VcsLogFilterObject.fromBranchPatterns(values, ContainerUtil.map2Set((Collection)this.getDataPack().getRefs().getBranches(), VcsRef::getName));
        }

        @Nullable
        protected VcsLogRevisionFilter createRevisionFilter(@NotNull List<String> values) {
            if (values == null) {
                BranchFilterModel.$$$reportNull$$$0(6);
            }
            Pattern pattern = Pattern.compile("\\[(.*)\\](" + VcsLogUtil.HASH_REGEX.pattern() + ")");
            return VcsLogFilterObject.fromCommits(ContainerUtil.mapNotNull(values, s -> {
                Matcher matcher = pattern.matcher((CharSequence)s);
                if (!matcher.matches()) {
                    CommitId commitId;
                    if (s.length() == 40 && VcsLogUtil.HASH_REGEX.matcher((CharSequence)s).matches() && (commitId = this.findCommitId(HashImpl.build(s))) != null) {
                        return commitId;
                    }
                    LOG.warn("Could not parse '" + s + "' while creating revision filter");
                    return null;
                }
                MatchResult result2 = matcher.toMatchResult();
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(result2.group(1));
                if (root == null) {
                    LOG.warn("Root '" + result2.group(1) + "' does not exist");
                    return null;
                }
                if (!this.myRoots.contains(root)) {
                    LOG.warn("Root '" + result2.group(1) + "' is not registered");
                    return null;
                }
                return new CommitId(HashImpl.build(result2.group(2)), root);
            }));
        }

        @Nullable
        private static VcsLogRangeFilter createRangeFilter(@NotNull List<String> values) {
            if (values == null) {
                BranchFilterModel.$$$reportNull$$$0(7);
            }
            if (values.isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRange(ContainerUtil.map(values, value -> {
                String TWO_DOTS = "..";
                int twoDots = value.indexOf(TWO_DOTS);
                if (twoDots <= 0) {
                    LOG.error("Incorrect range filter value: " + values);
                    return null;
                }
                return new VcsLogRangeFilter.RefRange(value.substring(0, twoDots), value.substring(twoDots + TWO_DOTS.length()));
            }));
        }

        @Nullable
        private CommitId findCommitId(@NotNull Hash hash) {
            if (hash == null) {
                BranchFilterModel.$$$reportNull$$$0(8);
            }
            for (VirtualFile root : this.myRoots) {
                CommitId commitId = new CommitId(hash, root);
                if (!this.myStorage.containsCommit(commitId)) continue;
                return commitId;
            }
            return null;
        }

        @NotNull
        private static List<String> getBranchFilterValues(@NotNull VcsLogBranchFilter filter) {
            if (filter == null) {
                BranchFilterModel.$$$reportNull$$$0(9);
            }
            ArrayList<String> arrayList = new ArrayList<String>(ContainerUtil.sorted((Collection)filter.getTextPresentation()));
            if (arrayList == null) {
                BranchFilterModel.$$$reportNull$$$0(10);
            }
            return arrayList;
        }

        @NotNull
        private static List<String> getRevisionFilterValues(@NotNull VcsLogRevisionFilter filter) {
            if (filter == null) {
                BranchFilterModel.$$$reportNull$$$0(11);
            }
            List list = ContainerUtil.map((Collection)filter.getHeads(), id -> "[" + id.getRoot().getPath() + "]" + id.getHash().asString());
            if (list == null) {
                BranchFilterModel.$$$reportNull$$$0(12);
            }
            return list;
        }

        @NotNull
        private static List<String> getRangeFilterValues(@NotNull VcsLogRangeFilter rangeFilter) {
            if (rangeFilter == null) {
                BranchFilterModel.$$$reportNull$$$0(13);
            }
            ArrayList<String> arrayList = new ArrayList<String>(rangeFilter.getTextPresentation());
            if (arrayList == null) {
                BranchFilterModel.$$$reportNull$$$0(14);
            }
            return arrayList;
        }

        @NotNull
        private static List<String> getRevisionFilter2Presentation(@NotNull VcsLogRevisionFilter filter) {
            if (filter == null) {
                BranchFilterModel.$$$reportNull$$$0(15);
            }
            List list = ContainerUtil.map((Collection)filter.getHeads(), id -> id.getHash().asString());
            if (list == null) {
                BranchFilterModel.$$$reportNull$$$0(16);
            }
            return list;
        }

        void setBranchFilter(@NotNull VcsLogBranchFilter branchFilter) {
            if (branchFilter == null) {
                BranchFilterModel.$$$reportNull$$$0(17);
            }
            this.setFilter(new BranchFilters(branchFilter, null, null));
        }

        @NotNull
        static List<String> getFilterPresentation(@NotNull BranchFilters filters) {
            if (filters == null) {
                BranchFilterModel.$$$reportNull$$$0(18);
            }
            List branchFilterValues = filters.getBranchFilter() == null ? Collections.emptyList() : BranchFilterModel.getBranchFilterValues(filters.getBranchFilter());
            List revisionFilterValues = filters.getRevisionFilter() == null ? Collections.emptyList() : BranchFilterModel.getRevisionFilter2Presentation(filters.getRevisionFilter());
            List rangeFilterValues = filters.getRangeFilter() == null ? Collections.emptyList() : BranchFilterModel.getRangeFilterValues(filters.getRangeFilter());
            List list = ContainerUtil.concat((List[])new List[]{branchFilterValues, revisionFilterValues, rangeFilterValues});
            if (list == null) {
                BranchFilterModel.$$$reportNull$$$0(19);
            }
            return list;
        }

        @Nullable
        BranchFilters createFilterFromPresentation(@NotNull List<String> values) {
            if (values == null) {
                BranchFilterModel.$$$reportNull$$$0(20);
            }
            ArrayList<String> hashes = new ArrayList<String>();
            ArrayList<String> branches = new ArrayList<String>();
            ArrayList<String> ranges = new ArrayList<String>();
            for (String s : values) {
                int twoDots = s.indexOf("..");
                if (twoDots > 0 && twoDots == s.lastIndexOf("..")) {
                    ranges.add(s);
                    continue;
                }
                if (s.length() == 40 && VcsLogUtil.HASH_REGEX.matcher(s).matches()) {
                    hashes.add(s);
                    continue;
                }
                branches.add(s);
            }
            VcsLogBranchFilter branchFilter = branches.isEmpty() ? null : this.createBranchFilter(branches);
            VcsLogRevisionFilter hashFilter = hashes.isEmpty() ? null : this.createRevisionFilter(hashes);
            VcsLogRangeFilter refDiffFilter = ranges.isEmpty() ? null : BranchFilterModel.createRangeFilter(ranges);
            return new BranchFilters(branchFilter, hashFilter, refDiffFilter);
        }

        @Nullable
        public VcsLogFilter getBranchFilter() {
            BranchFilters filter = (BranchFilters)this.getFilter();
            if (filter == null) {
                return null;
            }
            return filter.getBranchFilter();
        }

        @Nullable
        public VcsLogFilter getRevisionFilter() {
            BranchFilters filter = (BranchFilters)this.getFilter();
            if (filter == null) {
                return null;
            }
            return filter.getRevisionFilter();
        }

        @Nullable
        public VcsLogFilter getRangeFilter() {
            BranchFilters filter = (BranchFilters)this.getFilter();
            if (filter == null) {
                return null;
            }
            return filter.getRangeFilter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPackProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 9: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeFilter";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchFilter";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataPack";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranchFilterValues";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionFilterValues";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeFilterValues";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionFilter2Presentation";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 19: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createBranchFilter";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createRevisionFilter";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createRangeFilter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findCommitId";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getBranchFilterValues";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getRevisionFilterValues";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getRangeFilterValues";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getRevisionFilter2Presentation";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "setBranchFilter";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterPresentation";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilterFromPresentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<? extends JComponent> myComponentCreator;

        FilterActionComponent(@NotNull Computable<? extends JComponent> componentCreator) {
            if (componentCreator == null) {
                FilterActionComponent.$$$reportNull$$$0(0);
            }
            this.myComponentCreator = componentCreator;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                FilterActionComponent.$$$reportNull$$$0(1);
            }
            if (place == null) {
                FilterActionComponent.$$$reportNull$$$0(2);
            }
            JComponent jComponent = (JComponent)this.myComponentCreator.compute();
            if (jComponent == null) {
                FilterActionComponent.$$$reportNull$$$0(3);
            }
            return jComponent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterActionComponent.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentCreator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

